/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.engine.JoinHelper;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EntityType;

public final class OuterJoinableAssociation {
    private final AssociationType joinableType;
    private final Joinable joinable;
    private final String lhsAlias;
    private final String[] lhsColumns;
    private final String rhsAlias;
    private final String[] rhsColumns;
    private final int joinType;
    private final String on;
    private final Map enabledFilters;

    public OuterJoinableAssociation(AssociationType associationType, String string, String[] stringArray, String string2, int n, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        this.joinableType = associationType;
        this.lhsAlias = string;
        this.lhsColumns = stringArray;
        this.rhsAlias = string2;
        this.joinType = n;
        this.joinable = associationType.getAssociatedJoinable(sessionFactoryImplementor);
        this.rhsColumns = JoinHelper.getRHSColumnNames(associationType, sessionFactoryImplementor);
        this.on = associationType.getOnCondition(string2, sessionFactoryImplementor, map);
        this.enabledFilters = map;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public String getRHSAlias() {
        return this.rhsAlias;
    }

    private boolean isOneToOne() {
        if (this.joinableType.isEntityType()) {
            EntityType entityType = (EntityType)this.joinableType;
            return entityType.isOneToOne();
        }
        return false;
    }

    public AssociationType getJoinableType() {
        return this.joinableType;
    }

    public String getRHSUniqueKeyName() {
        return this.joinableType.getRHSUniqueKeyPropertyName();
    }

    public boolean isCollection() {
        return this.joinableType.isCollectionType();
    }

    public Joinable getJoinable() {
        return this.joinable;
    }

    public int getOwner(List list) {
        if (this.isOneToOne() || this.isCollection()) {
            return OuterJoinableAssociation.getPosition(this.lhsAlias, list);
        }
        return -1;
    }

    private static int getPosition(String string, List list) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            OuterJoinableAssociation outerJoinableAssociation = (OuterJoinableAssociation)list.get(i);
            if (!outerJoinableAssociation.getJoinable().consumesEntityAlias()) continue;
            if (outerJoinableAssociation.rhsAlias.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void addJoins(JoinFragment joinFragment) throws MappingException {
        joinFragment.addJoin(this.joinable.getTableName(), this.rhsAlias, this.lhsColumns, this.rhsColumns, this.joinType, this.on);
        joinFragment.addJoins(this.joinable.fromJoinFragment(this.rhsAlias, false, true), this.joinable.whereJoinFragment(this.rhsAlias, false, true));
    }

    public void validateJoin(String string) throws MappingException {
        if (this.rhsColumns == null || this.lhsColumns == null || this.lhsColumns.length != this.rhsColumns.length || this.lhsColumns.length == 0) {
            throw new MappingException("invalid join columns for association: " + string);
        }
    }

    public boolean isManyToManyWith(OuterJoinableAssociation outerJoinableAssociation) {
        QueryableCollection queryableCollection;
        if (this.joinable.isCollection() && (queryableCollection = (QueryableCollection)this.joinable).isManyToMany()) {
            return queryableCollection.getElementType() == outerJoinableAssociation.getJoinableType();
        }
        return false;
    }

    public void addManyToManyJoin(JoinFragment joinFragment, QueryableCollection queryableCollection) throws MappingException {
        String string = queryableCollection.getManyToManyFilterFragment(this.rhsAlias, this.enabledFilters);
        String string2 = "".equals(string) ? this.on : ("".equals(this.on) ? string : this.on + " and " + string);
        joinFragment.addJoin(this.joinable.getTableName(), this.rhsAlias, this.lhsColumns, this.rhsColumns, this.joinType, string2);
        joinFragment.addJoins(this.joinable.fromJoinFragment(this.rhsAlias, false, true), this.joinable.whereJoinFragment(this.rhsAlias, false, true));
    }
}

