/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.cache.FilterKey;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.QueryKey;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.EntityUniqueKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.SubselectFetch;
import org.hibernate.engine.TwoPhaseLoad;
import org.hibernate.engine.TypedValue;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.impl.FetchingScrollableResultsImpl;
import org.hibernate.impl.ScrollableResultsImpl;
import org.hibernate.jdbc.ColumnNameCache;
import org.hibernate.jdbc.ResultSetWrapper;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;
import org.hibernate.util.StringHelper;

public abstract class Loader {
    private static final Log log = LogFactory.getLog((Class)Loader.class);
    private final SessionFactoryImplementor factory;
    private ColumnNameCache columnNameCache;

    public Loader(SessionFactoryImplementor sessionFactoryImplementor) {
        this.factory = sessionFactoryImplementor;
    }

    protected abstract String getSQLString();

    protected abstract Loadable[] getEntityPersisters();

    protected boolean[] getEntityEagerPropertyFetches() {
        return null;
    }

    protected int[] getOwners() {
        return null;
    }

    protected EntityType[] getOwnerAssociationTypes() {
        return null;
    }

    protected CollectionPersister[] getCollectionPersisters() {
        return null;
    }

    protected int[] getCollectionOwners() {
        return null;
    }

    protected abstract LockMode[] getLockModes(Map var1);

    protected String applyLocks(String string, Map map, Dialect dialect) throws HibernateException {
        return string;
    }

    protected boolean upgradeLocks() {
        return false;
    }

    protected boolean isSingleRowLoader() {
        return false;
    }

    protected String[] getAliases() {
        return null;
    }

    protected String preprocessSQL(String string, QueryParameters queryParameters, Dialect dialect) throws HibernateException {
        string = this.applyLocks(string, queryParameters.getLockModes(), dialect);
        return this.getFactory().getSettings().isCommentsEnabled() ? this.prependComment(string, queryParameters) : string;
    }

    private String prependComment(String string, QueryParameters queryParameters) {
        String string2 = queryParameters.getComment();
        if (string2 == null) {
            return string;
        }
        return new StringBuffer(string2.length() + string.length() + 5).append("/* ").append(string2).append(" */ ").append(string).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List doQueryAndInitializeNonLazyCollections(SessionImplementor sessionImplementor, QueryParameters queryParameters, boolean bl) throws HibernateException, SQLException {
        List list;
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        persistenceContext.beforeLoad();
        try {
            list = this.doQuery(sessionImplementor, queryParameters, bl);
        }
        finally {
            persistenceContext.afterLoad();
        }
        persistenceContext.initializeNonLazyCollections();
        return list;
    }

    public Object loadSingleRow(ResultSet resultSet, SessionImplementor sessionImplementor, QueryParameters queryParameters, boolean bl) throws HibernateException {
        Object object;
        int n = this.getEntityPersisters().length;
        ArrayList arrayList = n == 0 ? null : new ArrayList(n);
        try {
            object = this.getRowFromResultSet(resultSet, sessionImplementor, queryParameters, this.getLockModes(queryParameters.getLockModes()), null, arrayList, new EntityKey[n], bl);
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "could not read next row of results", this.getSQLString());
        }
        this.initializeEntitiesAndCollections(arrayList, resultSet, sessionImplementor, queryParameters.isReadOnly());
        sessionImplementor.getPersistenceContext().initializeNonLazyCollections();
        return object;
    }

    private Object sequentialLoad(ResultSet resultSet, SessionImplementor sessionImplementor, QueryParameters queryParameters, boolean bl, EntityKey entityKey) throws HibernateException {
        int n = this.getEntityPersisters().length;
        ArrayList arrayList = n == 0 ? null : new ArrayList(n);
        Object object = null;
        EntityKey[] entityKeyArray = new EntityKey[n];
        try {
            do {
                Object object2 = this.getRowFromResultSet(resultSet, sessionImplementor, queryParameters, this.getLockModes(queryParameters.getLockModes()), null, arrayList, entityKeyArray, bl);
                if (object != null) continue;
                object = object2;
            } while (entityKey.equals(entityKeyArray[0]) && resultSet.next());
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "could not perform sequential read of results (forward)", this.getSQLString());
        }
        this.initializeEntitiesAndCollections(arrayList, resultSet, sessionImplementor, queryParameters.isReadOnly());
        sessionImplementor.getPersistenceContext().initializeNonLazyCollections();
        return object;
    }

    public Object loadSequentialRowsForward(ResultSet resultSet, SessionImplementor sessionImplementor, QueryParameters queryParameters, boolean bl) throws HibernateException {
        try {
            if (resultSet.isAfterLast()) {
                return null;
            }
            if (resultSet.isBeforeFirst()) {
                resultSet.next();
            }
            EntityKey entityKey = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, sessionImplementor);
            return this.sequentialLoad(resultSet, sessionImplementor, queryParameters, bl, entityKey);
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "could not perform sequential read of results (forward)", this.getSQLString());
        }
    }

    public Object loadSequentialRowsReverse(ResultSet resultSet, SessionImplementor sessionImplementor, QueryParameters queryParameters, boolean bl, boolean bl2) throws HibernateException {
        try {
            EntityKey entityKey;
            if (resultSet.isFirst()) {
                return null;
            }
            EntityKey entityKey2 = null;
            if (resultSet.isAfterLast() && bl2) {
                resultSet.last();
                entityKey2 = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, sessionImplementor);
            } else {
                resultSet.previous();
                boolean bl3 = true;
                EntityKey entityKey3 = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, sessionImplementor);
                while (resultSet.previous()) {
                    EntityKey entityKey4 = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, sessionImplementor);
                    if (bl3) {
                        bl3 = false;
                        entityKey2 = entityKey4;
                    }
                    if (entityKey3.equals(entityKey4)) continue;
                }
            }
            while (resultSet.previous() && entityKey2.equals(entityKey = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, sessionImplementor))) {
            }
            resultSet.next();
            return this.sequentialLoad(resultSet, sessionImplementor, queryParameters, bl, entityKey2);
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "could not perform sequential read of results (forward)", this.getSQLString());
        }
    }

    private static EntityKey getOptionalObjectKey(QueryParameters queryParameters, SessionImplementor sessionImplementor) {
        Object object = queryParameters.getOptionalObject();
        Serializable serializable = queryParameters.getOptionalId();
        String string = queryParameters.getOptionalEntityName();
        if (object != null && string != null) {
            return new EntityKey(serializable, sessionImplementor.getEntityPersister(string, object), sessionImplementor.getEntityMode());
        }
        return null;
    }

    private Object getRowFromResultSet(ResultSet resultSet, SessionImplementor sessionImplementor, QueryParameters queryParameters, LockMode[] lockModeArray, EntityKey entityKey, List list, EntityKey[] entityKeyArray, boolean bl) throws SQLException, HibernateException {
        Loadable[] loadableArray = this.getEntityPersisters();
        int n = loadableArray.length;
        for (int i = 0; i < n; ++i) {
            entityKeyArray[i] = this.getKeyFromResultSet(i, loadableArray[i], i == n - 1 ? queryParameters.getOptionalId() : null, resultSet, sessionImplementor);
        }
        this.registerNonExists(entityKeyArray, loadableArray, sessionImplementor);
        Object[] objectArray = this.getRow(resultSet, loadableArray, entityKeyArray, queryParameters.getOptionalObject(), entityKey, lockModeArray, list, sessionImplementor);
        this.readCollectionElements(objectArray, resultSet, sessionImplementor);
        if (bl) {
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                Object object2 = sessionImplementor.getPersistenceContext().proxyFor(loadableArray[i], entityKeyArray[i], object);
                if (object == object2) continue;
                ((HibernateProxy)object2).getHibernateLazyInitializer().setImplementation(object);
                objectArray[i] = object2;
            }
        }
        return this.getResultColumnOrRow(objectArray, queryParameters.getResultTransformer(), resultSet, sessionImplementor);
    }

    private void readCollectionElements(Object[] objectArray, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        CollectionPersister[] collectionPersisterArray = this.getCollectionPersisters();
        if (collectionPersisterArray != null) {
            CollectionAliases[] collectionAliasesArray = this.getCollectionAliases();
            int[] nArray = this.getCollectionOwners();
            for (int i = 0; i < collectionPersisterArray.length; ++i) {
                boolean bl = nArray != null && nArray[i] > -1;
                Object object = bl ? objectArray[nArray[i]] : null;
                CollectionPersister collectionPersister = collectionPersisterArray[i];
                Serializable serializable = object == null ? null : collectionPersister.getCollectionType().getKeyOfOwner(object, sessionImplementor);
                this.readCollectionElement(object, serializable, collectionPersister, collectionAliasesArray[i], resultSet, sessionImplementor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List doQuery(SessionImplementor sessionImplementor, QueryParameters queryParameters, boolean bl) throws SQLException, HibernateException {
        RowSelection rowSelection = queryParameters.getRowSelection();
        int n = Loader.hasMaxRows(rowSelection) ? rowSelection.getMaxRows() : Integer.MAX_VALUE;
        int n2 = this.getEntityPersisters().length;
        ArrayList arrayList = n2 == 0 ? null : new ArrayList(n2 * 10);
        PreparedStatement preparedStatement = this.prepareQueryStatement(queryParameters, false, sessionImplementor);
        ResultSet resultSet = this.getResultSet(preparedStatement, queryParameters.hasAutoDiscoverScalarTypes(), queryParameters.isCallable(), rowSelection, sessionImplementor);
        LockMode[] lockModeArray = this.getLockModes(queryParameters.getLockModes());
        EntityKey entityKey = Loader.getOptionalObjectKey(queryParameters, sessionImplementor);
        boolean bl2 = this.isSubselectLoadingEnabled();
        ArrayList<EntityKey[]> arrayList2 = bl2 ? new ArrayList<EntityKey[]>() : null;
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        try {
            int n3;
            this.handleEmptyCollections(queryParameters.getCollectionKeys(), resultSet, sessionImplementor);
            EntityKey[] entityKeyArray = new EntityKey[n2];
            if (log.isTraceEnabled()) {
                log.trace((Object)"processing result set");
            }
            for (n3 = 0; n3 < n && resultSet.next(); ++n3) {
                if (log.isTraceEnabled()) {
                    log.debug((Object)("result set row: " + n3));
                }
                Object object = this.getRowFromResultSet(resultSet, sessionImplementor, queryParameters, lockModeArray, entityKey, arrayList, entityKeyArray, bl);
                arrayList3.add(object);
                if (!bl2) continue;
                arrayList2.add(entityKeyArray);
                entityKeyArray = new EntityKey[n2];
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("done processing result set (" + n3 + " rows)"));
            }
        }
        finally {
            sessionImplementor.getBatcher().closeQueryStatement(preparedStatement, resultSet);
        }
        this.initializeEntitiesAndCollections(arrayList, resultSet, sessionImplementor, queryParameters.isReadOnly());
        if (bl2) {
            this.createSubselects(arrayList2, queryParameters, sessionImplementor);
        }
        return arrayList3;
    }

    protected boolean isSubselectLoadingEnabled() {
        return false;
    }

    protected boolean hasSubselectLoadableCollections() {
        Loadable[] loadableArray = this.getEntityPersisters();
        for (int i = 0; i < loadableArray.length; ++i) {
            if (!loadableArray[i].hasSubselectLoadableCollections()) continue;
            return true;
        }
        return false;
    }

    private static Set[] transpose(List list) {
        Set[] setArray = new Set[((EntityKey[])list.get(0)).length];
        for (int i = 0; i < setArray.length; ++i) {
            setArray[i] = new HashSet(list.size());
            for (int j = 0; j < list.size(); ++j) {
                setArray[i].add(((EntityKey[])list.get(j))[i]);
            }
        }
        return setArray;
    }

    private void createSubselects(List list, QueryParameters queryParameters, SessionImplementor sessionImplementor) {
        if (list.size() > 1) {
            Set[] setArray = Loader.transpose(list);
            Map map = this.buildNamedParameterLocMap(queryParameters);
            Loadable[] loadableArray = this.getEntityPersisters();
            String[] stringArray = this.getAliases();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EntityKey[] entityKeyArray = (EntityKey[])iterator.next();
                for (int i = 0; i < entityKeyArray.length; ++i) {
                    if (entityKeyArray[i] == null || !loadableArray[i].hasSubselectLoadableCollections()) continue;
                    SubselectFetch subselectFetch = new SubselectFetch(stringArray[i], loadableArray[i], queryParameters, setArray[i], map);
                    sessionImplementor.getPersistenceContext().getBatchFetchQueue().addSubselect(entityKeyArray[i], subselectFetch);
                }
            }
        }
    }

    private Map buildNamedParameterLocMap(QueryParameters queryParameters) {
        if (queryParameters.getNamedParameters() != null) {
            HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
            Iterator iterator = queryParameters.getNamedParameters().keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashMap.put(string, this.getNamedParameterLocs(string));
            }
            return hashMap;
        }
        return null;
    }

    private void initializeEntitiesAndCollections(List list, Object object, SessionImplementor sessionImplementor, boolean bl) throws HibernateException {
        int n;
        PostLoadEvent postLoadEvent;
        PreLoadEvent preLoadEvent;
        CollectionPersister[] collectionPersisterArray = this.getCollectionPersisters();
        if (collectionPersisterArray != null) {
            for (int i = 0; i < collectionPersisterArray.length; ++i) {
                if (!collectionPersisterArray[i].isArray()) continue;
                this.endCollectionLoad(object, sessionImplementor, collectionPersisterArray[i]);
            }
        }
        if (sessionImplementor.isEventSource()) {
            preLoadEvent = new PreLoadEvent((EventSource)sessionImplementor);
            postLoadEvent = new PostLoadEvent((EventSource)sessionImplementor);
        } else {
            preLoadEvent = null;
            postLoadEvent = null;
        }
        if (list != null) {
            n = list.size();
            if (log.isTraceEnabled()) {
                log.trace((Object)("total objects hydrated: " + n));
            }
            for (int i = 0; i < n; ++i) {
                TwoPhaseLoad.initializeEntity(list.get(i), bl, sessionImplementor, preLoadEvent, postLoadEvent);
            }
        }
        if (collectionPersisterArray != null) {
            for (n = 0; n < collectionPersisterArray.length; ++n) {
                if (collectionPersisterArray[n].isArray()) continue;
                this.endCollectionLoad(object, sessionImplementor, collectionPersisterArray[n]);
            }
        }
    }

    private void endCollectionLoad(Object object, SessionImplementor sessionImplementor, CollectionPersister collectionPersister) {
        sessionImplementor.getPersistenceContext().getLoadContexts().getCollectionLoadContext((ResultSet)object).endLoadingCollections(collectionPersister);
    }

    protected List getResultList(List list, ResultTransformer resultTransformer) throws QueryException {
        return list;
    }

    protected Object getResultColumnOrRow(Object[] objectArray, ResultTransformer resultTransformer, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        return objectArray;
    }

    private void registerNonExists(EntityKey[] entityKeyArray, Loadable[] loadableArray, SessionImplementor sessionImplementor) {
        int[] nArray = this.getOwners();
        if (nArray != null) {
            EntityType[] entityTypeArray = this.getOwnerAssociationTypes();
            for (int i = 0; i < entityKeyArray.length; ++i) {
                boolean bl;
                int n = nArray[i];
                if (n <= -1) continue;
                EntityKey entityKey = entityKeyArray[n];
                if (entityKeyArray[i] != null || entityKey == null) continue;
                PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
                boolean bl2 = bl = entityTypeArray != null && entityTypeArray[i] != null && entityTypeArray[i].isOneToOne();
                if (!bl) continue;
                persistenceContext.addNullProperty(entityKey, entityTypeArray[i].getPropertyName());
            }
        }
    }

    private void readCollectionElement(Object object, Serializable serializable, CollectionPersister collectionPersister, CollectionAliases collectionAliases, ResultSet resultSet, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        Serializable serializable2 = (Serializable)collectionPersister.readKey(resultSet, collectionAliases.getSuffixedKeyAliases(), sessionImplementor);
        if (serializable2 != null) {
            PersistentCollection persistentCollection;
            Object object2;
            if (log.isDebugEnabled()) {
                log.debug((Object)("found row of collection: " + MessageHelper.collectionInfoString(collectionPersister, serializable2, this.getFactory())));
            }
            if ((object2 = object) != null || (object2 = persistenceContext.getCollectionOwner(serializable2, collectionPersister)) == null) {
                // empty if block
            }
            if ((persistentCollection = persistenceContext.getLoadContexts().getCollectionLoadContext(resultSet).getLoadingCollection(collectionPersister, serializable2)) != null) {
                persistentCollection.readFrom(resultSet, collectionPersister, collectionAliases, object2);
            }
        } else if (serializable != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("result set contains (possibly empty) collection: " + MessageHelper.collectionInfoString(collectionPersister, serializable, this.getFactory())));
            }
            persistenceContext.getLoadContexts().getCollectionLoadContext(resultSet).getLoadingCollection(collectionPersister, serializable);
        }
    }

    private void handleEmptyCollections(Serializable[] serializableArray, Object object, SessionImplementor sessionImplementor) {
        if (serializableArray != null) {
            CollectionPersister[] collectionPersisterArray = this.getCollectionPersisters();
            for (int i = 0; i < collectionPersisterArray.length; ++i) {
                for (int j = 0; j < serializableArray.length; ++j) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("result set contains (possibly empty) collection: " + MessageHelper.collectionInfoString(collectionPersisterArray[i], serializableArray[j], this.getFactory())));
                    }
                    sessionImplementor.getPersistenceContext().getLoadContexts().getCollectionLoadContext((ResultSet)object).getLoadingCollection(collectionPersisterArray[i], serializableArray[j]);
                }
            }
        }
    }

    private EntityKey getKeyFromResultSet(int n, Loadable loadable, Serializable serializable, ResultSet resultSet, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        Serializable serializable2;
        if (this.isSingleRowLoader() && serializable != null) {
            serializable2 = serializable;
        } else {
            boolean bl;
            Type type = loadable.getIdentifierType();
            serializable2 = (Serializable)type.nullSafeGet(resultSet, this.getEntityAliases()[n].getSuffixedKeyAliases(), sessionImplementor, null);
            boolean bl2 = bl = serializable != null && serializable2 != null && type.isEqual(serializable, serializable2, sessionImplementor.getEntityMode(), this.factory);
            if (bl) {
                serializable2 = serializable;
            }
        }
        return serializable2 == null ? null : new EntityKey(serializable2, loadable, sessionImplementor.getEntityMode());
    }

    private void checkVersion(int n, Loadable loadable, Serializable serializable, Object object, ResultSet resultSet, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        Object object2;
        VersionType versionType;
        Object object3 = sessionImplementor.getPersistenceContext().getEntry(object).getVersion();
        if (object3 != null && !(versionType = loadable.getVersionType()).isEqual(object3, object2 = versionType.nullSafeGet(resultSet, this.getEntityAliases()[n].getSuffixedVersionAliases(), sessionImplementor, null))) {
            if (sessionImplementor.getFactory().getStatistics().isStatisticsEnabled()) {
                sessionImplementor.getFactory().getStatisticsImplementor().optimisticFailure(loadable.getEntityName());
            }
            throw new StaleObjectStateException(loadable.getEntityName(), serializable);
        }
    }

    private Object[] getRow(ResultSet resultSet, Loadable[] loadableArray, EntityKey[] entityKeyArray, Object object, EntityKey entityKey, LockMode[] lockModeArray, List list, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        int n = loadableArray.length;
        EntityAliases[] entityAliasesArray = this.getEntityAliases();
        if (log.isDebugEnabled()) {
            log.debug((Object)("result row: " + StringHelper.toString(entityKeyArray)));
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object object2 = null;
            EntityKey entityKey2 = entityKeyArray[i];
            if (entityKeyArray[i] != null) {
                object2 = sessionImplementor.getEntityUsingInterceptor(entityKey2);
                if (object2 != null) {
                    this.instanceAlreadyLoaded(resultSet, i, loadableArray[i], entityKey2, object2, lockModeArray[i], sessionImplementor);
                } else {
                    object2 = this.instanceNotYetLoaded(resultSet, i, loadableArray[i], entityAliasesArray[i].getRowIdAlias(), entityKey2, lockModeArray[i], entityKey, object, list, sessionImplementor);
                }
            }
            objectArray[i] = object2;
        }
        return objectArray;
    }

    private void instanceAlreadyLoaded(ResultSet resultSet, int n, Loadable loadable, EntityKey entityKey, Object object, LockMode lockMode, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (!loadable.isInstance(object, sessionImplementor.getEntityMode())) {
            throw new WrongClassException("loaded object was of wrong class " + object.getClass(), entityKey.getIdentifier(), loadable.getEntityName());
        }
        if (LockMode.NONE != lockMode && this.upgradeLocks()) {
            boolean bl;
            boolean bl2 = bl = loadable.isVersioned() && sessionImplementor.getPersistenceContext().getEntry(object).getLockMode().lessThan(lockMode);
            if (bl) {
                this.checkVersion(n, loadable, entityKey.getIdentifier(), object, resultSet, sessionImplementor);
                sessionImplementor.getPersistenceContext().getEntry(object).setLockMode(lockMode);
            }
        }
    }

    private Object instanceNotYetLoaded(ResultSet resultSet, int n, Loadable loadable, String string, EntityKey entityKey, LockMode lockMode, EntityKey entityKey2, Object object, List list, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        String string2 = this.getInstanceClass(resultSet, n, loadable, entityKey.getIdentifier(), sessionImplementor);
        Object object2 = entityKey2 != null && entityKey.equals(entityKey2) ? object : sessionImplementor.instantiate(string2, entityKey.getIdentifier());
        LockMode lockMode2 = lockMode == LockMode.NONE ? LockMode.READ : lockMode;
        this.loadFromResultSet(resultSet, n, object2, string2, entityKey, string, lockMode2, loadable, sessionImplementor);
        list.add(object2);
        return object2;
    }

    private boolean isEagerPropertyFetchEnabled(int n) {
        boolean[] blArray = this.getEntityEagerPropertyFetches();
        return blArray != null && blArray[n];
    }

    private void loadFromResultSet(ResultSet resultSet, int n, Object object, String string, EntityKey entityKey, String string2, LockMode lockMode, Loadable loadable, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        String string3;
        boolean bl;
        Serializable serializable = entityKey.getIdentifier();
        Loadable loadable2 = (Loadable)this.getFactory().getEntityPersister(string);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Initializing object from ResultSet: " + MessageHelper.infoString((EntityPersister)loadable2, serializable, this.getFactory())));
        }
        TwoPhaseLoad.addUninitializedEntity(entityKey, object, loadable2, lockMode, !(bl = this.isEagerPropertyFetchEnabled(n)), sessionImplementor);
        String[][] stringArray = loadable2 == loadable ? this.getEntityAliases()[n].getSuffixedPropertyAliases() : this.getEntityAliases()[n].getSuffixedPropertyAliases(loadable2);
        Object[] objectArray = loadable2.hydrate(resultSet, serializable, object, loadable, stringArray, bl, sessionImplementor);
        Object object2 = loadable2.hasRowId() ? resultSet.getObject(string2) : null;
        EntityType[] entityTypeArray = this.getOwnerAssociationTypes();
        if (entityTypeArray != null && entityTypeArray[n] != null && (string3 = entityTypeArray[n].getRHSUniqueKeyPropertyName()) != null) {
            int n2 = ((UniqueKeyLoadable)loadable2).getPropertyIndex(string3);
            Type type = loadable2.getPropertyTypes()[n2];
            EntityUniqueKey entityUniqueKey = new EntityUniqueKey(loadable.getEntityName(), string3, type.semiResolve(objectArray[n2], sessionImplementor, object), type, sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
            sessionImplementor.getPersistenceContext().addEntity(entityUniqueKey, object);
        }
        TwoPhaseLoad.postHydrate(loadable2, serializable, objectArray, object2, object, lockMode, !bl, sessionImplementor);
    }

    private String getInstanceClass(ResultSet resultSet, int n, Loadable loadable, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (loadable.hasSubclasses()) {
            Object object = loadable.getDiscriminatorType().nullSafeGet(resultSet, this.getEntityAliases()[n].getSuffixedDiscriminatorAlias(), sessionImplementor, null);
            String string = loadable.getSubclassForDiscriminatorValue(object);
            if (string == null) {
                throw new WrongClassException("Discriminator: " + object, serializable, loadable.getEntityName());
            }
            return string;
        }
        return loadable.getEntityName();
    }

    private void advance(ResultSet resultSet, RowSelection rowSelection) throws SQLException {
        int n = Loader.getFirstRow(rowSelection);
        if (n != 0) {
            if (this.getFactory().getSettings().isScrollableResultSetsEnabled()) {
                resultSet.absolute(n);
            } else {
                for (int i = 0; i < n; ++i) {
                    resultSet.next();
                }
            }
        }
    }

    private static boolean hasMaxRows(RowSelection rowSelection) {
        return rowSelection != null && rowSelection.getMaxRows() != null;
    }

    private static int getFirstRow(RowSelection rowSelection) {
        if (rowSelection == null || rowSelection.getFirstRow() == null) {
            return 0;
        }
        return rowSelection.getFirstRow();
    }

    private static boolean useLimit(RowSelection rowSelection, Dialect dialect) {
        return dialect.supportsLimit() && Loader.hasMaxRows(rowSelection);
    }

    protected final PreparedStatement prepareQueryStatement(QueryParameters queryParameters, boolean bl, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        ScrollMode scrollMode;
        String string = this.processFilters(queryParameters, sessionImplementor);
        Dialect dialect = this.getFactory().getDialect();
        RowSelection rowSelection = queryParameters.getRowSelection();
        boolean bl2 = Loader.useLimit(rowSelection, dialect);
        boolean bl3 = Loader.getFirstRow(rowSelection) > 0;
        boolean bl4 = bl3 && bl2 && dialect.supportsLimitOffset();
        boolean bl5 = queryParameters.isCallable();
        boolean bl6 = bl3 && !bl4 && this.getFactory().getSettings().isScrollableResultSetsEnabled();
        ScrollMode scrollMode2 = scrollMode = bl ? queryParameters.getScrollMode() : ScrollMode.SCROLL_INSENSITIVE;
        if (bl2) {
            string = dialect.getLimitString(string.trim(), bl4 ? Loader.getFirstRow(rowSelection) : 0, Loader.getMaxOrLimit(rowSelection, dialect));
        }
        string = this.preprocessSQL(string, queryParameters, dialect);
        PreparedStatement preparedStatement = null;
        preparedStatement = bl5 ? sessionImplementor.getBatcher().prepareCallableQueryStatement(string, bl || bl6, scrollMode) : sessionImplementor.getBatcher().prepareQueryStatement(string, bl || bl6, scrollMode);
        try {
            int n = 1;
            if (bl2 && dialect.bindLimitParametersFirst()) {
                n += this.bindLimitParameters(preparedStatement, n, rowSelection);
            }
            if (bl5) {
                n = dialect.registerResultSetOutParameter((CallableStatement)preparedStatement, n);
            }
            n += this.bindParameterValues(preparedStatement, queryParameters, n, sessionImplementor);
            if (bl2 && !dialect.bindLimitParametersFirst()) {
                n += this.bindLimitParameters(preparedStatement, n, rowSelection);
            }
            if (!bl2) {
                this.setMaxRows(preparedStatement, rowSelection);
            }
            if (rowSelection != null) {
                if (rowSelection.getTimeout() != null) {
                    preparedStatement.setQueryTimeout(rowSelection.getTimeout());
                }
                if (rowSelection.getFetchSize() != null) {
                    preparedStatement.setFetchSize(rowSelection.getFetchSize());
                }
            }
        }
        catch (SQLException sQLException) {
            sessionImplementor.getBatcher().closeQueryStatement(preparedStatement, null);
            throw sQLException;
        }
        catch (HibernateException hibernateException) {
            sessionImplementor.getBatcher().closeQueryStatement(preparedStatement, null);
            throw hibernateException;
        }
        return preparedStatement;
    }

    protected String processFilters(QueryParameters queryParameters, SessionImplementor sessionImplementor) {
        queryParameters.processFilters(this.getSQLString(), sessionImplementor);
        return queryParameters.getFilteredSQL();
    }

    private static int getMaxOrLimit(RowSelection rowSelection, Dialect dialect) {
        int n = Loader.getFirstRow(rowSelection);
        int n2 = rowSelection.getMaxRows();
        if (dialect.useMaxForLimit()) {
            return n2 + n;
        }
        return n2;
    }

    private int bindLimitParameters(PreparedStatement preparedStatement, int n, RowSelection rowSelection) throws SQLException {
        Dialect dialect = this.getFactory().getDialect();
        if (!dialect.supportsVariableLimit()) {
            return 0;
        }
        if (!Loader.hasMaxRows(rowSelection)) {
            throw new AssertionFailure("no max results set");
        }
        int n2 = Loader.getFirstRow(rowSelection);
        int n3 = Loader.getMaxOrLimit(rowSelection, dialect);
        boolean bl = n2 > 0 && dialect.supportsLimitOffset();
        boolean bl2 = dialect.bindLimitParametersInReverseOrder();
        if (bl) {
            preparedStatement.setInt(n + (bl2 ? 1 : 0), n2);
        }
        preparedStatement.setInt(n + (bl2 || !bl ? 0 : 1), n3);
        return bl ? 2 : 1;
    }

    private void setMaxRows(PreparedStatement preparedStatement, RowSelection rowSelection) throws SQLException {
        if (Loader.hasMaxRows(rowSelection)) {
            preparedStatement.setMaxRows(rowSelection.getMaxRows() + Loader.getFirstRow(rowSelection));
        }
    }

    protected int bindParameterValues(PreparedStatement preparedStatement, QueryParameters queryParameters, int n, SessionImplementor sessionImplementor) throws SQLException {
        int n2 = 0;
        n2 += this.bindPositionalParameters(preparedStatement, queryParameters, n, sessionImplementor);
        n2 += this.bindNamedParameters(preparedStatement, queryParameters.getNamedParameters(), n + n2, sessionImplementor);
        return n2;
    }

    protected int bindPositionalParameters(PreparedStatement preparedStatement, QueryParameters queryParameters, int n, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        Object[] objectArray = queryParameters.getFilteredPositionalParameterValues();
        Type[] typeArray = queryParameters.getFilteredPositionalParameterTypes();
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            typeArray[i].nullSafeSet(preparedStatement, objectArray[i], n + n2, sessionImplementor);
            n2 += typeArray[i].getColumnSpan(this.getFactory());
        }
        return n2;
    }

    protected int bindNamedParameters(PreparedStatement preparedStatement, Map map, int n, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                TypedValue typedValue = (TypedValue)entry.getValue();
                int[] nArray = this.getNamedParameterLocs(string);
                for (int i = 0; i < nArray.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("bindNamedParameters() " + typedValue.getValue() + " -> " + string + " [" + (nArray[i] + n) + "]"));
                    }
                    typedValue.getType().nullSafeSet(preparedStatement, typedValue.getValue(), nArray[i] + n, sessionImplementor);
                }
                n2 += nArray.length;
            }
            return n2;
        }
        return 0;
    }

    public int[] getNamedParameterLocs(String string) {
        throw new AssertionFailure("no named parameters");
    }

    protected final ResultSet getResultSet(PreparedStatement preparedStatement, boolean bl, boolean bl2, RowSelection rowSelection, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        ResultSet resultSet = null;
        try {
            Dialect dialect = this.getFactory().getDialect();
            resultSet = bl2 ? sessionImplementor.getBatcher().getResultSet((CallableStatement)preparedStatement, dialect) : sessionImplementor.getBatcher().getResultSet(preparedStatement);
            resultSet = this.wrapResultSetIfEnabled(resultSet, sessionImplementor);
            if (!dialect.supportsLimitOffset() || !Loader.useLimit(rowSelection, dialect)) {
                this.advance(resultSet, rowSelection);
            }
            if (bl) {
                this.autoDiscoverTypes(resultSet);
            }
            return resultSet;
        }
        catch (SQLException sQLException) {
            sessionImplementor.getBatcher().closeQueryStatement(preparedStatement, resultSet);
            throw sQLException;
        }
    }

    protected void autoDiscoverTypes(ResultSet resultSet) {
        throw new AssertionFailure("Auto discover types not supported in this loader");
    }

    private synchronized ResultSet wrapResultSetIfEnabled(ResultSet resultSet, SessionImplementor sessionImplementor) {
        if (sessionImplementor.getFactory().getSettings().isWrapResultSetsEnabled()) {
            try {
                log.debug((Object)("Wrapping result set [" + resultSet + "]"));
                return new ResultSetWrapper(resultSet, this.retreiveColumnNameToIndexCache(resultSet));
            }
            catch (SQLException sQLException) {
                log.info((Object)"Error wrapping result set", (Throwable)sQLException);
                return resultSet;
            }
        }
        return resultSet;
    }

    private ColumnNameCache retreiveColumnNameToIndexCache(ResultSet resultSet) throws SQLException {
        if (this.columnNameCache == null) {
            log.trace((Object)"Building columnName->columnIndex cache");
            this.columnNameCache = new ColumnNameCache(resultSet.getMetaData().getColumnCount());
        }
        return this.columnNameCache;
    }

    protected final List loadEntity(SessionImplementor sessionImplementor, Object object, Type type, Object object2, String string, Serializable serializable, EntityPersister entityPersister) throws HibernateException {
        List list;
        if (log.isDebugEnabled()) {
            log.debug((Object)("loading entity: " + MessageHelper.infoString(entityPersister, object, type, this.getFactory())));
        }
        try {
            list = this.doQueryAndInitializeNonLazyCollections(sessionImplementor, new QueryParameters(new Type[]{type}, new Object[]{object}, object2, string, serializable), false);
        }
        catch (SQLException sQLException) {
            Loadable[] loadableArray = this.getEntityPersisters();
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "could not load an entity: " + MessageHelper.infoString(loadableArray[loadableArray.length - 1], object, type, this.getFactory()), this.getSQLString());
        }
        log.debug((Object)"done entity load");
        return list;
    }

    protected final List loadEntity(SessionImplementor sessionImplementor, Object object, Object object2, Type type, Type type2, EntityPersister entityPersister) throws HibernateException {
        List list;
        if (log.isDebugEnabled()) {
            log.debug((Object)"loading collection element by index");
        }
        try {
            list = this.doQueryAndInitializeNonLazyCollections(sessionImplementor, new QueryParameters(new Type[]{type, type2}, new Object[]{object, object2}), false);
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "could not collection element by index", this.getSQLString());
        }
        log.debug((Object)"done entity load");
        return list;
    }

    public final List loadEntityBatch(SessionImplementor sessionImplementor, Serializable[] serializableArray, Type type, Object object, String string, Serializable serializable, EntityPersister entityPersister) throws HibernateException {
        List list;
        if (log.isDebugEnabled()) {
            log.debug((Object)("batch loading entity: " + MessageHelper.infoString(entityPersister, serializableArray, this.getFactory())));
        }
        Object[] objectArray = new Type[serializableArray.length];
        Arrays.fill(objectArray, type);
        try {
            list = this.doQueryAndInitializeNonLazyCollections(sessionImplementor, new QueryParameters((Type[])objectArray, serializableArray, object, string, serializable), false);
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "could not load an entity batch: " + MessageHelper.infoString((EntityPersister)this.getEntityPersisters()[0], serializableArray, this.getFactory()), this.getSQLString());
        }
        log.debug((Object)"done entity batch load");
        return list;
    }

    public final void loadCollection(SessionImplementor sessionImplementor, Serializable serializable, Type type) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("loading collection: " + MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], serializable, this.getFactory())));
        }
        Object[] objectArray = new Serializable[]{serializable};
        try {
            this.doQueryAndInitializeNonLazyCollections(sessionImplementor, new QueryParameters(new Type[]{type}, objectArray, (Serializable[])objectArray), true);
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "could not initialize a collection: " + MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], serializable, this.getFactory()), this.getSQLString());
        }
        log.debug((Object)"done loading collection");
    }

    public final void loadCollectionBatch(SessionImplementor sessionImplementor, Serializable[] serializableArray, Type type) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("batch loading collection: " + MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], serializableArray, this.getFactory())));
        }
        Object[] objectArray = new Type[serializableArray.length];
        Arrays.fill(objectArray, type);
        try {
            this.doQueryAndInitializeNonLazyCollections(sessionImplementor, new QueryParameters((Type[])objectArray, serializableArray, serializableArray), true);
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "could not initialize a collection batch: " + MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], serializableArray, this.getFactory()), this.getSQLString());
        }
        log.debug((Object)"done batch load");
    }

    protected final void loadCollectionSubselect(SessionImplementor sessionImplementor, Serializable[] serializableArray, Object[] objectArray, Type[] typeArray, Map map, Type type) throws HibernateException {
        Object[] objectArray2 = new Type[serializableArray.length];
        Arrays.fill(objectArray2, type);
        try {
            this.doQueryAndInitializeNonLazyCollections(sessionImplementor, new QueryParameters(typeArray, objectArray, map, serializableArray), true);
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "could not load collection by subselect: " + MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], serializableArray, this.getFactory()), this.getSQLString());
        }
    }

    protected List list(SessionImplementor sessionImplementor, QueryParameters queryParameters, Set set, Type[] typeArray) throws HibernateException {
        boolean bl;
        boolean bl2 = bl = this.factory.getSettings().isQueryCacheEnabled() && queryParameters.isCacheable();
        if (bl) {
            return this.listUsingQueryCache(sessionImplementor, queryParameters, set, typeArray);
        }
        return this.listIgnoreQueryCache(sessionImplementor, queryParameters);
    }

    private List listIgnoreQueryCache(SessionImplementor sessionImplementor, QueryParameters queryParameters) {
        return this.getResultList(this.doList(sessionImplementor, queryParameters), queryParameters.getResultTransformer());
    }

    private List listUsingQueryCache(SessionImplementor sessionImplementor, QueryParameters queryParameters, Set set, Type[] typeArray) {
        QueryCache queryCache = this.factory.getQueryCache(queryParameters.getCacheRegion());
        Set set2 = FilterKey.createFilterKeys(sessionImplementor.getEnabledFilters(), sessionImplementor.getEntityMode());
        QueryKey queryKey = new QueryKey(this.getSQLString(), queryParameters, set2, sessionImplementor.getEntityMode());
        List list = this.getResultFromQueryCache(sessionImplementor, queryParameters, set, typeArray, queryCache, queryKey);
        if (list == null) {
            list = this.doList(sessionImplementor, queryParameters);
            this.putResultInQueryCache(sessionImplementor, queryParameters, typeArray, queryCache, queryKey, list);
        }
        return this.getResultList(list, queryParameters.getResultTransformer());
    }

    private List getResultFromQueryCache(SessionImplementor sessionImplementor, QueryParameters queryParameters, Set set, Type[] typeArray, QueryCache queryCache, QueryKey queryKey) {
        List list = null;
        if (sessionImplementor.getCacheMode().isGetEnabled()) {
            list = queryCache.get(queryKey, typeArray, queryParameters.isNaturalKeyLookup(), set, sessionImplementor);
            if (this.factory.getStatistics().isStatisticsEnabled()) {
                if (list == null) {
                    this.factory.getStatisticsImplementor().queryCacheMiss(this.getQueryIdentifier(), queryCache.getRegionName());
                } else {
                    this.factory.getStatisticsImplementor().queryCacheHit(this.getQueryIdentifier(), queryCache.getRegionName());
                }
            }
        }
        return list;
    }

    private void putResultInQueryCache(SessionImplementor sessionImplementor, QueryParameters queryParameters, Type[] typeArray, QueryCache queryCache, QueryKey queryKey, List list) {
        boolean bl;
        if (sessionImplementor.getCacheMode().isPutEnabled() && (bl = queryCache.put(queryKey, typeArray, list, queryParameters.isNaturalKeyLookup(), sessionImplementor)) && this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().queryCachePut(this.getQueryIdentifier(), queryCache.getRegionName());
        }
    }

    protected List doList(SessionImplementor sessionImplementor, QueryParameters queryParameters) throws HibernateException {
        List list;
        boolean bl = this.getFactory().getStatistics().isStatisticsEnabled();
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        try {
            list = this.doQueryAndInitializeNonLazyCollections(sessionImplementor, queryParameters, true);
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "could not execute query", this.getSQLString());
        }
        if (bl) {
            this.getFactory().getStatisticsImplementor().queryExecuted(this.getQueryIdentifier(), list.size(), System.currentTimeMillis() - l);
        }
        return list;
    }

    protected void checkScrollability() throws HibernateException {
    }

    protected boolean needsFetchingScroll() {
        return false;
    }

    protected ScrollableResults scroll(QueryParameters queryParameters, Type[] typeArray, HolderInstantiator holderInstantiator, SessionImplementor sessionImplementor) throws HibernateException {
        this.checkScrollability();
        boolean bl = this.getQueryIdentifier() != null && this.getFactory().getStatistics().isStatisticsEnabled();
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        try {
            PreparedStatement preparedStatement = this.prepareQueryStatement(queryParameters, true, sessionImplementor);
            ResultSet resultSet = this.getResultSet(preparedStatement, queryParameters.hasAutoDiscoverScalarTypes(), queryParameters.isCallable(), queryParameters.getRowSelection(), sessionImplementor);
            if (bl) {
                this.getFactory().getStatisticsImplementor().queryExecuted(this.getQueryIdentifier(), 0, System.currentTimeMillis() - l);
            }
            if (this.needsFetchingScroll()) {
                return new FetchingScrollableResultsImpl(resultSet, preparedStatement, sessionImplementor, this, queryParameters, typeArray, holderInstantiator);
            }
            return new ScrollableResultsImpl(resultSet, preparedStatement, sessionImplementor, this, queryParameters, typeArray, holderInstantiator);
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "could not execute query using scroll", this.getSQLString());
        }
    }

    protected void postInstantiate() {
    }

    protected abstract EntityAliases[] getEntityAliases();

    protected abstract CollectionAliases[] getCollectionAliases();

    protected String getQueryIdentifier() {
        return null;
    }

    public final SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getSQLString() + ')';
    }
}

