/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.Map;
import org.hibernate.loader.EntityAliases;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.util.CollectionHelper;

public class DefaultEntityAliases
implements EntityAliases {
    private final String[] suffixedKeyColumns;
    private final String[] suffixedVersionColumn;
    private final String[][] suffixedPropertyColumns;
    private final String suffixedDiscriminatorColumn;
    private final String suffix;
    private final String rowIdAlias;
    private final Map userProvidedAliases;

    public DefaultEntityAliases(Loadable loadable, String string) {
        this(CollectionHelper.EMPTY_MAP, loadable, string);
    }

    public DefaultEntityAliases(Map map, Loadable loadable, String string) {
        this.suffix = string;
        this.userProvidedAliases = map;
        String[] stringArray = this.getUserProvidedAliases(loadable.getIdentifierPropertyName(), null);
        this.suffixedKeyColumns = stringArray == null ? this.getUserProvidedAliases("id", this.getIdentifierAliases(loadable, string)) : stringArray;
        DefaultEntityAliases.intern(this.suffixedKeyColumns);
        this.suffixedPropertyColumns = this.getSuffixedPropertyAliases(loadable);
        this.suffixedDiscriminatorColumn = this.getUserProvidedAlias("class", this.getDiscriminatorAlias(loadable, string));
        this.suffixedVersionColumn = loadable.isVersioned() ? this.suffixedPropertyColumns[loadable.getVersionProperty()] : null;
        this.rowIdAlias = "rowid_" + string;
    }

    protected String getDiscriminatorAlias(Loadable loadable, String string) {
        return loadable.getDiscriminatorAlias(string);
    }

    protected String[] getIdentifierAliases(Loadable loadable, String string) {
        return loadable.getIdentifierAliases(string);
    }

    protected String[] getPropertyAliases(Loadable loadable, int n) {
        return loadable.getPropertyAliases(this.suffix, n);
    }

    private String[] getUserProvidedAliases(String string, String[] stringArray) {
        String[] stringArray2 = (String[])this.userProvidedAliases.get(string);
        if (stringArray2 == null) {
            return stringArray;
        }
        return stringArray2;
    }

    private String getUserProvidedAlias(String string, String string2) {
        String[] stringArray = (String[])this.userProvidedAliases.get(string);
        if (stringArray == null) {
            return string2;
        }
        return stringArray[0];
    }

    public String[][] getSuffixedPropertyAliases(Loadable loadable) {
        int n = loadable.getPropertyNames().length;
        String[][] stringArray = new String[n][];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getUserProvidedAliases(loadable.getPropertyNames()[i], this.getPropertyAliases(loadable, i));
            DefaultEntityAliases.intern(stringArray[i]);
        }
        return stringArray;
    }

    public String[] getSuffixedVersionAliases() {
        return this.suffixedVersionColumn;
    }

    public String[][] getSuffixedPropertyAliases() {
        return this.suffixedPropertyColumns;
    }

    public String getSuffixedDiscriminatorAlias() {
        return this.suffixedDiscriminatorColumn;
    }

    public String[] getSuffixedKeyAliases() {
        return this.suffixedKeyColumns;
    }

    public String getRowIdAlias() {
        return this.rowIdAlias;
    }

    private static void intern(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].intern();
        }
    }
}

