/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.ArrayList;
import java.util.Map;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.JoinWalker;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.type.AssociationType;
import org.hibernate.util.CollectionHelper;

public abstract class AbstractEntityJoinWalker
extends JoinWalker {
    private final OuterJoinLoadable persister;
    private String alias;

    public AbstractEntityJoinWalker(OuterJoinLoadable outerJoinLoadable, SessionFactoryImplementor sessionFactoryImplementor, Map map) {
        super(sessionFactoryImplementor, map);
        this.persister = outerJoinLoadable;
        this.alias = this.generateRootAlias(outerJoinLoadable.getEntityName());
    }

    protected final void initAll(String string, String string2, LockMode lockMode) throws MappingException {
        this.walkEntityTree(this.persister, this.getAlias());
        ArrayList<OuterJoinableAssociation> arrayList = new ArrayList<OuterJoinableAssociation>();
        arrayList.addAll(this.associations);
        arrayList.add(new OuterJoinableAssociation(this.persister.getEntityType(), null, null, this.alias, 1, this.getFactory(), CollectionHelper.EMPTY_MAP));
        this.initPersisters(arrayList, lockMode);
        this.initStatementString(string, string2, lockMode);
    }

    protected final void initProjection(String string, String string2, String string3, String string4, LockMode lockMode) throws MappingException {
        this.walkEntityTree(this.persister, this.getAlias());
        this.persisters = new Loadable[0];
        this.initStatementString(string, string2, string3, string4, lockMode);
    }

    private void initStatementString(String string, String string2, LockMode lockMode) throws MappingException {
        this.initStatementString(null, string, string2, "", lockMode);
    }

    private void initStatementString(String string, String string2, String string3, String string4, LockMode lockMode) throws MappingException {
        int n = AbstractEntityJoinWalker.countEntityPersisters(this.associations);
        this.suffixes = BasicLoader.generateSuffixes(n + 1);
        JoinFragment joinFragment = this.mergeOuterJoins(this.associations);
        Select select = new Select(this.getDialect()).setLockMode(lockMode).setSelectClause(string == null ? this.persister.selectFragment(this.alias, this.suffixes[n]) + this.selectString(this.associations) : string).setFromClause(this.getDialect().appendLockHint(lockMode, this.persister.fromTableFragment(this.alias)) + this.persister.fromJoinFragment(this.alias, true, true)).setWhereClause(string2).setOuterJoins(joinFragment.toFromFragmentString(), joinFragment.toWhereFragmentString() + this.getWhereFragment()).setOrderByClause(this.orderBy(this.associations, string3)).setGroupByClause(string4);
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment(this.getComment());
        }
        this.sql = select.toStatementString();
    }

    protected String getWhereFragment() throws MappingException {
        return this.persister.whereJoinFragment(this.alias, true, true);
    }

    protected boolean isJoinedFetchEnabled(AssociationType associationType, FetchMode fetchMode, CascadeStyle cascadeStyle) {
        return this.isJoinedFetchEnabledInMapping(fetchMode, associationType);
    }

    public abstract String getComment();

    protected final Loadable getPersister() {
        return this.persister;
    }

    protected final String getAlias() {
        return this.alias;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getPersister().getEntityName() + ')';
    }
}

