/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jmx;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.classic.Session;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.impl.SessionFactoryObjectFactory;
import org.hibernate.jmx.HibernateService;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.stat.Statistics;

public class SessionFactoryStub
implements SessionFactory {
    private static final Log log = LogFactory.getLog((Class)SessionFactoryStub.class);
    private static final IdentifierGenerator UUID_GENERATOR = new UUIDHexGenerator();
    private transient SessionFactory impl;
    private transient HibernateService service;
    private String uuid;
    private String name;

    SessionFactoryStub(HibernateService hibernateService) {
        this.service = hibernateService;
        this.name = hibernateService.getJndiName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryObjectFactory.addInstance(this.uuid, this.name, this, hibernateService.getProperties());
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.getImpl().openSession(connection, interceptor);
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        return this.getImpl().openSession(interceptor);
    }

    public Session openSession() throws HibernateException {
        return this.getImpl().openSession();
    }

    public Session openSession(Connection connection) {
        return this.getImpl().openSession(connection);
    }

    public Session getCurrentSession() {
        return this.getImpl().getCurrentSession();
    }

    private synchronized SessionFactory getImpl() {
        if (this.impl == null) {
            this.impl = this.service.buildSessionFactory();
        }
        return this.impl;
    }

    private Object readResolve() throws ObjectStreamException {
        Object object = SessionFactoryObjectFactory.getInstance(this.uuid);
        if (object == null) {
            object = SessionFactoryObjectFactory.getNamedInstance(this.name);
            if (object == null) {
                throw new InvalidObjectException("Could not find a stub SessionFactory named: " + this.name);
            }
            log.debug((Object)"resolved stub SessionFactory by name");
        } else {
            log.debug((Object)"resolved stub SessionFactory by uid");
        }
        return object;
    }

    public Reference getReference() throws NamingException {
        return new Reference(SessionFactoryStub.class.getName(), new StringRefAddr("uuid", this.uuid), SessionFactoryObjectFactory.class.getName(), null);
    }

    public ClassMetadata getClassMetadata(Class clazz) throws HibernateException {
        return this.getImpl().getClassMetadata(clazz);
    }

    public ClassMetadata getClassMetadata(String string) throws HibernateException {
        return this.getImpl().getClassMetadata(string);
    }

    public CollectionMetadata getCollectionMetadata(String string) throws HibernateException {
        return this.getImpl().getCollectionMetadata(string);
    }

    public Map getAllClassMetadata() throws HibernateException {
        return this.getImpl().getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return this.getImpl().getAllCollectionMetadata();
    }

    public void close() throws HibernateException {
    }

    public boolean isClosed() {
        return false;
    }

    public void evict(Class clazz, Serializable serializable) throws HibernateException {
        this.getImpl().evict(clazz, serializable);
    }

    public void evict(Class clazz) throws HibernateException {
        this.getImpl().evict(clazz);
    }

    public void evictEntity(String string, Serializable serializable) throws HibernateException {
        this.getImpl().evictEntity(string, serializable);
    }

    public void evictEntity(String string) throws HibernateException {
        this.getImpl().evictEntity(string);
    }

    public void evictCollection(String string, Serializable serializable) throws HibernateException {
        this.getImpl().evictCollection(string, serializable);
    }

    public void evictCollection(String string) throws HibernateException {
        this.getImpl().evictCollection(string);
    }

    public void evictQueries() throws HibernateException {
        this.getImpl().evictQueries();
    }

    public void evictQueries(String string) throws HibernateException {
        this.getImpl().evictQueries(string);
    }

    public Statistics getStatistics() {
        return this.getImpl().getStatistics();
    }

    public StatelessSession openStatelessSession() {
        return this.getImpl().openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return this.getImpl().openStatelessSession(connection);
    }

    public Set getDefinedFilterNames() {
        return this.getImpl().getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String string) throws HibernateException {
        return this.getImpl().getFilterDefinition(string);
    }
}

