/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jmx;

import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.jmx.HibernateServiceMBean;
import org.hibernate.jmx.SessionFactoryStub;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.util.ExternalSessionFactoryConfig;
import org.hibernate.util.NamingHelper;

public class HibernateService
extends ExternalSessionFactoryConfig
implements HibernateServiceMBean {
    private static final Log log = LogFactory.getLog((Class)HibernateServiceMBean.class);
    private String boundName;
    private Properties properties = new Properties();

    public void start() throws HibernateException {
        this.boundName = this.getJndiName();
        try {
            this.buildSessionFactory();
        }
        catch (HibernateException hibernateException) {
            log.info((Object)("Could not build SessionFactory using the MBean classpath - will try again using client classpath: " + hibernateException.getMessage()));
            log.debug((Object)"Error was", (Throwable)hibernateException);
            new SessionFactoryStub(this);
        }
    }

    public void stop() {
        log.info((Object)"stopping service");
        try {
            InitialContext initialContext = NamingHelper.getInitialContext(this.buildProperties());
            ((SessionFactory)initialContext.lookup(this.boundName)).close();
        }
        catch (Exception exception) {
            log.warn((Object)"exception while stopping service", (Throwable)exception);
        }
    }

    SessionFactory buildSessionFactory() throws HibernateException {
        log.info((Object)("starting service at JNDI name: " + this.boundName));
        log.info((Object)("service properties: " + this.properties));
        return this.buildConfiguration().buildSessionFactory();
    }

    protected Map getExtraProperties() {
        return this.properties;
    }

    public String getTransactionStrategy() {
        return this.getProperty("hibernate.transaction.factory_class");
    }

    public void setTransactionStrategy(String string) {
        this.setProperty("hibernate.transaction.factory_class", string);
    }

    public String getUserTransactionName() {
        return this.getProperty("jta.UserTransaction");
    }

    public void setUserTransactionName(String string) {
        this.setProperty("jta.UserTransaction", string);
    }

    public String getTransactionManagerLookupStrategy() {
        return this.getProperty("hibernate.transaction.manager_lookup_class");
    }

    public void setTransactionManagerLookupStrategy(String string) {
        this.setProperty("hibernate.transaction.manager_lookup_class", string);
    }

    public String getPropertyList() {
        return this.buildProperties().toString();
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public void dropSchema() {
        new SchemaExport(this.buildConfiguration()).drop(false, true);
    }

    public void createSchema() {
        new SchemaExport(this.buildConfiguration()).create(false, true);
    }

    public String getName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    public String getDatasource() {
        return this.getProperty("hibernate.connection.datasource");
    }

    public void setDatasource(String string) {
        this.setProperty("hibernate.connection.datasource", string);
    }

    public String getJndiName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    public void setJndiName(String string) {
        this.setProperty("hibernate.session_factory_name", string);
    }

    public String getUserName() {
        return this.getProperty("hibernate.connection.username");
    }

    public void setUserName(String string) {
        this.setProperty("hibernate.connection.username", string);
    }

    public String getPassword() {
        return this.getProperty("hibernate.connection.password");
    }

    public void setPassword(String string) {
        this.setProperty("hibernate.connection.password", string);
    }

    public void setFlushBeforeCompletionEnabled(String string) {
        this.setProperty("hibernate.transaction.flush_before_completion", string);
    }

    public String getFlushBeforeCompletionEnabled() {
        return this.getProperty("hibernate.transaction.flush_before_completion");
    }

    public void setAutoCloseSessionEnabled(String string) {
        this.setProperty("hibernate.transaction.auto_close_session", string);
    }

    public String getAutoCloseSessionEnabled() {
        return this.getProperty("hibernate.transaction.auto_close_session");
    }

    public Properties getProperties() {
        return this.buildProperties();
    }
}

