/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hibernate.jdbc.ColumnNameCache;

public class ResultSetWrapper
implements ResultSet {
    private ResultSet rs;
    private ColumnNameCache columnNameCache;

    public ResultSetWrapper(ResultSet resultSet, ColumnNameCache columnNameCache) {
        this.rs = resultSet;
        this.columnNameCache = columnNameCache;
    }

    ResultSet getTarget() {
        return this.rs;
    }

    public int findColumn(String string) throws SQLException {
        return this.columnNameCache.getIndexForColumnName(string, this);
    }

    public Array getArray(String string) throws SQLException {
        return this.rs.getArray(this.findColumn(string));
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.rs.updateArray(this.findColumn(string), array);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.rs.getAsciiStream(this.findColumn(string));
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.rs.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.rs.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.rs.getBigDecimal(this.findColumn(string), n);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.rs.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.rs.getBinaryStream(this.findColumn(string));
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.rs.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.rs.getBlob(this.findColumn(string));
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.rs.updateBlob(this.findColumn(string), blob);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.rs.getBoolean(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.rs.updateBoolean(this.findColumn(string), bl);
    }

    public byte getByte(String string) throws SQLException {
        return this.rs.getByte(this.findColumn(string));
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.rs.updateByte(this.findColumn(string), by);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.rs.getBytes(this.findColumn(string));
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.rs.updateBytes(this.findColumn(string), byArray);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.rs.getCharacterStream(this.findColumn(string));
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.rs.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public Clob getClob(String string) throws SQLException {
        return this.rs.getClob(this.findColumn(string));
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.rs.updateClob(this.findColumn(string), clob);
    }

    public Date getDate(String string) throws SQLException {
        return this.rs.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.rs.getDate(this.findColumn(string), calendar);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.rs.updateDate(this.findColumn(string), date);
    }

    public double getDouble(String string) throws SQLException {
        return this.rs.getDouble(this.findColumn(string));
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.rs.updateDouble(this.findColumn(string), d);
    }

    public float getFloat(String string) throws SQLException {
        return this.rs.getFloat(this.findColumn(string));
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.rs.updateFloat(this.findColumn(string), f);
    }

    public int getInt(String string) throws SQLException {
        return this.rs.getInt(this.findColumn(string));
    }

    public void updateInt(String string, int n) throws SQLException {
        this.rs.updateInt(this.findColumn(string), n);
    }

    public long getLong(String string) throws SQLException {
        return this.rs.getLong(this.findColumn(string));
    }

    public void updateLong(String string, long l) throws SQLException {
        this.rs.updateLong(this.findColumn(string), l);
    }

    public Object getObject(String string) throws SQLException {
        return this.rs.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.rs.getObject(this.findColumn(string), map);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.rs.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.rs.updateObject(this.findColumn(string), object, n);
    }

    public Ref getRef(String string) throws SQLException {
        return this.rs.getRef(this.findColumn(string));
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.rs.updateRef(this.findColumn(string), ref);
    }

    public short getShort(String string) throws SQLException {
        return this.rs.getShort(this.findColumn(string));
    }

    public void updateShort(String string, short s) throws SQLException {
        this.rs.updateShort(this.findColumn(string), s);
    }

    public String getString(String string) throws SQLException {
        return this.rs.getString(this.findColumn(string));
    }

    public void updateString(String string, String string2) throws SQLException {
        this.rs.updateString(this.findColumn(string), string2);
    }

    public Time getTime(String string) throws SQLException {
        return this.rs.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.rs.getTime(this.findColumn(string), calendar);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.rs.updateTime(this.findColumn(string), time);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.rs.getTimestamp(this.findColumn(string));
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.rs.updateTimestamp(this.findColumn(string), timestamp);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.rs.getTimestamp(this.findColumn(string), calendar);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.rs.getUnicodeStream(this.findColumn(string));
    }

    public URL getURL(String string) throws SQLException {
        return this.rs.getURL(this.findColumn(string));
    }

    public void updateNull(String string) throws SQLException {
        this.rs.updateNull(this.findColumn(string));
    }

    public int getConcurrency() throws SQLException {
        return this.rs.getConcurrency();
    }

    public int getFetchDirection() throws SQLException {
        return this.rs.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.rs.getFetchSize();
    }

    public int getRow() throws SQLException {
        return this.rs.getRow();
    }

    public int getType() throws SQLException {
        return this.rs.getType();
    }

    public void afterLast() throws SQLException {
        this.rs.afterLast();
    }

    public void beforeFirst() throws SQLException {
        this.rs.beforeFirst();
    }

    public void cancelRowUpdates() throws SQLException {
        this.rs.cancelRowUpdates();
    }

    public void clearWarnings() throws SQLException {
        this.rs.clearWarnings();
    }

    public void close() throws SQLException {
        this.rs.close();
    }

    public void deleteRow() throws SQLException {
        this.rs.deleteRow();
    }

    public void insertRow() throws SQLException {
        this.rs.insertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.rs.moveToCurrentRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.rs.moveToInsertRow();
    }

    public void refreshRow() throws SQLException {
        this.rs.refreshRow();
    }

    public void updateRow() throws SQLException {
        this.rs.updateRow();
    }

    public boolean first() throws SQLException {
        return this.rs.first();
    }

    public boolean isAfterLast() throws SQLException {
        return this.rs.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rs.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        return this.rs.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.rs.isLast();
    }

    public boolean last() throws SQLException {
        return this.rs.last();
    }

    public boolean next() throws SQLException {
        return this.rs.next();
    }

    public boolean previous() throws SQLException {
        return this.rs.previous();
    }

    public boolean rowDeleted() throws SQLException {
        return this.rs.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        return this.rs.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        return this.rs.rowUpdated();
    }

    public boolean wasNull() throws SQLException {
        return this.rs.wasNull();
    }

    public byte getByte(int n) throws SQLException {
        return this.rs.getByte(n);
    }

    public double getDouble(int n) throws SQLException {
        return this.rs.getDouble(n);
    }

    public float getFloat(int n) throws SQLException {
        return this.rs.getFloat(n);
    }

    public int getInt(int n) throws SQLException {
        return this.rs.getInt(n);
    }

    public long getLong(int n) throws SQLException {
        return this.rs.getLong(n);
    }

    public short getShort(int n) throws SQLException {
        return this.rs.getShort(n);
    }

    public void setFetchDirection(int n) throws SQLException {
        this.rs.setFetchDirection(n);
    }

    public void setFetchSize(int n) throws SQLException {
        this.rs.setFetchSize(n);
    }

    public void updateNull(int n) throws SQLException {
        this.rs.updateNull(n);
    }

    public boolean absolute(int n) throws SQLException {
        return this.rs.absolute(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.rs.getBoolean(n);
    }

    public boolean relative(int n) throws SQLException {
        return this.rs.relative(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.rs.getBytes(n);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.rs.updateByte(n, by);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.rs.updateDouble(n, d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.rs.updateFloat(n, f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.rs.updateInt(n, n2);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.rs.updateLong(n, l);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.rs.updateShort(n, s);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.rs.updateBoolean(n, bl);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.rs.updateBytes(n, byArray);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.rs.getAsciiStream(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.rs.getBinaryStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.rs.getUnicodeStream(n);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.rs.updateAsciiStream(n, inputStream, n2);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.rs.updateBinaryStream(n, inputStream, n2);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return this.rs.getCharacterStream(n);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.rs.updateCharacterStream(n, reader, n2);
    }

    public Object getObject(int n) throws SQLException {
        return this.rs.getObject(n);
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.rs.updateObject(n, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.rs.updateObject(n, object, n2);
    }

    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    public String getString(int n) throws SQLException {
        return this.rs.getString(n);
    }

    public void updateString(int n, String string) throws SQLException {
        this.rs.updateString(n, string);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.rs.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.rs.getBigDecimal(n, n2);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.rs.updateBigDecimal(n, bigDecimal);
    }

    public URL getURL(int n) throws SQLException {
        return this.rs.getURL(n);
    }

    public Array getArray(int n) throws SQLException {
        return this.rs.getArray(n);
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.rs.updateArray(n, array);
    }

    public Blob getBlob(int n) throws SQLException {
        return this.rs.getBlob(n);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.rs.updateBlob(n, blob);
    }

    public Clob getClob(int n) throws SQLException {
        return this.rs.getClob(n);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.rs.updateClob(n, clob);
    }

    public Date getDate(int n) throws SQLException {
        return this.rs.getDate(n);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.rs.updateDate(n, date);
    }

    public Ref getRef(int n) throws SQLException {
        return this.rs.getRef(n);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.rs.updateRef(n, ref);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rs.getMetaData();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.rs.getWarnings();
    }

    public Statement getStatement() throws SQLException {
        return this.rs.getStatement();
    }

    public Time getTime(int n) throws SQLException {
        return this.rs.getTime(n);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.rs.updateTime(n, time);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.rs.getTimestamp(n);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.rs.updateTimestamp(n, timestamp);
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.rs.getObject(n, map);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.rs.getDate(n, calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.rs.getTime(n, calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.rs.getTimestamp(n, calendar);
    }
}

