/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.jdbc.ConnectionManager;
import org.hibernate.transaction.CacheSynchronization;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class JDBCContext
implements Serializable,
ConnectionManager.Callback {
    private static final Log log = LogFactory.getLog((Class)JDBCContext.class);
    private Context owner;
    private ConnectionManager connectionManager;
    private transient boolean isTransactionCallbackRegistered;
    private transient Transaction hibernateTransaction;

    public JDBCContext(Context context, Connection connection, Interceptor interceptor) {
        boolean bl;
        this.owner = context;
        this.connectionManager = new ConnectionManager(context.getFactory(), this, context.getConnectionReleaseMode(), connection, interceptor);
        boolean bl2 = bl = context.isAutoCloseSessionEnabled() || context.isFlushBeforeCompletionEnabled() || context.getConnectionReleaseMode() == ConnectionReleaseMode.AFTER_TRANSACTION;
        if (bl) {
            this.registerSynchronizationIfPossible();
        }
    }

    private JDBCContext() {
    }

    public void connectionOpened() {
        if (this.owner.getFactory().getStatistics().isStatisticsEnabled()) {
            this.owner.getFactory().getStatisticsImplementor().connect();
        }
    }

    public void connectionCleanedUp() {
        if (!this.isTransactionCallbackRegistered) {
            this.afterTransactionCompletion(false, null);
        }
    }

    public SessionFactoryImplementor getFactory() {
        return this.owner.getFactory();
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public Connection borrowConnection() {
        return this.connectionManager.borrowConnection();
    }

    public Connection connection() throws HibernateException {
        if (this.owner.isClosed()) {
            throw new SessionException("Session is closed");
        }
        return this.connectionManager.getConnection();
    }

    public boolean registerCallbackIfNecessary() {
        if (this.isTransactionCallbackRegistered) {
            return false;
        }
        this.isTransactionCallbackRegistered = true;
        return true;
    }

    public boolean registerSynchronizationIfPossible() {
        if (this.isTransactionCallbackRegistered) {
            return true;
        }
        boolean bl = this.owner.getFactory().getSettings().getTransactionFactory().areCallbacksLocalToHibernateTransactions();
        if (bl) {
            return false;
        }
        TransactionManager transactionManager = this.owner.getFactory().getTransactionManager();
        if (transactionManager == null) {
            return false;
        }
        try {
            if (!this.isTransactionInProgress()) {
                log.trace((Object)"TransactionFactory reported no active transaction; Synchronization not registered");
                return false;
            }
            javax.transaction.Transaction transaction = transactionManager.getTransaction();
            if (JTAHelper.isMarkedForRollback(transaction)) {
                log.debug((Object)"Transaction is marked for rollback; skipping Synchronization registration");
                return false;
            }
            transaction.registerSynchronization((Synchronization)new CacheSynchronization(this.owner, this, transaction, null));
            this.isTransactionCallbackRegistered = true;
            log.debug((Object)"successfully registered Synchronization");
            return true;
        }
        catch (HibernateException hibernateException) {
            throw hibernateException;
        }
        catch (Exception exception) {
            throw new TransactionException("could not register synchronization with JTA TransactionManager", exception);
        }
    }

    public boolean isTransactionInProgress() {
        return this.owner.getFactory().getSettings().getTransactionFactory().isTransactionInProgress(this, this.owner, this.hibernateTransaction);
    }

    public Transaction getTransaction() throws HibernateException {
        if (this.hibernateTransaction == null) {
            this.hibernateTransaction = this.owner.getFactory().getSettings().getTransactionFactory().createTransaction(this, this.owner);
        }
        return this.hibernateTransaction;
    }

    public void beforeTransactionCompletion(Transaction transaction) {
        log.trace((Object)"before transaction completion");
        this.owner.beforeTransactionCompletion(transaction);
    }

    public void afterTransactionBegin(Transaction transaction) {
        log.trace((Object)"after transaction begin");
        this.owner.afterTransactionBegin(transaction);
    }

    public void afterTransactionCompletion(boolean bl, Transaction transaction) {
        log.trace((Object)"after transaction completion");
        if (this.getFactory().getStatistics().isStatisticsEnabled()) {
            this.getFactory().getStatisticsImplementor().endTransaction(bl);
        }
        this.connectionManager.afterTransaction();
        this.isTransactionCallbackRegistered = false;
        this.hibernateTransaction = null;
        this.owner.afterTransactionCompletion(bl, transaction);
    }

    public void afterNontransactionalQuery(boolean bl) {
        log.trace((Object)"after autocommit");
        try {
            boolean bl2 = this.connectionManager.isAutoCommit();
            this.connectionManager.afterTransaction();
            if (bl2) {
                this.owner.afterTransactionCompletion(bl, null);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.owner.getFactory().getSQLExceptionConverter(), sQLException, "could not inspect JDBC autocommit mode");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        boolean bl = this.isTransactionCallbackRegistered && !this.owner.getFactory().getSettings().getTransactionFactory().areCallbacksLocalToHibernateTransactions();
        objectOutputStream.writeBoolean(bl);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.isTransactionCallbackRegistered = objectInputStream.readBoolean();
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        this.connectionManager.serialize(objectOutputStream);
    }

    public static JDBCContext deserialize(ObjectInputStream objectInputStream, Context context, Interceptor interceptor) throws IOException {
        JDBCContext jDBCContext = new JDBCContext();
        jDBCContext.owner = context;
        jDBCContext.connectionManager = ConnectionManager.deserialize(objectInputStream, context.getFactory(), interceptor, context.getConnectionReleaseMode(), jDBCContext);
        return jDBCContext;
    }

    public static interface Context
    extends TransactionFactory.Context {
        public void afterTransactionBegin(Transaction var1);

        public void beforeTransactionCompletion(Transaction var1);

        public void afterTransactionCompletion(boolean var1, Transaction var2);

        public ConnectionReleaseMode getConnectionReleaseMode();

        public boolean isAutoCloseSessionEnabled();
    }
}

