/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.jdbc.Batcher;
import org.hibernate.jdbc.BorrowedConnectionProxy;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.util.JDBCExceptionReporter;

public class ConnectionManager
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)ConnectionManager.class);
    private transient SessionFactoryImplementor factory;
    private final Callback callback;
    private final ConnectionReleaseMode releaseMode;
    private transient Connection connection;
    private transient Connection borrowedConnection;
    private final boolean wasConnectionSupplied;
    private transient Batcher batcher;
    private transient Interceptor interceptor;
    private boolean isClosed;
    private transient boolean isFlushing;

    public ConnectionManager(SessionFactoryImplementor sessionFactoryImplementor, Callback callback, ConnectionReleaseMode connectionReleaseMode, Connection connection, Interceptor interceptor) {
        this.factory = sessionFactoryImplementor;
        this.callback = callback;
        this.interceptor = interceptor;
        this.batcher = sessionFactoryImplementor.getSettings().getBatcherFactory().createBatcher(this, interceptor);
        this.connection = connection;
        this.wasConnectionSupplied = connection != null;
        this.releaseMode = this.wasConnectionSupplied ? ConnectionReleaseMode.ON_CLOSE : connectionReleaseMode;
    }

    private ConnectionManager(SessionFactoryImplementor sessionFactoryImplementor, Callback callback, ConnectionReleaseMode connectionReleaseMode, Interceptor interceptor, boolean bl, boolean bl2) {
        this.factory = sessionFactoryImplementor;
        this.callback = callback;
        this.interceptor = interceptor;
        this.batcher = sessionFactoryImplementor.getSettings().getBatcherFactory().createBatcher(this, interceptor);
        this.wasConnectionSupplied = bl;
        this.isClosed = bl2;
        this.releaseMode = bl ? ConnectionReleaseMode.ON_CLOSE : connectionReleaseMode;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public Batcher getBatcher() {
        return this.batcher;
    }

    public boolean isSuppliedConnection() {
        return this.wasConnectionSupplied;
    }

    public Connection getConnection() throws HibernateException {
        if (this.isClosed) {
            throw new HibernateException("connection manager has been closed");
        }
        if (this.connection == null) {
            this.openConnection();
        }
        return this.connection;
    }

    public boolean hasBorrowedConnection() {
        return this.borrowedConnection != null;
    }

    public Connection borrowConnection() {
        if (this.isClosed) {
            throw new HibernateException("connection manager has been closed");
        }
        if (this.isSuppliedConnection()) {
            return this.connection;
        }
        if (this.borrowedConnection == null) {
            this.borrowedConnection = BorrowedConnectionProxy.generateProxy(this);
        }
        return this.borrowedConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBorrowedConnection() {
        if (this.borrowedConnection != null) {
            try {
                BorrowedConnectionProxy.renderUnuseable(this.borrowedConnection);
            }
            finally {
                this.borrowedConnection = null;
            }
        }
    }

    public boolean isAutoCommit() throws SQLException {
        return this.connection == null || this.connection.isClosed() || this.connection.getAutoCommit();
    }

    public boolean isAggressiveRelease() {
        if (this.releaseMode == ConnectionReleaseMode.AFTER_STATEMENT) {
            return true;
        }
        if (this.releaseMode == ConnectionReleaseMode.AFTER_TRANSACTION) {
            boolean bl;
            try {
                bl = this.isAutoCommit() && !this.callback.isTransactionInProgress();
            }
            catch (SQLException sQLException) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    private boolean isAggressiveReleaseNoTransactionCheck() {
        boolean bl;
        if (this.releaseMode == ConnectionReleaseMode.AFTER_STATEMENT) {
            return true;
        }
        try {
            bl = this.isAutoCommit();
        }
        catch (SQLException sQLException) {
            bl = true;
        }
        return this.releaseMode == ConnectionReleaseMode.AFTER_TRANSACTION && bl;
    }

    public boolean isCurrentlyConnected() {
        return this.wasConnectionSupplied ? this.connection != null : !this.isClosed;
    }

    public void afterStatement() {
        if (this.isAggressiveRelease()) {
            if (this.isFlushing) {
                log.debug((Object)"skipping aggressive-release due to flush cycle");
            } else if (this.batcher.hasOpenResources()) {
                log.debug((Object)"skipping aggresive-release due to open resources on batcher");
            } else if (this.borrowedConnection != null) {
                log.debug((Object)"skipping aggresive-release due to borrowed connection");
            } else {
                this.aggressiveRelease();
            }
        }
    }

    public void afterTransaction() {
        if (this.isAfterTransactionRelease()) {
            this.aggressiveRelease();
        } else if (this.isAggressiveReleaseNoTransactionCheck() && this.batcher.hasOpenResources()) {
            log.info((Object)"forcing batcher resource cleanup on transaction completion; forgot to close ScrollableResults/Iterator?");
            this.batcher.closeStatements();
            this.aggressiveRelease();
        } else if (this.isOnCloseRelease()) {
            log.debug((Object)"transaction completed on session with on_close connection release mode; be sure to close the session to release JDBC resources!");
        }
        this.batcher.unsetTransactionTimeout();
    }

    private boolean isAfterTransactionRelease() {
        return this.releaseMode == ConnectionReleaseMode.AFTER_TRANSACTION;
    }

    private boolean isOnCloseRelease() {
        return this.releaseMode == ConnectionReleaseMode.ON_CLOSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection close() {
        try {
            Connection connection = this.cleanup();
            return connection;
        }
        finally {
            this.isClosed = true;
        }
    }

    public Connection manualDisconnect() {
        return this.cleanup();
    }

    public void manualReconnect() {
    }

    public void manualReconnect(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection cleanup() throws HibernateException {
        this.releaseBorrowedConnection();
        if (this.connection == null) {
            log.trace((Object)"connection already null in cleanup : no action");
            return null;
        }
        try {
            log.trace((Object)"performing cleanup");
            this.batcher.closeStatements();
            Connection connection = null;
            if (!this.wasConnectionSupplied) {
                this.closeConnection();
            } else {
                connection = this.connection;
            }
            this.connection = null;
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            this.callback.connectionCleanedUp();
        }
    }

    private void aggressiveRelease() {
        if (!this.wasConnectionSupplied) {
            log.debug((Object)"aggressively releasing JDBC connection");
            if (this.connection != null) {
                this.closeConnection();
            }
        }
    }

    private void openConnection() throws HibernateException {
        if (this.connection != null) {
            return;
        }
        log.debug((Object)"opening JDBC connection");
        try {
            this.connection = this.factory.getConnectionProvider().getConnection();
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "Cannot open connection");
        }
        this.callback.connectionOpened();
    }

    private void closeConnection() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("releasing JDBC connection [" + this.batcher.openResourceStatsAsString() + "]"));
        }
        try {
            if (!this.connection.isClosed()) {
                JDBCExceptionReporter.logAndClearWarnings(this.connection);
            }
            this.factory.getConnectionProvider().closeConnection(this.connection);
            this.connection = null;
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "Cannot release connection");
        }
    }

    public void flushBeginning() {
        log.trace((Object)"registering flush begin");
        this.isFlushing = true;
    }

    public void flushEnding() {
        log.trace((Object)"registering flush end");
        this.isFlushing = false;
        this.afterStatement();
    }

    public boolean isReadyForSerialization() {
        return this.wasConnectionSupplied ? this.connection == null : !this.batcher.hasOpenResources();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.isReadyForSerialization()) {
            throw new IllegalStateException("Cannot serialize a ConnectionManager while connected");
        }
        objectOutputStream.writeObject(this.factory);
        objectOutputStream.writeObject(this.interceptor);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.factory = (SessionFactoryImplementor)objectInputStream.readObject();
        this.interceptor = (Interceptor)objectInputStream.readObject();
        objectInputStream.defaultReadObject();
        this.batcher = this.factory.getSettings().getBatcherFactory().createBatcher(this, this.interceptor);
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.wasConnectionSupplied);
        objectOutputStream.writeBoolean(this.isClosed);
    }

    public static ConnectionManager deserialize(ObjectInputStream objectInputStream, SessionFactoryImplementor sessionFactoryImplementor, Interceptor interceptor, ConnectionReleaseMode connectionReleaseMode, JDBCContext jDBCContext) throws IOException {
        return new ConnectionManager(sessionFactoryImplementor, jDBCContext, connectionReleaseMode, interceptor, objectInputStream.readBoolean(), objectInputStream.readBoolean());
    }

    public static interface Callback {
        public void connectionOpened();

        public void connectionCleanedUp();

        public boolean isTransactionInProgress();
    }
}

