/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import org.hibernate.HibernateException;
import org.hibernate.jdbc.ConnectionManager;
import org.hibernate.jdbc.ConnectionWrapper;

public class BorrowedConnectionProxy
implements InvocationHandler {
    private static final Class[] PROXY_INTERFACES = new Class[]{Connection.class, ConnectionWrapper.class};
    private final ConnectionManager connectionManager;
    private boolean useable = true;

    public BorrowedConnectionProxy(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if ("close".equals(method.getName())) {
            this.connectionManager.releaseBorrowedConnection();
            return null;
        }
        if (!this.useable) {
            throw new HibernateException("connnection proxy not usable after transaction completion");
        }
        if ("getWrappedConnection".equals(method.getName())) {
            return this.connectionManager.getConnection();
        }
        try {
            return method.invoke((Object)this.connectionManager.getConnection(), objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    public static Connection generateProxy(ConnectionManager connectionManager) {
        BorrowedConnectionProxy borrowedConnectionProxy = new BorrowedConnectionProxy(connectionManager);
        return (Connection)Proxy.newProxyInstance(BorrowedConnectionProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)borrowedConnectionProxy);
    }

    public static void renderUnuseable(Connection connection) {
        InvocationHandler invocationHandler;
        if (connection != null && Proxy.isProxyClass(connection.getClass()) && BorrowedConnectionProxy.class.isAssignableFrom((invocationHandler = Proxy.getInvocationHandler(connection)).getClass())) {
            ((BorrowedConnectionProxy)invocationHandler).useable = false;
        }
    }

    public static Connection getWrappedConnection(Connection connection) {
        if (connection != null && connection instanceof ConnectionWrapper) {
            return ((ConnectionWrapper)((Object)connection)).getWrappedConnection();
        }
        return connection;
    }

    public static ClassLoader getProxyClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = BorrowedConnectionProxy.class.getClassLoader();
        }
        return classLoader;
    }
}

