/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.jdbc.AbstractBatcher;
import org.hibernate.jdbc.ConnectionManager;
import org.hibernate.jdbc.Expectation;

public class BatchingBatcher
extends AbstractBatcher {
    private int batchSize;
    private Expectation[] expectations = new Expectation[this.getFactory().getSettings().getJdbcBatchSize()];

    public BatchingBatcher(ConnectionManager connectionManager, Interceptor interceptor) {
        super(connectionManager, interceptor);
    }

    public void addToBatch(Expectation expectation) throws SQLException, HibernateException {
        if (!expectation.canBeBatched()) {
            throw new HibernateException("attempting to batch an operation which cannot be batched");
        }
        PreparedStatement preparedStatement = this.getStatement();
        preparedStatement.addBatch();
        this.expectations[this.batchSize++] = expectation;
        if (this.batchSize == this.getFactory().getSettings().getJdbcBatchSize()) {
            this.doExecuteBatch(preparedStatement);
        }
    }

    protected void doExecuteBatch(PreparedStatement preparedStatement) throws SQLException, HibernateException {
        if (this.batchSize == 0) {
            log.debug((Object)"no batched statements to execute");
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing batch size: " + this.batchSize));
            }
            try {
                this.checkRowCounts(preparedStatement.executeBatch(), preparedStatement);
            }
            catch (RuntimeException runtimeException) {
                log.error((Object)"Exception executing batch: ", (Throwable)runtimeException);
                throw runtimeException;
            }
            finally {
                this.batchSize = 0;
            }
        }
    }

    private void checkRowCounts(int[] nArray, PreparedStatement preparedStatement) throws SQLException, HibernateException {
        int n = nArray.length;
        if (n != this.batchSize) {
            log.warn((Object)"JDBC driver did not return the expected number of row counts");
        }
        for (int i = 0; i < n; ++i) {
            this.expectations[i].verifyOutcome(nArray[i], preparedStatement, i);
        }
    }
}

