/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.intercept;

import java.util.Set;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.intercept.cglib.CGLIBHelper;
import org.hibernate.intercept.javassist.JavassistHelper;

public class FieldInterceptionHelper {
    private FieldInterceptionHelper() {
    }

    public static boolean isInstrumented(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!"net.sf.cglib.transform.impl.InterceptFieldEnabled".equals(classArray[i].getName()) && !"org.hibernate.bytecode.javassist.FieldHandled".equals(classArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstrumented(Object object) {
        return object != null && FieldInterceptionHelper.isInstrumented(object.getClass());
    }

    public static FieldInterceptor extractFieldInterceptor(Object object) {
        if (object == null) {
            return null;
        }
        Class<?>[] classArray = object.getClass().getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if ("net.sf.cglib.transform.impl.InterceptFieldEnabled".equals(classArray[i].getName())) {
                return CGLIBHelper.extractFieldInterceptor(object);
            }
            if (!"org.hibernate.bytecode.javassist.FieldHandled".equals(classArray[i].getName())) continue;
            return JavassistHelper.extractFieldInterceptor(object);
        }
        return null;
    }

    public static FieldInterceptor injectFieldInterceptor(Object object, String string, Set set, SessionImplementor sessionImplementor) {
        if (object != null) {
            Class<?>[] classArray = object.getClass().getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if ("net.sf.cglib.transform.impl.InterceptFieldEnabled".equals(classArray[i].getName())) {
                    return CGLIBHelper.injectFieldInterceptor(object, string, set, sessionImplementor);
                }
                if (!"org.hibernate.bytecode.javassist.FieldHandled".equals(classArray[i].getName())) continue;
                return JavassistHelper.injectFieldInterceptor(object, string, set, sessionImplementor);
            }
        }
        return null;
    }

    public static void clearDirty(Object object) {
        FieldInterceptor fieldInterceptor = FieldInterceptionHelper.extractFieldInterceptor(object);
        if (fieldInterceptor != null) {
            fieldInterceptor.clearDirty();
        }
    }

    public static void markDirty(Object object) {
        FieldInterceptor fieldInterceptor = FieldInterceptionHelper.extractFieldInterceptor(object);
        if (fieldInterceptor != null) {
            fieldInterceptor.dirty();
        }
    }
}

