/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CacheMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Criteria;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionException;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.CacheKey;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.StatefulPersistenceContext;
import org.hibernate.engine.Versioning;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.engine.query.NativeSQLQueryPlan;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.event.EventListeners;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.impl.AbstractSessionImpl;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.jdbc.Batcher;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.loader.criteria.CriteriaLoader;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;

public class StatelessSessionImpl
extends AbstractSessionImpl
implements JDBCContext.Context,
StatelessSession {
    private static final Log log = LogFactory.getLog((Class)StatelessSessionImpl.class);
    private JDBCContext jdbcContext;
    private PersistenceContext temporaryPersistenceContext = new StatefulPersistenceContext(this);

    StatelessSessionImpl(Connection connection, SessionFactoryImpl sessionFactoryImpl) {
        super(sessionFactoryImpl);
        this.jdbcContext = new JDBCContext(this, connection, EmptyInterceptor.INSTANCE);
    }

    public Serializable insert(Object object) {
        this.errorIfClosed();
        return this.insert(null, object);
    }

    public Serializable insert(String string, Object object) {
        boolean bl;
        this.errorIfClosed();
        EntityPersister entityPersister = this.getEntityPersister(string, object);
        Serializable serializable = entityPersister.getIdentifierGenerator().generate(this, object);
        Object[] objectArray = entityPersister.getPropertyValues(object, EntityMode.POJO);
        if (entityPersister.isVersioned() && (bl = Versioning.seedVersion(objectArray, entityPersister.getVersionProperty(), entityPersister.getVersionType(), this))) {
            entityPersister.setPropertyValues(object, objectArray, EntityMode.POJO);
        }
        if (serializable == IdentifierGeneratorFactory.POST_INSERT_INDICATOR) {
            serializable = entityPersister.insert(objectArray, object, this);
        } else {
            entityPersister.insert(serializable, objectArray, object, this);
        }
        entityPersister.setIdentifier(object, serializable, EntityMode.POJO);
        return serializable;
    }

    public void delete(Object object) {
        this.errorIfClosed();
        this.delete(null, object);
    }

    public void delete(String string, Object object) {
        this.errorIfClosed();
        EntityPersister entityPersister = this.getEntityPersister(string, object);
        Serializable serializable = entityPersister.getIdentifier(object, EntityMode.POJO);
        Object object2 = entityPersister.getVersion(object, EntityMode.POJO);
        entityPersister.delete(serializable, object2, object, this);
    }

    public void update(Object object) {
        this.errorIfClosed();
        this.update(null, object);
    }

    public void update(String string, Object object) {
        Object object2;
        this.errorIfClosed();
        EntityPersister entityPersister = this.getEntityPersister(string, object);
        Serializable serializable = entityPersister.getIdentifier(object, EntityMode.POJO);
        Object[] objectArray = entityPersister.getPropertyValues(object, EntityMode.POJO);
        if (entityPersister.isVersioned()) {
            object2 = entityPersister.getVersion(object, EntityMode.POJO);
            Object object3 = Versioning.increment(object2, entityPersister.getVersionType(), this);
            Versioning.setVersion(objectArray, object3, entityPersister);
            entityPersister.setPropertyValues(object, objectArray, EntityMode.POJO);
        } else {
            object2 = null;
        }
        entityPersister.update(serializable, objectArray, null, false, null, object2, object, null, this);
    }

    public Object get(Class clazz, Serializable serializable) {
        return this.get(clazz.getName(), serializable);
    }

    public Object get(Class clazz, Serializable serializable, LockMode lockMode) {
        return this.get(clazz.getName(), serializable, lockMode);
    }

    public Object get(String string, Serializable serializable) {
        return this.get(string, serializable, LockMode.NONE);
    }

    public Object get(String string, Serializable serializable, LockMode lockMode) {
        this.errorIfClosed();
        Object object = this.getFactory().getEntityPersister(string).load(serializable, null, lockMode, this);
        this.temporaryPersistenceContext.clear();
        return object;
    }

    public void refresh(Object object) {
        this.refresh(this.bestGuessEntityName(object), object, LockMode.NONE);
    }

    public void refresh(String string, Object object) {
        this.refresh(string, object, LockMode.NONE);
    }

    public void refresh(Object object, LockMode lockMode) {
        this.refresh(this.bestGuessEntityName(object), object, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String string, Object object, LockMode lockMode) {
        Object object2;
        EntityPersister entityPersister = this.getEntityPersister(string, object);
        Serializable serializable = entityPersister.getIdentifier(object, this.getEntityMode());
        if (log.isTraceEnabled()) {
            log.trace((Object)("refreshing transient " + MessageHelper.infoString(entityPersister, serializable, this.getFactory())));
        }
        if (entityPersister.hasCache()) {
            object2 = new CacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), this.getEntityMode(), this.getFactory());
            entityPersister.getCache().remove(object2);
        }
        object2 = this.getFetchProfile();
        Object object3 = null;
        try {
            this.setFetchProfile("refresh");
            object3 = entityPersister.load(serializable, object, lockMode, this);
        }
        finally {
            this.setFetchProfile((String)object2);
        }
        UnresolvableObjectException.throwIfNull(object3, serializable, entityPersister.getEntityName());
    }

    public Object immediateLoad(String string, Serializable serializable) throws HibernateException {
        throw new SessionException("proxies cannot be fetched by a stateless session");
    }

    public void initializeCollection(PersistentCollection persistentCollection, boolean bl) throws HibernateException {
        throw new SessionException("collections cannot be fetched by a stateless session");
    }

    public Object instantiate(String string, Serializable serializable) throws HibernateException {
        this.errorIfClosed();
        return this.getFactory().getEntityPersister(string).instantiate(serializable, EntityMode.POJO);
    }

    public Object internalLoad(String string, Serializable serializable, boolean bl, boolean bl2) throws HibernateException {
        this.errorIfClosed();
        EntityPersister entityPersister = this.getFactory().getEntityPersister(string);
        if (!bl && entityPersister.hasProxy()) {
            return entityPersister.createProxy(serializable, this);
        }
        Object object = this.temporaryPersistenceContext.getEntity(new EntityKey(serializable, entityPersister, EntityMode.POJO));
        return object == null ? this.get(string, serializable) : object;
    }

    public Iterator iterate(String string, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public Iterator iterateFilter(Object object, String string, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public List listFilter(Object object, String string, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public boolean isOpen() {
        return !this.isClosed();
    }

    public void close() {
        this.managedClose();
    }

    public ConnectionReleaseMode getConnectionReleaseMode() {
        return this.factory.getSettings().getConnectionReleaseMode();
    }

    public boolean isAutoCloseSessionEnabled() {
        return this.factory.getSettings().isAutoCloseSessionEnabled();
    }

    public boolean isFlushBeforeCompletionEnabled() {
        return true;
    }

    public boolean isFlushModeNever() {
        return false;
    }

    public void managedClose() {
        if (this.isClosed()) {
            throw new SessionException("Session was already closed!");
        }
        this.jdbcContext.getConnectionManager().close();
        this.setClosed();
    }

    public void managedFlush() {
        this.errorIfClosed();
        this.getBatcher().executeBatch();
    }

    public boolean shouldAutoClose() {
        return this.isAutoCloseSessionEnabled() && !this.isClosed();
    }

    public void afterTransactionCompletion(boolean bl, Transaction transaction) {
    }

    public void beforeTransactionCompletion(Transaction transaction) {
    }

    public String bestGuessEntityName(Object object) {
        if (object instanceof HibernateProxy) {
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        return this.guessEntityName(object);
    }

    public Connection connection() {
        this.errorIfClosed();
        return this.jdbcContext.borrowConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        queryParameters.validateParameters();
        HQLQueryPlan hQLQueryPlan = this.getHQLQueryPlan(string, false);
        boolean bl = false;
        int n = 0;
        try {
            n = hQLQueryPlan.performExecuteUpdate(queryParameters, this);
            bl = true;
        }
        finally {
            this.afterOperation(bl);
        }
        this.temporaryPersistenceContext.clear();
        return n;
    }

    public Batcher getBatcher() {
        this.errorIfClosed();
        return this.jdbcContext.getConnectionManager().getBatcher();
    }

    public CacheMode getCacheMode() {
        return CacheMode.IGNORE;
    }

    public int getDontFlushFromFind() {
        return 0;
    }

    public Map getEnabledFilters() {
        return CollectionHelper.EMPTY_MAP;
    }

    public Serializable getContextEntityIdentifier(Object object) {
        this.errorIfClosed();
        return null;
    }

    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    public EntityPersister getEntityPersister(String string, Object object) throws HibernateException {
        this.errorIfClosed();
        if (string == null) {
            return this.factory.getEntityPersister(this.guessEntityName(object));
        }
        return this.factory.getEntityPersister(string).getSubclassEntityPersister(object, this.getFactory(), EntityMode.POJO);
    }

    public Object getEntityUsingInterceptor(EntityKey entityKey) throws HibernateException {
        this.errorIfClosed();
        return null;
    }

    public Type getFilterParameterType(String string) {
        throw new UnsupportedOperationException();
    }

    public Object getFilterParameterValue(String string) {
        throw new UnsupportedOperationException();
    }

    public FlushMode getFlushMode() {
        return FlushMode.COMMIT;
    }

    public Interceptor getInterceptor() {
        return EmptyInterceptor.INSTANCE;
    }

    public EventListeners getListeners() {
        throw new UnsupportedOperationException();
    }

    public PersistenceContext getPersistenceContext() {
        return this.temporaryPersistenceContext;
    }

    public long getTimestamp() {
        throw new UnsupportedOperationException();
    }

    public String guessEntityName(Object object) throws HibernateException {
        this.errorIfClosed();
        return object.getClass().getName();
    }

    public boolean isConnected() {
        return this.jdbcContext.getConnectionManager().isCurrentlyConnected();
    }

    public boolean isTransactionInProgress() {
        return this.jdbcContext.isTransactionInProgress();
    }

    public void setAutoClear(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void setCacheMode(CacheMode cacheMode) {
        throw new UnsupportedOperationException();
    }

    public void setFlushMode(FlushMode flushMode) {
        throw new UnsupportedOperationException();
    }

    public Transaction getTransaction() throws HibernateException {
        this.errorIfClosed();
        return this.jdbcContext.getTransaction();
    }

    public Transaction beginTransaction() throws HibernateException {
        this.errorIfClosed();
        Transaction transaction = this.getTransaction();
        transaction.begin();
        return transaction;
    }

    public boolean isEventSource() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        queryParameters.validateParameters();
        HQLQueryPlan hQLQueryPlan = this.getHQLQueryPlan(string, false);
        boolean bl = false;
        List list = CollectionHelper.EMPTY_LIST;
        try {
            list = hQLQueryPlan.performList(queryParameters, this);
            bl = true;
        }
        finally {
            this.afterOperation(bl);
        }
        this.temporaryPersistenceContext.clear();
        return list;
    }

    public void afterOperation(boolean bl) {
        if (!this.jdbcContext.isTransactionInProgress()) {
            this.jdbcContext.afterNontransactionalQuery(bl);
        }
    }

    public Criteria createCriteria(Class clazz, String string) {
        this.errorIfClosed();
        return new CriteriaImpl(clazz.getName(), string, this);
    }

    public Criteria createCriteria(String string, String string2) {
        this.errorIfClosed();
        return new CriteriaImpl(string, string2, this);
    }

    public Criteria createCriteria(Class clazz) {
        this.errorIfClosed();
        return new CriteriaImpl(clazz.getName(), this);
    }

    public Criteria createCriteria(String string) {
        this.errorIfClosed();
        return new CriteriaImpl(string, this);
    }

    public ScrollableResults scroll(CriteriaImpl criteriaImpl, ScrollMode scrollMode) {
        this.errorIfClosed();
        String string = criteriaImpl.getEntityOrClassName();
        CriteriaLoader criteriaLoader = new CriteriaLoader(this.getOuterJoinLoadable(string), this.factory, criteriaImpl, string, this.getEnabledFilters());
        return criteriaLoader.scroll(this, scrollMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(CriteriaImpl criteriaImpl) throws HibernateException {
        this.errorIfClosed();
        String[] stringArray = this.factory.getImplementors(criteriaImpl.getEntityOrClassName());
        int n = stringArray.length;
        CriteriaLoader[] criteriaLoaderArray = new CriteriaLoader[n];
        for (int i = 0; i < n; ++i) {
            criteriaLoaderArray[i] = new CriteriaLoader(this.getOuterJoinLoadable(stringArray[i]), this.factory, criteriaImpl, stringArray[i], this.getEnabledFilters());
        }
        List list = Collections.EMPTY_LIST;
        boolean bl = false;
        try {
            for (int i = 0; i < n; ++i) {
                List list2 = criteriaLoaderArray[i].list(this);
                list2.addAll(list);
                list = list2;
            }
            bl = true;
        }
        finally {
            this.afterOperation(bl);
        }
        this.temporaryPersistenceContext.clear();
        return list;
    }

    private OuterJoinLoadable getOuterJoinLoadable(String string) throws MappingException {
        EntityPersister entityPersister = this.factory.getEntityPersister(string);
        if (!(entityPersister instanceof OuterJoinLoadable)) {
            throw new MappingException("class persister is not OuterJoinLoadable: " + string);
        }
        return (OuterJoinLoadable)entityPersister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        List list;
        this.errorIfClosed();
        CustomLoader customLoader = new CustomLoader(customQuery, this.getFactory());
        boolean bl = false;
        try {
            list = customLoader.list(this, queryParameters);
            bl = true;
        }
        finally {
            this.afterOperation(bl);
        }
        this.temporaryPersistenceContext.clear();
        return list;
    }

    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        CustomLoader customLoader = new CustomLoader(customQuery, this.getFactory());
        return customLoader.scroll(queryParameters, this);
    }

    public ScrollableResults scroll(String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        HQLQueryPlan hQLQueryPlan = this.getHQLQueryPlan(string, false);
        return hQLQueryPlan.performScroll(queryParameters, this);
    }

    public void afterScrollOperation() {
        this.temporaryPersistenceContext.clear();
    }

    public void flush() {
    }

    public String getFetchProfile() {
        return null;
    }

    public JDBCContext getJDBCContext() {
        return this.jdbcContext;
    }

    public void setFetchProfile(String string) {
    }

    public void afterTransactionBegin(Transaction transaction) {
    }

    protected boolean autoFlushIfRequired(Set set) throws HibernateException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeNativeUpdate(NativeSQLQuerySpecification nativeSQLQuerySpecification, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        queryParameters.validateParameters();
        NativeSQLQueryPlan nativeSQLQueryPlan = this.getNativeSQLQueryPlan(nativeSQLQuerySpecification);
        boolean bl = false;
        int n = 0;
        try {
            n = nativeSQLQueryPlan.performExecuteUpdate(queryParameters, this);
            bl = true;
        }
        finally {
            this.afterOperation(bl);
        }
        this.temporaryPersistenceContext.clear();
        return n;
    }
}

