/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.util.FastHashMap;
import org.hibernate.util.NamingHelper;

public class SessionFactoryObjectFactory
implements ObjectFactory {
    private static final SessionFactoryObjectFactory INSTANCE;
    private static final Log log;
    private static final FastHashMap INSTANCES;
    private static final FastHashMap NAMED_INSTANCES;
    private static final NamingListener LISTENER;

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        log.debug((Object)("JNDI lookup: " + name));
        String string = (String)((Reference)object).get(0).getContent();
        return SessionFactoryObjectFactory.getInstance(string);
    }

    public static void addInstance(String string, String string2, SessionFactory sessionFactory, Properties properties) {
        log.debug((Object)("registered: " + string + " (" + (string2 == null ? "unnamed" : string2) + ')'));
        INSTANCES.put(string, sessionFactory);
        if (string2 != null) {
            NAMED_INSTANCES.put(string2, sessionFactory);
        }
        if (string2 == null) {
            log.info((Object)"Not binding factory to JNDI, no JNDI name configured");
        } else {
            log.info((Object)("Factory name: " + string2));
            try {
                InitialContext initialContext = NamingHelper.getInitialContext(properties);
                NamingHelper.bind(initialContext, string2, sessionFactory);
                log.info((Object)("Bound factory to JNDI name: " + string2));
                ((EventContext)((Object)initialContext)).addNamingListener(string2, 0, LISTENER);
            }
            catch (InvalidNameException invalidNameException) {
                log.error((Object)("Invalid JNDI name: " + string2), (Throwable)invalidNameException);
            }
            catch (NamingException namingException) {
                log.warn((Object)"Could not bind factory to JNDI", (Throwable)namingException);
            }
            catch (ClassCastException classCastException) {
                log.warn((Object)"InitialContext did not implement EventContext");
            }
        }
    }

    public static void removeInstance(String string, String string2, Properties properties) {
        if (string2 != null) {
            log.info((Object)("Unbinding factory from JNDI name: " + string2));
            try {
                InitialContext initialContext = NamingHelper.getInitialContext(properties);
                initialContext.unbind(string2);
                log.info((Object)("Unbound factory from JNDI name: " + string2));
            }
            catch (InvalidNameException invalidNameException) {
                log.error((Object)("Invalid JNDI name: " + string2), (Throwable)invalidNameException);
            }
            catch (NamingException namingException) {
                log.warn((Object)"Could not unbind factory from JNDI", (Throwable)namingException);
            }
            NAMED_INSTANCES.remove(string2);
        }
        INSTANCES.remove(string);
    }

    public static Object getNamedInstance(String string) {
        log.debug((Object)("lookup: name=" + string));
        Object object = NAMED_INSTANCES.get(string);
        if (object == null) {
            log.debug((Object)("Not found: " + string));
            log.debug((Object)NAMED_INSTANCES);
        }
        return object;
    }

    public static Object getInstance(String string) {
        log.debug((Object)("lookup: uid=" + string));
        Object object = INSTANCES.get(string);
        if (object == null) {
            log.debug((Object)("Not found: " + string));
            log.debug((Object)INSTANCES);
        }
        return object;
    }

    static {
        log = LogFactory.getLog((Class)SessionFactoryObjectFactory.class);
        INSTANCE = new SessionFactoryObjectFactory();
        log.debug((Object)"initializing class SessionFactoryObjectFactory");
        INSTANCES = new FastHashMap();
        NAMED_INSTANCES = new FastHashMap();
        LISTENER = new NamespaceChangeListener(){

            public void objectAdded(NamingEvent namingEvent) {
                log.debug((Object)("A factory was successfully bound to name: " + namingEvent.getNewBinding().getName()));
            }

            public void objectRemoved(NamingEvent namingEvent) {
                String string = namingEvent.getOldBinding().getName();
                log.info((Object)("A factory was unbound from name: " + string));
                Object object = NAMED_INSTANCES.remove(string);
                Iterator iterator = INSTANCES.values().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != object) continue;
                    iterator.remove();
                }
            }

            public void objectRenamed(NamingEvent namingEvent) {
                String string = namingEvent.getOldBinding().getName();
                log.info((Object)("A factory was renamed from name: " + string));
                NAMED_INSTANCES.put(namingEvent.getNewBinding().getName(), NAMED_INSTANCES.remove(string));
            }

            public void namingExceptionThrown(NamingExceptionEvent namingExceptionEvent) {
                log.warn((Object)("Naming exception occurred accessing factory: " + namingExceptionEvent.getException()));
            }
        };
    }
}

