/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.QueryException;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheFactory;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.OptimisticCache;
import org.hibernate.cache.OptimisticCacheSource;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.UpdateTimestampsCache;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.classic.Session;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.context.JTASessionContext;
import org.hibernate.context.ManagedSessionContext;
import org.hibernate.context.ThreadLocalSessionContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.QueryPlanCache;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.event.EventListeners;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.impl.SessionFactoryObjectFactory;
import org.hibernate.impl.SessionImpl;
import org.hibernate.impl.StatelessSessionImpl;
import org.hibernate.jdbc.BatcherFactory;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.PersisterFactory;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImpl;
import org.hibernate.stat.StatisticsImplementor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2ddl.SchemaValidator;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.ReflectHelper;

public final class SessionFactoryImpl
implements SessionFactory,
SessionFactoryImplementor {
    private final String name;
    private final String uuid;
    private final transient Map entityPersisters;
    private final transient Map classMetadata;
    private final transient Map collectionPersisters;
    private final transient Map collectionMetadata;
    private final transient Map collectionRolesByEntityParticipant;
    private final transient Map identifierGenerators;
    private final transient Map namedQueries;
    private final transient Map namedSqlQueries;
    private final transient Map sqlResultSetMappings;
    private final transient Map filters;
    private final transient Map imports;
    private final transient Interceptor interceptor;
    private final transient Settings settings;
    private final transient Properties properties;
    private transient SchemaExport schemaExport;
    private final transient TransactionManager transactionManager;
    private final transient QueryCache queryCache;
    private final transient UpdateTimestampsCache updateTimestampsCache;
    private final transient Map queryCaches;
    private final transient Map allCacheRegions = new HashMap();
    private final transient StatisticsImpl statistics = new StatisticsImpl(this);
    private final transient EventListeners eventListeners;
    private final transient CurrentSessionContext currentSessionContext;
    private final transient EntityNotFoundDelegate entityNotFoundDelegate;
    private final transient SQLFunctionRegistry sqlFunctionRegistry;
    private final QueryPlanCache queryPlanCache = new QueryPlanCache(this);
    private transient boolean isClosed = false;
    private static final IdentifierGenerator UUID_GENERATOR = new UUIDHexGenerator();
    private static final Log log = LogFactory.getLog((Class)SessionFactoryImpl.class);

    public SessionFactoryImpl(Configuration configuration, Mapping mapping, Settings settings, EventListeners eventListeners) throws HibernateException {
        HashSet<String> hashSet;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Serializable serializable;
        Object object8;
        Serializable serializable2;
        log.info((Object)"building session factory");
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)configuration.getProperties());
        this.interceptor = configuration.getInterceptor();
        this.settings = settings;
        this.sqlFunctionRegistry = new SQLFunctionRegistry(settings.getDialect(), configuration.getSqlFunctions());
        this.eventListeners = eventListeners;
        this.filters = new HashMap();
        this.filters.putAll(configuration.getFilterDefinitions());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Session factory constructed with filter configurations : " + this.filters));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("instantiating session factory with properties: " + this.properties));
        }
        settings.getCacheProvider().start(this.properties);
        this.identifierGenerators = new HashMap();
        Iterator iterator = configuration.getClassMappings();
        while (iterator.hasNext()) {
            serializable2 = (PersistentClass)iterator.next();
            if (((PersistentClass)serializable2).isInherited()) continue;
            object8 = ((PersistentClass)serializable2).getIdentifier().createIdentifierGenerator(settings.getDialect(), settings.getDefaultCatalogName(), settings.getDefaultSchemaName(), (RootClass)serializable2);
            this.identifierGenerators.put(((PersistentClass)serializable2).getEntityName(), object8);
        }
        serializable2 = new HashMap();
        this.entityPersisters = new HashMap();
        object8 = new HashMap();
        iterator = configuration.getClassMappings();
        while (iterator.hasNext()) {
            serializable = (PersistentClass)iterator.next();
            ((PersistentClass)serializable).prepareTemporaryTables(mapping, settings.getDialect());
            object7 = ((PersistentClass)serializable).getRootClass().getCacheRegionName();
            object6 = (CacheConcurrencyStrategy)serializable2.get(object7);
            if (object6 == null && (object6 = CacheFactory.createCache(((PersistentClass)serializable).getCacheConcurrencyStrategy(), (String)object7, ((PersistentClass)serializable).isMutable(), settings, this.properties)) != null) {
                serializable2.put(object7, object6);
                this.allCacheRegions.put(object6.getRegionName(), object6.getCache());
            }
            object5 = PersisterFactory.createClassPersister((PersistentClass)serializable, (CacheConcurrencyStrategy)object6, this, mapping);
            if (object6 != null && object6.getCache() instanceof OptimisticCache) {
                ((OptimisticCache)object6.getCache()).setSource((OptimisticCacheSource)object5);
            }
            this.entityPersisters.put(((PersistentClass)serializable).getEntityName(), object5);
            object8.put(((PersistentClass)serializable).getEntityName(), object5.getClassMetadata());
        }
        this.classMetadata = Collections.unmodifiableMap(object8);
        serializable = new HashMap();
        this.collectionPersisters = new HashMap();
        object7 = configuration.getCollectionMappings();
        while (object7.hasNext()) {
            object6 = (Collection)object7.next();
            object5 = CacheFactory.createCache(((Collection)object6).getCacheConcurrencyStrategy(), ((Collection)object6).getCacheRegionName(), ((Collection)object6).isMutable(), settings, this.properties);
            if (object5 != null) {
                this.allCacheRegions.put(object5.getRegionName(), object5.getCache());
            }
            object4 = PersisterFactory.createCollectionPersister(configuration, (Collection)object6, (CacheConcurrencyStrategy)object5, this);
            this.collectionPersisters.put(((Collection)object6).getRole(), object4.getCollectionMetadata());
            object3 = object4.getIndexType();
            if (object3 != null && object3.isAssociationType() && !object3.isAnyType()) {
                object2 = ((AssociationType)object3).getAssociatedEntityName(this);
                object = (Set)serializable.get(object2);
                if (object == null) {
                    object = new HashSet<String>();
                    serializable.put(object2, object);
                }
                object.add(object4.getRole());
            }
            if (!(object2 = object4.getElementType()).isAssociationType() || object2.isAnyType()) continue;
            object = ((AssociationType)object2).getAssociatedEntityName(this);
            hashSet = (HashSet<String>)serializable.get(object);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                serializable.put(object, hashSet);
            }
            hashSet.add(object4.getRole());
        }
        this.collectionMetadata = Collections.unmodifiableMap(this.collectionPersisters);
        object6 = serializable.entrySet().iterator();
        while (object6.hasNext()) {
            object5 = (Map.Entry)object6.next();
            object5.setValue(Collections.unmodifiableSet((Set)object5.getValue()));
        }
        this.collectionRolesByEntityParticipant = Collections.unmodifiableMap(serializable);
        this.namedQueries = new HashMap(configuration.getNamedQueries());
        this.namedSqlQueries = new HashMap(configuration.getNamedSQLQueries());
        this.sqlResultSetMappings = new HashMap(configuration.getSqlResultSetMappings());
        this.imports = new HashMap(configuration.getImports());
        object5 = this.entityPersisters.values().iterator();
        while (object5.hasNext()) {
            ((EntityPersister)object5.next()).postInstantiate();
        }
        object5 = this.collectionPersisters.values().iterator();
        while (object5.hasNext()) {
            ((CollectionPersister)object5.next()).postInstantiate();
        }
        this.name = settings.getSessionFactoryName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryObjectFactory.addInstance(this.uuid, this.name, this, this.properties);
        log.debug((Object)"instantiated session factory");
        if (settings.isAutoCreateSchema()) {
            new SchemaExport(configuration, settings).create(false, true);
        }
        if (settings.isAutoUpdateSchema()) {
            new SchemaUpdate(configuration, settings).execute(false, true);
        }
        if (settings.isAutoValidateSchema()) {
            new SchemaValidator(configuration, settings).validate();
        }
        if (settings.isAutoDropSchema()) {
            this.schemaExport = new SchemaExport(configuration, settings);
        }
        if (settings.getTransactionManagerLookup() != null) {
            log.debug((Object)"obtaining JTA TransactionManager");
            this.transactionManager = settings.getTransactionManagerLookup().getTransactionManager(this.properties);
        } else {
            if (settings.getTransactionFactory().isTransactionManagerRequired()) {
                throw new HibernateException("The chosen transaction strategy requires access to the JTA TransactionManager");
            }
            this.transactionManager = null;
        }
        this.currentSessionContext = this.buildCurrentSessionContext();
        if (settings.isQueryCacheEnabled()) {
            this.updateTimestampsCache = new UpdateTimestampsCache(settings, this.properties);
            this.queryCache = settings.getQueryCacheFactory().getQueryCache(null, this.updateTimestampsCache, settings, this.properties);
            this.queryCaches = new HashMap();
            this.allCacheRegions.put(this.updateTimestampsCache.getRegionName(), this.updateTimestampsCache.getCache());
            this.allCacheRegions.put(this.queryCache.getRegionName(), this.queryCache.getCache());
        } else {
            this.updateTimestampsCache = null;
            this.queryCache = null;
            this.queryCaches = null;
        }
        if (settings.isNamedQueryStartupCheckingEnabled() && !(object4 = this.checkNamedQueries()).isEmpty()) {
            object3 = object4.keySet();
            object2 = new StringBuffer("Errors in named queries: ");
            object = object3.iterator();
            while (object.hasNext()) {
                hashSet = (String)object.next();
                HibernateException hibernateException = (HibernateException)object4.get(hashSet);
                ((StringBuffer)object2).append((String)((Object)hashSet));
                if (object.hasNext()) {
                    ((StringBuffer)object2).append(", ");
                }
                log.error((Object)("Error in named query: " + (String)((Object)hashSet)), (Throwable)hibernateException);
            }
            throw new HibernateException(((StringBuffer)object2).toString());
        }
        this.getStatistics().setStatisticsEnabled(settings.isStatisticsEnabled());
        object4 = configuration.getEntityNotFoundDelegate();
        if (object4 == null) {
            object4 = new EntityNotFoundDelegate(){

                public void handleEntityNotFound(String string, Serializable serializable) {
                    throw new ObjectNotFoundException(serializable, string);
                }
            };
        }
        this.entityNotFoundDelegate = object4;
    }

    public QueryPlanCache getQueryPlanCache() {
        return this.queryPlanCache;
    }

    private Map checkNamedQueries() throws HibernateException {
        NamedQueryDefinition namedQueryDefinition;
        String string;
        Map.Entry entry;
        HashMap<String, HibernateException> hashMap = new HashMap<String, HibernateException>();
        log.debug((Object)("Checking " + this.namedQueries.size() + " named HQL queries"));
        Iterator iterator = this.namedQueries.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            namedQueryDefinition = (NamedQueryDefinition)entry.getValue();
            try {
                log.debug((Object)("Checking named query: " + string));
                this.queryPlanCache.getHQLQueryPlan(namedQueryDefinition.getQueryString(), false, CollectionHelper.EMPTY_MAP);
            }
            catch (QueryException queryException) {
                hashMap.put(string, queryException);
            }
            catch (MappingException mappingException) {
                hashMap.put(string, mappingException);
            }
        }
        log.debug((Object)("Checking " + this.namedSqlQueries.size() + " named SQL queries"));
        iterator = this.namedSqlQueries.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            namedQueryDefinition = (NamedSQLQueryDefinition)entry.getValue();
            try {
                log.debug((Object)("Checking named SQL query: " + string));
                NativeSQLQuerySpecification nativeSQLQuerySpecification = null;
                if (((NamedSQLQueryDefinition)namedQueryDefinition).getResultSetRef() != null) {
                    ResultSetMappingDefinition resultSetMappingDefinition = (ResultSetMappingDefinition)this.sqlResultSetMappings.get(((NamedSQLQueryDefinition)namedQueryDefinition).getResultSetRef());
                    if (resultSetMappingDefinition == null) {
                        throw new MappingException("Unable to find resultset-ref definition: " + ((NamedSQLQueryDefinition)namedQueryDefinition).getResultSetRef());
                    }
                    nativeSQLQuerySpecification = new NativeSQLQuerySpecification(namedQueryDefinition.getQueryString(), resultSetMappingDefinition.getQueryReturns(), ((NamedSQLQueryDefinition)namedQueryDefinition).getQuerySpaces());
                } else {
                    nativeSQLQuerySpecification = new NativeSQLQuerySpecification(namedQueryDefinition.getQueryString(), ((NamedSQLQueryDefinition)namedQueryDefinition).getQueryReturns(), ((NamedSQLQueryDefinition)namedQueryDefinition).getQuerySpaces());
                }
                this.queryPlanCache.getNativeSQLQueryPlan(nativeSQLQuerySpecification);
            }
            catch (QueryException queryException) {
                hashMap.put(string, queryException);
            }
            catch (MappingException mappingException) {
                hashMap.put(string, mappingException);
            }
        }
        return hashMap;
    }

    public StatelessSession openStatelessSession() {
        return new StatelessSessionImpl(null, this);
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return new StatelessSessionImpl(connection, this);
    }

    private SessionImpl openSession(Connection connection, boolean bl, long l, Interceptor interceptor) {
        return new SessionImpl(connection, this, bl, l, interceptor == null ? this.interceptor : interceptor, this.settings.getDefaultEntityMode(), this.settings.isFlushBeforeCompletionEnabled(), this.settings.isAutoCloseSessionEnabled(), this.settings.getConnectionReleaseMode());
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.openSession(connection, false, Long.MIN_VALUE, interceptor);
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        long l = this.settings.getCacheProvider().nextTimestamp();
        return this.openSession(null, true, l, interceptor);
    }

    public Session openSession(Connection connection) {
        return this.openSession(connection, this.interceptor);
    }

    public Session openSession() throws HibernateException {
        return this.openSession(this.interceptor);
    }

    public Session openTemporarySession() throws HibernateException {
        return new SessionImpl(null, this, true, this.settings.getCacheProvider().nextTimestamp(), this.interceptor, this.settings.getDefaultEntityMode(), false, false, ConnectionReleaseMode.AFTER_STATEMENT);
    }

    public Session openSession(Connection connection, boolean bl, boolean bl2, ConnectionReleaseMode connectionReleaseMode) throws HibernateException {
        return new SessionImpl(connection, this, true, this.settings.getCacheProvider().nextTimestamp(), this.interceptor, this.settings.getDefaultEntityMode(), bl, bl2, connectionReleaseMode);
    }

    public Session getCurrentSession() throws HibernateException {
        if (this.currentSessionContext == null) {
            throw new HibernateException("No CurrentSessionContext configured!");
        }
        return this.currentSessionContext.currentSession();
    }

    public EntityPersister getEntityPersister(String string) throws MappingException {
        EntityPersister entityPersister = (EntityPersister)this.entityPersisters.get(string);
        if (entityPersister == null) {
            throw new MappingException("Unknown entity: " + string);
        }
        return entityPersister;
    }

    public CollectionPersister getCollectionPersister(String string) throws MappingException {
        CollectionPersister collectionPersister = (CollectionPersister)this.collectionPersisters.get(string);
        if (collectionPersister == null) {
            throw new MappingException("Unknown collection role: " + string);
        }
        return collectionPersister;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Dialect getDialect() {
        return this.settings.getDialect();
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public TransactionFactory getTransactionFactory() {
        return this.settings.getTransactionFactory();
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.settings.getSQLExceptionConverter();
    }

    public Set getCollectionRolesByEntityParticipant(String string) {
        return (Set)this.collectionRolesByEntityParticipant.get(string);
    }

    public Reference getReference() throws NamingException {
        log.debug((Object)"Returning a Reference to the SessionFactory");
        return new Reference(SessionFactoryImpl.class.getName(), new StringRefAddr("uuid", this.uuid), SessionFactoryObjectFactory.class.getName(), null);
    }

    private Object readResolve() throws ObjectStreamException {
        log.trace((Object)"Resolving serialized SessionFactory");
        Object object = SessionFactoryObjectFactory.getInstance(this.uuid);
        if (object == null) {
            object = SessionFactoryObjectFactory.getNamedInstance(this.name);
            if (object == null) {
                throw new InvalidObjectException("Could not find a SessionFactory named: " + this.name);
            }
            log.debug((Object)"resolved SessionFactory by name");
        } else {
            log.debug((Object)"resolved SessionFactory by uid");
        }
        return object;
    }

    public NamedQueryDefinition getNamedQuery(String string) {
        return (NamedQueryDefinition)this.namedQueries.get(string);
    }

    public NamedSQLQueryDefinition getNamedSQLQuery(String string) {
        return (NamedSQLQueryDefinition)this.namedSqlQueries.get(string);
    }

    public ResultSetMappingDefinition getResultSetMapping(String string) {
        return (ResultSetMappingDefinition)this.sqlResultSetMappings.get(string);
    }

    public Type getIdentifierType(String string) throws MappingException {
        return this.getEntityPersister(string).getIdentifierType();
    }

    public String getIdentifierPropertyName(String string) throws MappingException {
        return this.getEntityPersister(string).getIdentifierPropertyName();
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        log.trace((Object)"deserializing");
        objectInputStream.defaultReadObject();
        log.debug((Object)("deserialized: " + this.uuid));
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        log.debug((Object)("serializing: " + this.uuid));
        objectOutputStream.defaultWriteObject();
        log.trace((Object)"serialized");
    }

    public Type[] getReturnTypes(String string) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(string, false, CollectionHelper.EMPTY_MAP).getReturnMetadata().getReturnTypes();
    }

    public String[] getReturnAliases(String string) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(string, false, CollectionHelper.EMPTY_MAP).getReturnMetadata().getReturnAliases();
    }

    public ClassMetadata getClassMetadata(Class clazz) throws HibernateException {
        return this.getClassMetadata(clazz.getName());
    }

    public CollectionMetadata getCollectionMetadata(String string) throws HibernateException {
        return (CollectionMetadata)this.collectionMetadata.get(string);
    }

    public ClassMetadata getClassMetadata(String string) throws HibernateException {
        return (ClassMetadata)this.classMetadata.get(string);
    }

    public String[] getImplementors(String string) throws MappingException {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.entityPersisters.values().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            EntityPersister entityPersister = (EntityPersister)iterator.next();
            if (!(entityPersister instanceof Queryable)) continue;
            Queryable queryable = (Queryable)entityPersister;
            String string2 = queryable.getEntityName();
            boolean bl2 = string.equals(string2);
            if (queryable.isExplicitPolymorphism()) {
                if (!bl2) continue;
                return new String[]{string};
            }
            if (bl2) {
                arrayList.add(string2);
                continue;
            }
            Class clazz2 = queryable.getMappedClass(EntityMode.POJO);
            if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) continue;
            if (queryable.isInherited()) {
                Class clazz3 = this.getEntityPersister(queryable.getMappedSuperclass()).getMappedClass(EntityMode.POJO);
                bl = clazz.isAssignableFrom(clazz3);
            } else {
                bl = false;
            }
            if (bl) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getImportedClassName(String string) {
        String string2 = (String)this.imports.get(string);
        if (string2 == null) {
            try {
                ReflectHelper.classForName(string);
                return string;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return string2;
    }

    public Map getAllClassMetadata() throws HibernateException {
        return this.classMetadata;
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return this.collectionMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws HibernateException {
        Object object;
        log.info((Object)"closing");
        this.isClosed = true;
        Iterator iterator = this.entityPersisters.values().iterator();
        while (iterator.hasNext()) {
            object = (EntityPersister)iterator.next();
            if (!object.hasCache()) continue;
            object.getCache().destroy();
        }
        iterator = this.collectionPersisters.values().iterator();
        while (iterator.hasNext()) {
            object = (CollectionPersister)iterator.next();
            if (!object.hasCache()) continue;
            object.getCache().destroy();
        }
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.destroy();
            iterator = this.queryCaches.values().iterator();
            while (iterator.hasNext()) {
                object = (QueryCache)iterator.next();
                object.destroy();
            }
            this.updateTimestampsCache.destroy();
        }
        this.settings.getCacheProvider().stop();
        try {
            this.settings.getConnectionProvider().close();
        }
        finally {
            SessionFactoryObjectFactory.removeInstance(this.uuid, this.name, this.properties);
        }
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport.drop(false, true);
        }
    }

    public void evictEntity(String string, Serializable serializable) throws HibernateException {
        EntityPersister entityPersister = this.getEntityPersister(string);
        if (entityPersister.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evicting second-level cache: " + MessageHelper.infoString(entityPersister, serializable, (SessionFactoryImplementor)this)));
            }
            CacheKey cacheKey = new CacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), EntityMode.POJO, this);
            entityPersister.getCache().remove(cacheKey);
        }
    }

    public void evictEntity(String string) throws HibernateException {
        EntityPersister entityPersister = this.getEntityPersister(string);
        if (entityPersister.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evicting second-level cache: " + entityPersister.getEntityName()));
            }
            entityPersister.getCache().clear();
        }
    }

    public void evict(Class clazz, Serializable serializable) throws HibernateException {
        EntityPersister entityPersister = this.getEntityPersister(clazz.getName());
        if (entityPersister.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evicting second-level cache: " + MessageHelper.infoString(entityPersister, serializable, (SessionFactoryImplementor)this)));
            }
            CacheKey cacheKey = new CacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), EntityMode.POJO, this);
            entityPersister.getCache().remove(cacheKey);
        }
    }

    public void evict(Class clazz) throws HibernateException {
        EntityPersister entityPersister = this.getEntityPersister(clazz.getName());
        if (entityPersister.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evicting second-level cache: " + entityPersister.getEntityName()));
            }
            entityPersister.getCache().clear();
        }
    }

    public void evictCollection(String string, Serializable serializable) throws HibernateException {
        CollectionPersister collectionPersister = this.getCollectionPersister(string);
        if (collectionPersister.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evicting second-level cache: " + MessageHelper.collectionInfoString(collectionPersister, serializable, (SessionFactoryImplementor)this)));
            }
            CacheKey cacheKey = new CacheKey(serializable, collectionPersister.getKeyType(), collectionPersister.getRole(), EntityMode.POJO, this);
            collectionPersister.getCache().remove(cacheKey);
        }
    }

    public void evictCollection(String string) throws HibernateException {
        CollectionPersister collectionPersister = this.getCollectionPersister(string);
        if (collectionPersister.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evicting second-level cache: " + collectionPersister.getRole()));
            }
            collectionPersister.getCache().clear();
        }
    }

    public Type getReferencedPropertyType(String string, String string2) throws MappingException {
        return this.getEntityPersister(string).getPropertyType(string2);
    }

    public ConnectionProvider getConnectionProvider() {
        return this.settings.getConnectionProvider();
    }

    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.updateTimestampsCache;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCache getQueryCache(String string) throws HibernateException {
        if (string == null) {
            return this.getQueryCache();
        }
        if (!this.settings.isQueryCacheEnabled()) {
            return null;
        }
        Map map = this.allCacheRegions;
        synchronized (map) {
            QueryCache queryCache = (QueryCache)this.queryCaches.get(string);
            if (queryCache == null) {
                queryCache = this.settings.getQueryCacheFactory().getQueryCache(string, this.updateTimestampsCache, this.settings, this.properties);
                this.queryCaches.put(string, queryCache);
                this.allCacheRegions.put(queryCache.getRegionName(), queryCache.getCache());
            }
            return queryCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getSecondLevelCacheRegion(String string) {
        Map map = this.allCacheRegions;
        synchronized (map) {
            return (Cache)this.allCacheRegions.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAllSecondLevelCacheRegions() {
        Map map = this.allCacheRegions;
        synchronized (map) {
            return new HashMap(this.allCacheRegions);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public StatisticsImplementor getStatisticsImplementor() {
        return this.statistics;
    }

    public void evictQueries() throws HibernateException {
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictQueries(String string) throws HibernateException {
        if (string == null) {
            throw new NullPointerException("use the zero-argument form to evict the default query cache");
        }
        Map map = this.allCacheRegions;
        synchronized (map) {
            QueryCache queryCache;
            if (this.settings.isQueryCacheEnabled() && (queryCache = (QueryCache)this.queryCaches.get(string)) != null) {
                queryCache.clear();
            }
        }
    }

    public FilterDefinition getFilterDefinition(String string) throws HibernateException {
        FilterDefinition filterDefinition = (FilterDefinition)this.filters.get(string);
        if (filterDefinition == null) {
            throw new HibernateException("No such filter configured [" + string + "]");
        }
        return filterDefinition;
    }

    public Set getDefinedFilterNames() {
        return this.filters.keySet();
    }

    public BatcherFactory getBatcherFactory() {
        return this.settings.getBatcherFactory();
    }

    public IdentifierGenerator getIdentifierGenerator(String string) {
        return (IdentifierGenerator)this.identifierGenerators.get(string);
    }

    private CurrentSessionContext buildCurrentSessionContext() {
        String string = this.properties.getProperty("hibernate.current_session_context_class");
        if (string == null && this.transactionManager != null) {
            string = "jta";
        }
        if (string == null) {
            return null;
        }
        if ("jta".equals(string)) {
            if (this.settings.getTransactionFactory().areCallbacksLocalToHibernateTransactions()) {
                log.warn((Object)"JTASessionContext being used with JDBCTransactionFactory; auto-flush will not operate correctly with getCurrentSession()");
            }
            return new JTASessionContext(this);
        }
        if ("thread".equals(string)) {
            return new ThreadLocalSessionContext(this);
        }
        if ("managed".equals(string)) {
            return new ManagedSessionContext(this);
        }
        try {
            Class clazz = ReflectHelper.classForName(string);
            return (CurrentSessionContext)clazz.getConstructor(SessionFactoryImplementor.class).newInstance(this);
        }
        catch (Throwable throwable) {
            log.error((Object)("Unable to construct current session context [" + string + "]"), throwable);
            return null;
        }
    }

    public EventListeners getEventListeners() {
        return this.eventListeners;
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.uuid);
        objectOutputStream.writeBoolean(this.name != null);
        if (this.name != null) {
            objectOutputStream.writeUTF(this.name);
        }
    }

    static SessionFactoryImpl deserialize(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        String string = objectInputStream.readUTF();
        boolean bl = objectInputStream.readBoolean();
        String string2 = null;
        if (bl) {
            string2 = objectInputStream.readUTF();
        }
        if ((object = SessionFactoryObjectFactory.getInstance(string)) == null) {
            log.trace((Object)("could not locate session factory by uuid [" + string + "] during session deserialization; trying name"));
            if (bl) {
                object = SessionFactoryObjectFactory.getNamedInstance(string2);
            }
            if (object == null) {
                throw new InvalidObjectException("could not resolve session factory during session deserialization [uuid=" + string + ", name=" + string2 + "]");
            }
        }
        return (SessionFactoryImpl)object;
    }

    public SQLFunctionRegistry getSqlFunctionRegistry() {
        return this.sqlFunctionRegistry;
    }
}

