/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.engine.query.sql.NativeSQLQueryJoinReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryScalarReturn;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.StringHelper;

public class SQLQueryImpl
extends AbstractQueryImpl
implements SQLQuery {
    private final List queryReturns;
    private Collection querySpaces;
    private final boolean callable;
    private boolean autodiscovertypes;
    private static final NativeSQLQueryReturn[] NO_SQL_RETURNS = new NativeSQLQueryReturn[0];

    SQLQueryImpl(NamedSQLQueryDefinition namedSQLQueryDefinition, SessionImplementor sessionImplementor, ParameterMetadata parameterMetadata) {
        super(namedSQLQueryDefinition.getQueryString(), namedSQLQueryDefinition.getFlushMode(), sessionImplementor, parameterMetadata);
        if (namedSQLQueryDefinition.getResultSetRef() != null) {
            ResultSetMappingDefinition resultSetMappingDefinition = sessionImplementor.getFactory().getResultSetMapping(namedSQLQueryDefinition.getResultSetRef());
            if (resultSetMappingDefinition == null) {
                throw new MappingException("Unable to find resultset-ref definition: " + namedSQLQueryDefinition.getResultSetRef());
            }
            this.queryReturns = Arrays.asList(resultSetMappingDefinition.getQueryReturns());
        } else {
            this.queryReturns = Arrays.asList(namedSQLQueryDefinition.getQueryReturns());
        }
        this.querySpaces = namedSQLQueryDefinition.getQuerySpaces();
        this.callable = namedSQLQueryDefinition.isCallable();
    }

    SQLQueryImpl(String string, List list, Collection collection, FlushMode flushMode, boolean bl, SessionImplementor sessionImplementor, ParameterMetadata parameterMetadata) {
        super(string, flushMode, sessionImplementor, parameterMetadata);
        this.queryReturns = list;
        this.querySpaces = collection;
        this.callable = bl;
    }

    SQLQueryImpl(String string, String[] stringArray, Class[] classArray, LockMode[] lockModeArray, SessionImplementor sessionImplementor, Collection collection, FlushMode flushMode, ParameterMetadata parameterMetadata) {
        super(string, flushMode, sessionImplementor, parameterMetadata);
        this.queryReturns = new ArrayList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            NativeSQLQueryRootReturn nativeSQLQueryRootReturn = new NativeSQLQueryRootReturn(stringArray[i], classArray[i].getName(), lockModeArray == null ? LockMode.NONE : lockModeArray[i]);
            this.queryReturns.add(nativeSQLQueryRootReturn);
        }
        this.querySpaces = collection;
        this.callable = false;
    }

    SQLQueryImpl(String string, String[] stringArray, Class[] classArray, SessionImplementor sessionImplementor, ParameterMetadata parameterMetadata) {
        this(string, stringArray, classArray, null, sessionImplementor, null, null, parameterMetadata);
    }

    SQLQueryImpl(String string, SessionImplementor sessionImplementor, ParameterMetadata parameterMetadata) {
        super(string, null, sessionImplementor, parameterMetadata);
        this.queryReturns = new ArrayList();
        this.querySpaces = null;
        this.callable = false;
    }

    private NativeSQLQueryReturn[] getQueryReturns() {
        return this.queryReturns.toArray(NO_SQL_RETURNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() throws HibernateException {
        this.verifyParameters();
        this.before();
        Map map = this.getNamedParams();
        NativeSQLQuerySpecification nativeSQLQuerySpecification = this.generateQuerySpecification(map);
        try {
            List list = this.getSession().list(nativeSQLQuerySpecification, this.getQueryParameters(map));
            return list;
        }
        finally {
            this.after();
        }
    }

    private NativeSQLQuerySpecification generateQuerySpecification(Map map) {
        return new NativeSQLQuerySpecification(this.expandParameterLists(map), this.getQueryReturns(), this.querySpaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        this.verifyParameters();
        this.before();
        Map map = this.getNamedParams();
        NativeSQLQuerySpecification nativeSQLQuerySpecification = this.generateQuerySpecification(map);
        QueryParameters queryParameters = this.getQueryParameters(map);
        queryParameters.setScrollMode(scrollMode);
        try {
            ScrollableResults scrollableResults = this.getSession().scroll(nativeSQLQuerySpecification, queryParameters);
            return scrollableResults;
        }
        finally {
            this.after();
        }
    }

    public ScrollableResults scroll() throws HibernateException {
        return this.scroll(ScrollMode.SCROLL_INSENSITIVE);
    }

    public Iterator iterate() throws HibernateException {
        throw new UnsupportedOperationException("SQL queries do not currently support iteration");
    }

    public QueryParameters getQueryParameters(Map map) {
        QueryParameters queryParameters = super.getQueryParameters(map);
        queryParameters.setCallable(this.callable);
        queryParameters.setAutoDiscoverScalarTypes(this.autodiscovertypes);
        return queryParameters;
    }

    protected void verifyParameters() {
        boolean bl;
        this.verifyParameters(this.callable);
        boolean bl2 = bl = this.queryReturns == null || this.queryReturns.isEmpty();
        if (bl) {
            this.autodiscovertypes = bl;
        } else {
            Iterator iterator = this.queryReturns.iterator();
            while (iterator.hasNext()) {
                NativeSQLQueryScalarReturn nativeSQLQueryScalarReturn;
                NativeSQLQueryReturn nativeSQLQueryReturn = (NativeSQLQueryReturn)iterator.next();
                if (!(nativeSQLQueryReturn instanceof NativeSQLQueryScalarReturn) || (nativeSQLQueryScalarReturn = (NativeSQLQueryScalarReturn)nativeSQLQueryReturn).getType() != null) continue;
                this.autodiscovertypes = true;
                break;
            }
        }
    }

    public String[] getReturnAliases() throws HibernateException {
        throw new UnsupportedOperationException("SQL queries do not currently support returning aliases");
    }

    public Type[] getReturnTypes() throws HibernateException {
        throw new UnsupportedOperationException("not yet implemented for SQL queries");
    }

    public Query setLockMode(String string, LockMode lockMode) {
        throw new UnsupportedOperationException("cannot set the lock mode for a native SQL query");
    }

    protected Map getLockModes() {
        return CollectionHelper.EMPTY_MAP;
    }

    public SQLQuery addScalar(String string, Type type) {
        this.queryReturns.add(new NativeSQLQueryScalarReturn(string, type));
        return this;
    }

    public SQLQuery addScalar(String string) {
        this.autodiscovertypes = true;
        this.queryReturns.add(new NativeSQLQueryScalarReturn(string, null));
        return this;
    }

    public SQLQuery addJoin(String string, String string2) {
        return this.addJoin(string, string2, LockMode.READ);
    }

    public SQLQuery addEntity(Class clazz) {
        return this.addEntity(StringHelper.unqualify(clazz.getName()), clazz);
    }

    public SQLQuery addEntity(String string) {
        return this.addEntity(StringHelper.unqualify(string), string);
    }

    public SQLQuery addEntity(String string, String string2) {
        return this.addEntity(string, string2, LockMode.READ);
    }

    public SQLQuery addEntity(String string, Class clazz) {
        return this.addEntity(string, clazz.getName());
    }

    public SQLQuery addJoin(String string, String string2, LockMode lockMode) {
        int n = string2.indexOf(46);
        if (n < 0) {
            throw new QueryException("not a property path: " + string2);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        this.queryReturns.add(new NativeSQLQueryJoinReturn(string, string3, string4, CollectionHelper.EMPTY_MAP, lockMode));
        return this;
    }

    public SQLQuery addEntity(String string, String string2, LockMode lockMode) {
        this.queryReturns.add(new NativeSQLQueryRootReturn(string, string2, lockMode));
        return this;
    }

    public SQLQuery addEntity(String string, Class clazz, LockMode lockMode) {
        return this.addEntity(string, clazz.getName(), lockMode);
    }

    public SQLQuery setResultSetMapping(String string) {
        ResultSetMappingDefinition resultSetMappingDefinition = this.session.getFactory().getResultSetMapping(string);
        if (resultSetMappingDefinition == null) {
            throw new MappingException("Unknown SqlResultSetMapping [" + string + "]");
        }
        NativeSQLQueryReturn[] nativeSQLQueryReturnArray = resultSetMappingDefinition.getQueryReturns();
        int n = nativeSQLQueryReturnArray.length;
        for (int i = 0; i < n; ++i) {
            this.queryReturns.add(nativeSQLQueryReturnArray[i]);
        }
        return this;
    }

    public SQLQuery addSynchronizedQuerySpace(String string) {
        if (this.querySpaces == null) {
            this.querySpaces = new ArrayList();
        }
        this.querySpaces.add(string);
        return this;
    }

    public SQLQuery addSynchronizedEntityName(String string) {
        return this.addQuerySpaces(this.getSession().getFactory().getEntityPersister(string).getQuerySpaces());
    }

    public SQLQuery addSynchronizedEntityClass(Class clazz) {
        return this.addQuerySpaces(this.getSession().getFactory().getEntityPersister(clazz.getName()).getQuerySpaces());
    }

    private SQLQuery addQuerySpaces(Serializable[] serializableArray) {
        if (serializableArray != null) {
            if (this.querySpaces == null) {
                this.querySpaces = new ArrayList();
            }
            for (int i = 0; i < serializableArray.length; ++i) {
                this.querySpaces.add(serializableArray[i]);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws HibernateException {
        Map map = this.getNamedParams();
        this.before();
        try {
            int n = this.getSession().executeNativeUpdate(this.generateQuerySpecification(map), this.getQueryParameters(map));
            return n;
        }
        finally {
            this.after();
        }
    }
}

