/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.impl.AbstractQueryImpl;

public class QueryImpl
extends AbstractQueryImpl {
    private Map lockModes = new HashMap(2);

    public QueryImpl(String string, FlushMode flushMode, SessionImplementor sessionImplementor, ParameterMetadata parameterMetadata) {
        super(string, flushMode, sessionImplementor, parameterMetadata);
    }

    public QueryImpl(String string, SessionImplementor sessionImplementor, ParameterMetadata parameterMetadata) {
        this(string, null, sessionImplementor, parameterMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterate() throws HibernateException {
        this.verifyParameters();
        Map map = this.getNamedParams();
        this.before();
        try {
            Iterator iterator = this.getSession().iterate(this.expandParameterLists(map), this.getQueryParameters(map));
            return iterator;
        }
        finally {
            this.after();
        }
    }

    public ScrollableResults scroll() throws HibernateException {
        return this.scroll(ScrollMode.SCROLL_INSENSITIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        this.verifyParameters();
        Map map = this.getNamedParams();
        this.before();
        QueryParameters queryParameters = this.getQueryParameters(map);
        queryParameters.setScrollMode(scrollMode);
        try {
            ScrollableResults scrollableResults = this.getSession().scroll(this.expandParameterLists(map), queryParameters);
            return scrollableResults;
        }
        finally {
            this.after();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() throws HibernateException {
        this.verifyParameters();
        Map map = this.getNamedParams();
        this.before();
        try {
            List list = this.getSession().list(this.expandParameterLists(map), this.getQueryParameters(map));
            return list;
        }
        finally {
            this.after();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws HibernateException {
        this.verifyParameters();
        Map map = this.getNamedParams();
        this.before();
        try {
            int n = this.getSession().executeUpdate(this.expandParameterLists(map), this.getQueryParameters(map));
            return n;
        }
        finally {
            this.after();
        }
    }

    public Query setLockMode(String string, LockMode lockMode) {
        this.lockModes.put(string, lockMode);
        return this;
    }

    protected Map getLockModes() {
        return this.lockModes;
    }
}

