/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.engine.HibernateIterator;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public final class IteratorImpl
implements HibernateIterator {
    private static final Log log = LogFactory.getLog((Class)IteratorImpl.class);
    private ResultSet rs;
    private final EventSource session;
    private final Type[] types;
    private final boolean single;
    private Object currentResult;
    private boolean hasNext;
    private final String[][] names;
    private PreparedStatement ps;
    private Object nextResult;
    private HolderInstantiator holderInstantiator;

    public IteratorImpl(ResultSet resultSet, PreparedStatement preparedStatement, EventSource eventSource, Type[] typeArray, String[][] stringArray, HolderInstantiator holderInstantiator) throws HibernateException, SQLException {
        this.rs = resultSet;
        this.ps = preparedStatement;
        this.session = eventSource;
        this.types = typeArray;
        this.names = stringArray;
        this.holderInstantiator = holderInstantiator;
        this.single = typeArray.length == 1;
        this.postNext();
    }

    public void close() throws JDBCException {
        if (this.ps != null) {
            try {
                log.debug((Object)"closing iterator");
                this.nextResult = null;
                this.session.getBatcher().closeQueryStatement(this.ps, this.rs);
                this.ps = null;
                this.rs = null;
                this.hasNext = false;
            }
            catch (SQLException sQLException) {
                log.info((Object)"Unable to close iterator", (Throwable)sQLException);
                throw JDBCExceptionHelper.convert(this.session.getFactory().getSQLExceptionConverter(), sQLException, "Unable to close iterator");
            }
        }
    }

    private void postNext() throws HibernateException, SQLException {
        this.hasNext = this.rs.next();
        if (!this.hasNext) {
            log.debug((Object)"exhausted results");
            this.close();
        } else {
            log.debug((Object)"retrieving next results");
            boolean bl = this.holderInstantiator.isRequired();
            if (this.single && !bl) {
                this.nextResult = this.types[0].nullSafeGet(this.rs, this.names[0], (SessionImplementor)this.session, null);
            } else {
                Object[] objectArray = new Object[this.types.length];
                for (int i = 0; i < this.types.length; ++i) {
                    objectArray[i] = this.types[i].nullSafeGet(this.rs, this.names[i], (SessionImplementor)this.session, null);
                }
                this.nextResult = bl ? this.holderInstantiator.instantiate(objectArray) : objectArray;
            }
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Object next() {
        if (!this.hasNext) {
            throw new NoSuchElementException("No more results");
        }
        try {
            this.currentResult = this.nextResult;
            this.postNext();
            log.debug((Object)"returning current results");
            return this.currentResult;
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.session.getFactory().getSQLExceptionConverter(), sQLException, "could not get next iterator result");
        }
    }

    public void remove() {
        if (!this.single) {
            throw new UnsupportedOperationException("Not a single column hibernate query result set");
        }
        if (this.currentResult == null) {
            throw new IllegalStateException("Called Iterator.remove() before next()");
        }
        if (!(this.types[0] instanceof EntityType)) {
            throw new UnsupportedOperationException("Not an entity");
        }
        this.session.delete(((EntityType)this.types[0]).getAssociatedEntityName(), this.currentResult, false, null);
    }
}

