/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.type.Type;

public class FilterImpl
implements Filter,
Serializable {
    public static final String MARKER = "$FILTER_PLACEHOLDER$";
    private transient FilterDefinition definition;
    private String filterName;
    private Map parameters = new HashMap();

    void afterDeserialize(SessionFactoryImpl sessionFactoryImpl) {
        this.definition = sessionFactoryImpl.getFilterDefinition(this.filterName);
    }

    public FilterImpl(FilterDefinition filterDefinition) {
        this.definition = filterDefinition;
        this.filterName = this.definition.getFilterName();
    }

    public FilterDefinition getFilterDefinition() {
        return this.definition;
    }

    public String getName() {
        return this.definition.getFilterName();
    }

    public Map getParameters() {
        return this.parameters;
    }

    public Filter setParameter(String string, Object object) throws IllegalArgumentException {
        Type type = this.definition.getParameterType(string);
        if (type == null) {
            throw new IllegalArgumentException("Undefined filter parameter [" + string + "]");
        }
        if (object != null && !type.getReturnedClass().isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Incorrect type for parameter [" + string + "]");
        }
        this.parameters.put(string, object);
        return this;
    }

    public Filter setParameterList(String string, Collection collection) throws HibernateException {
        if (collection == null) {
            throw new IllegalArgumentException("Collection must be not null!");
        }
        Type type = this.definition.getParameterType(string);
        if (type == null) {
            throw new HibernateException("Undefined filter parameter [" + string + "]");
        }
        if (collection.size() > 0) {
            Class<?> clazz = collection.iterator().next().getClass();
            if (!type.getReturnedClass().isAssignableFrom(clazz)) {
                throw new HibernateException("Incorrect type for parameter [" + string + "]");
            }
        }
        this.parameters.put(string, collection);
        return this;
    }

    public Filter setParameterList(String string, Object[] objectArray) throws IllegalArgumentException {
        return this.setParameterList(string, Arrays.asList(objectArray));
    }

    public Object getParameter(String string) {
        return this.parameters.get(string);
    }

    public void validate() throws HibernateException {
        Iterator iterator = this.definition.getParameterNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.parameters.get(string) != null) continue;
            throw new HibernateException("Filter [" + this.getName() + "] parameter [" + string + "] value not set");
        }
    }
}

