/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.impl.AbstractScrollableResults;
import org.hibernate.loader.Loader;
import org.hibernate.type.Type;

public class FetchingScrollableResultsImpl
extends AbstractScrollableResults {
    private Object[] currentRow = null;
    private int currentPosition = 0;
    private Integer maxPosition = null;

    public FetchingScrollableResultsImpl(ResultSet resultSet, PreparedStatement preparedStatement, SessionImplementor sessionImplementor, Loader loader, QueryParameters queryParameters, Type[] typeArray, HolderInstantiator holderInstantiator) throws MappingException {
        super(resultSet, preparedStatement, sessionImplementor, loader, queryParameters, typeArray, holderInstantiator);
    }

    protected Object[] getCurrentRow() {
        return this.currentRow;
    }

    public boolean next() throws HibernateException {
        boolean bl;
        if (this.maxPosition != null && this.maxPosition <= this.currentPosition) {
            this.currentRow = null;
            this.currentPosition = this.maxPosition + 1;
            return false;
        }
        Object object = this.getLoader().loadSequentialRowsForward(this.getResultSet(), this.getSession(), this.getQueryParameters(), false);
        try {
            bl = this.getResultSet().isAfterLast();
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getSession().getFactory().getSQLExceptionConverter(), sQLException, "exception calling isAfterLast()");
        }
        ++this.currentPosition;
        this.currentRow = new Object[]{object};
        if (bl && this.maxPosition == null) {
            this.maxPosition = new Integer(this.currentPosition);
        }
        this.afterScrollOperation();
        return true;
    }

    public boolean previous() throws HibernateException {
        if (this.currentPosition <= 1) {
            this.currentPosition = 0;
            this.currentRow = null;
            return false;
        }
        Object object = this.getLoader().loadSequentialRowsReverse(this.getResultSet(), this.getSession(), this.getQueryParameters(), false, this.maxPosition != null && this.currentPosition > this.maxPosition);
        this.currentRow = new Object[]{object};
        --this.currentPosition;
        this.afterScrollOperation();
        return true;
    }

    public boolean scroll(int n) throws HibernateException {
        boolean bl = false;
        if (n > 0) {
            for (int i = 0; i < n && (bl = this.next()); ++i) {
            }
        } else if (n < 0) {
            for (int i = 0; i < 0 - n && (bl = this.previous()); ++i) {
            }
        } else {
            throw new HibernateException("scroll(0) not valid");
        }
        this.afterScrollOperation();
        return bl;
    }

    public boolean last() throws HibernateException {
        boolean bl = false;
        if (this.maxPosition != null) {
            for (int i = this.currentPosition; i < this.maxPosition; ++i) {
                bl = this.next();
            }
        } else {
            try {
                if (this.getResultSet().isAfterLast()) {
                    return false;
                }
                while (!this.getResultSet().isAfterLast()) {
                    bl = this.next();
                }
            }
            catch (SQLException sQLException) {
                throw JDBCExceptionHelper.convert(this.getSession().getFactory().getSQLExceptionConverter(), sQLException, "exception calling isAfterLast()");
            }
        }
        this.afterScrollOperation();
        return bl;
    }

    public boolean first() throws HibernateException {
        this.beforeFirst();
        boolean bl = this.next();
        this.afterScrollOperation();
        return bl;
    }

    public void beforeFirst() throws HibernateException {
        try {
            this.getResultSet().beforeFirst();
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getSession().getFactory().getSQLExceptionConverter(), sQLException, "exception calling beforeFirst()");
        }
        this.currentRow = null;
        this.currentPosition = 0;
    }

    public void afterLast() throws HibernateException {
        this.last();
        this.next();
        this.afterScrollOperation();
    }

    public boolean isFirst() throws HibernateException {
        return this.currentPosition == 1;
    }

    public boolean isLast() throws HibernateException {
        if (this.maxPosition == null) {
            return false;
        }
        return this.currentPosition == this.maxPosition;
    }

    public int getRowNumber() throws HibernateException {
        return this.currentPosition;
    }

    public boolean setRowNumber(int n) throws HibernateException {
        if (n == 1) {
            return this.first();
        }
        if (n == -1) {
            return this.last();
        }
        if (this.maxPosition != null && n == this.maxPosition) {
            return this.last();
        }
        return this.scroll(n - this.currentPosition);
    }
}

