/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionException;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.engine.query.NativeSQLQueryPlan;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.impl.QueryImpl;
import org.hibernate.impl.SQLQueryImpl;
import org.hibernate.impl.SessionFactoryImpl;

public abstract class AbstractSessionImpl
implements SessionImplementor {
    protected transient SessionFactoryImpl factory;
    private boolean closed = false;

    protected AbstractSessionImpl(SessionFactoryImpl sessionFactoryImpl) {
        this.factory = sessionFactoryImpl;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void setClosed() {
        this.closed = true;
    }

    protected void errorIfClosed() {
        if (this.closed) {
            throw new SessionException("Session is closed!");
        }
    }

    public Query getNamedQuery(String string) throws MappingException {
        AbstractQueryImpl abstractQueryImpl;
        this.errorIfClosed();
        NamedQueryDefinition namedQueryDefinition = this.factory.getNamedQuery(string);
        if (namedQueryDefinition != null) {
            String string2 = namedQueryDefinition.getQueryString();
            abstractQueryImpl = new QueryImpl(string2, namedQueryDefinition.getFlushMode(), this, this.getHQLQueryPlan(string2, false).getParameterMetadata());
            abstractQueryImpl.setComment("named HQL query " + string);
        } else {
            NamedSQLQueryDefinition namedSQLQueryDefinition = this.factory.getNamedSQLQuery(string);
            if (namedSQLQueryDefinition == null) {
                throw new MappingException("Named query not known: " + string);
            }
            abstractQueryImpl = new SQLQueryImpl(namedSQLQueryDefinition, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(namedSQLQueryDefinition.getQueryString()));
            abstractQueryImpl.setComment("named native SQL query " + string);
            namedQueryDefinition = namedSQLQueryDefinition;
        }
        this.initQuery(abstractQueryImpl, namedQueryDefinition);
        return abstractQueryImpl;
    }

    public Query getNamedSQLQuery(String string) throws MappingException {
        this.errorIfClosed();
        NamedSQLQueryDefinition namedSQLQueryDefinition = this.factory.getNamedSQLQuery(string);
        if (namedSQLQueryDefinition == null) {
            throw new MappingException("Named SQL query not known: " + string);
        }
        SQLQueryImpl sQLQueryImpl = new SQLQueryImpl(namedSQLQueryDefinition, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(namedSQLQueryDefinition.getQueryString()));
        sQLQueryImpl.setComment("named native SQL query " + string);
        this.initQuery(sQLQueryImpl, namedSQLQueryDefinition);
        return sQLQueryImpl;
    }

    private void initQuery(Query query, NamedQueryDefinition namedQueryDefinition) {
        query.setCacheable(namedQueryDefinition.isCacheable());
        query.setCacheRegion(namedQueryDefinition.getCacheRegion());
        if (namedQueryDefinition.getTimeout() != null) {
            query.setTimeout(namedQueryDefinition.getTimeout());
        }
        if (namedQueryDefinition.getFetchSize() != null) {
            query.setFetchSize(namedQueryDefinition.getFetchSize());
        }
        if (namedQueryDefinition.getCacheMode() != null) {
            query.setCacheMode(namedQueryDefinition.getCacheMode());
        }
        query.setReadOnly(namedQueryDefinition.isReadOnly());
        if (namedQueryDefinition.getComment() != null) {
            query.setComment(namedQueryDefinition.getComment());
        }
    }

    public Query createQuery(String string) {
        this.errorIfClosed();
        QueryImpl queryImpl = new QueryImpl(string, this, this.getHQLQueryPlan(string, false).getParameterMetadata());
        queryImpl.setComment(string);
        return queryImpl;
    }

    public SQLQuery createSQLQuery(String string) {
        this.errorIfClosed();
        SQLQueryImpl sQLQueryImpl = new SQLQueryImpl(string, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(string));
        sQLQueryImpl.setComment("dynamic native SQL query");
        return sQLQueryImpl;
    }

    protected HQLQueryPlan getHQLQueryPlan(String string, boolean bl) throws HibernateException {
        return this.factory.getQueryPlanCache().getHQLQueryPlan(string, bl, this.getEnabledFilters());
    }

    protected NativeSQLQueryPlan getNativeSQLQueryPlan(NativeSQLQuerySpecification nativeSQLQuerySpecification) throws HibernateException {
        return this.factory.getQueryPlanCache().getNativeSQLQueryPlan(nativeSQLQuerySpecification);
    }

    public List list(NativeSQLQuerySpecification nativeSQLQuerySpecification, QueryParameters queryParameters) throws HibernateException {
        return this.listCustomQuery(this.getNativeSQLQueryPlan(nativeSQLQuerySpecification).getCustomQuery(), queryParameters);
    }

    public ScrollableResults scroll(NativeSQLQuerySpecification nativeSQLQuerySpecification, QueryParameters queryParameters) throws HibernateException {
        return this.scrollCustomQuery(this.getNativeSQLQueryPlan(nativeSQLQuerySpecification).getCustomQuery(), queryParameters);
    }
}

