/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.loader.Loader;
import org.hibernate.type.Type;

public abstract class AbstractScrollableResults
implements ScrollableResults {
    private final ResultSet resultSet;
    private final PreparedStatement ps;
    private final SessionImplementor session;
    private final Loader loader;
    private final QueryParameters queryParameters;
    private final Type[] types;
    private HolderInstantiator holderInstantiator;

    public AbstractScrollableResults(ResultSet resultSet, PreparedStatement preparedStatement, SessionImplementor sessionImplementor, Loader loader, QueryParameters queryParameters, Type[] typeArray, HolderInstantiator holderInstantiator) throws MappingException {
        this.resultSet = resultSet;
        this.ps = preparedStatement;
        this.session = sessionImplementor;
        this.loader = loader;
        this.queryParameters = queryParameters;
        this.types = typeArray;
        this.holderInstantiator = holderInstantiator != null && holderInstantiator.isRequired() ? holderInstantiator : null;
    }

    protected abstract Object[] getCurrentRow();

    protected ResultSet getResultSet() {
        return this.resultSet;
    }

    protected PreparedStatement getPs() {
        return this.ps;
    }

    protected SessionImplementor getSession() {
        return this.session;
    }

    protected Loader getLoader() {
        return this.loader;
    }

    protected QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    protected Type[] getTypes() {
        return this.types;
    }

    protected HolderInstantiator getHolderInstantiator() {
        return this.holderInstantiator;
    }

    public final void close() throws HibernateException {
        try {
            this.session.getBatcher().closeQueryStatement(this.ps, this.resultSet);
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.session.getFactory().getSQLExceptionConverter(), sQLException, "could not close results");
        }
    }

    public final Object[] get() throws HibernateException {
        return this.getCurrentRow();
    }

    public final Object get(int n) throws HibernateException {
        return this.getCurrentRow()[n];
    }

    protected final Object getFinal(int n, Type type) throws HibernateException {
        if (this.holderInstantiator != null) {
            throw new HibernateException("query specifies a holder class");
        }
        if (type.getReturnedClass() == this.types[n].getReturnedClass()) {
            return this.get(n);
        }
        return this.throwInvalidColumnTypeException(n, this.types[n], type);
    }

    protected final Object getNonFinal(int n, Type type) throws HibernateException {
        if (this.holderInstantiator != null) {
            throw new HibernateException("query specifies a holder class");
        }
        if (type.getReturnedClass().isAssignableFrom(this.types[n].getReturnedClass())) {
            return this.get(n);
        }
        return this.throwInvalidColumnTypeException(n, this.types[n], type);
    }

    public final BigDecimal getBigDecimal(int n) throws HibernateException {
        return (BigDecimal)this.getFinal(n, Hibernate.BIG_DECIMAL);
    }

    public final BigInteger getBigInteger(int n) throws HibernateException {
        return (BigInteger)this.getFinal(n, Hibernate.BIG_INTEGER);
    }

    public final byte[] getBinary(int n) throws HibernateException {
        return (byte[])this.getFinal(n, Hibernate.BINARY);
    }

    public final String getText(int n) throws HibernateException {
        return (String)this.getFinal(n, Hibernate.TEXT);
    }

    public final Blob getBlob(int n) throws HibernateException {
        return (Blob)this.getNonFinal(n, Hibernate.BLOB);
    }

    public final Clob getClob(int n) throws HibernateException {
        return (Clob)this.getNonFinal(n, Hibernate.CLOB);
    }

    public final Boolean getBoolean(int n) throws HibernateException {
        return (Boolean)this.getFinal(n, Hibernate.BOOLEAN);
    }

    public final Byte getByte(int n) throws HibernateException {
        return (Byte)this.getFinal(n, Hibernate.BYTE);
    }

    public final Character getCharacter(int n) throws HibernateException {
        return (Character)this.getFinal(n, Hibernate.CHARACTER);
    }

    public final Date getDate(int n) throws HibernateException {
        return (Date)this.getNonFinal(n, Hibernate.TIMESTAMP);
    }

    public final Calendar getCalendar(int n) throws HibernateException {
        return (Calendar)this.getNonFinal(n, Hibernate.CALENDAR);
    }

    public final Double getDouble(int n) throws HibernateException {
        return (Double)this.getFinal(n, Hibernate.DOUBLE);
    }

    public final Float getFloat(int n) throws HibernateException {
        return (Float)this.getFinal(n, Hibernate.FLOAT);
    }

    public final Integer getInteger(int n) throws HibernateException {
        return (Integer)this.getFinal(n, Hibernate.INTEGER);
    }

    public final Long getLong(int n) throws HibernateException {
        return (Long)this.getFinal(n, Hibernate.LONG);
    }

    public final Short getShort(int n) throws HibernateException {
        return (Short)this.getFinal(n, Hibernate.SHORT);
    }

    public final String getString(int n) throws HibernateException {
        return (String)this.getFinal(n, Hibernate.STRING);
    }

    public final Locale getLocale(int n) throws HibernateException {
        return (Locale)this.getFinal(n, Hibernate.LOCALE);
    }

    public final TimeZone getTimeZone(int n) throws HibernateException {
        return (TimeZone)this.getNonFinal(n, Hibernate.TIMEZONE);
    }

    public final Type getType(int n) {
        return this.types[n];
    }

    private Object throwInvalidColumnTypeException(int n, Type type, Type type2) throws HibernateException {
        throw new HibernateException("incompatible column types: " + type.getName() + ", " + type2.getName());
    }

    protected void afterScrollOperation() {
        this.session.afterScrollOperation();
    }
}

