/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.pretty.MessageHelper;

public abstract class AbstractSelectingDelegate
implements InsertGeneratedIdentifierDelegate {
    private final PostInsertIdentityPersister persister;

    protected AbstractSelectingDelegate(PostInsertIdentityPersister postInsertIdentityPersister) {
        this.persister = postInsertIdentityPersister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public final Serializable performInsert(String string, SessionImplementor sessionImplementor, Binder binder) {
        Object object;
        try {
            object = sessionImplementor.getBatcher().prepareStatement(string, false);
            try {
                binder.bindValues((PreparedStatement)object);
                object.executeUpdate();
            }
            finally {
                sessionImplementor.getBatcher().closeStatement((PreparedStatement)object);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not insert: " + MessageHelper.infoString(this.persister), string);
        }
        object = this.getSelectSQL();
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareStatement((String)object);
            try {
                Serializable serializable;
                this.bindParameters(sessionImplementor, preparedStatement, binder.getEntity());
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    serializable = this.getResult(sessionImplementor, resultSet, binder.getEntity());
                }
                catch (Throwable throwable) {
                    resultSet.close();
                    throw throwable;
                }
                resultSet.close();
                return serializable;
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not retrieve generated id after insert: " + MessageHelper.infoString(this.persister), string);
        }
    }

    protected abstract String getSelectSQL();

    protected void bindParameters(SessionImplementor sessionImplementor, PreparedStatement preparedStatement, Object object) throws SQLException {
    }

    protected abstract Serializable getResult(SessionImplementor var1, ResultSet var2, Object var3) throws SQLException;
}

