/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;

public class TableStructure
extends TransactionHelper
implements DatabaseStructure {
    private static final Log log = LogFactory.getLog((Class)TableStructure.class);
    private static final Log SQL_LOG = LogFactory.getLog((String)"org.hibernate.SQL");
    private final String tableName;
    private final String valueColumnName;
    private final int initialValue;
    private final int incrementSize;
    private final String select;
    private final String update;
    private boolean applyIncrementSizeToSourceValues;
    private int accessCounter;

    public TableStructure(Dialect dialect, String string, String string2, int n, int n2) {
        this.tableName = string;
        this.initialValue = n;
        this.incrementSize = n2;
        this.valueColumnName = string2;
        this.select = "select " + string2 + " id_val" + " from " + dialect.appendLockHint(LockMode.UPGRADE, string) + dialect.getForUpdateString();
        this.update = "update " + string + " set " + string2 + "= ?" + " where " + string2 + "=?";
    }

    public String getName() {
        return this.tableName;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public int getTimesAccessed() {
        return this.accessCounter;
    }

    public void prepare(Optimizer optimizer) {
        this.applyIncrementSizeToSourceValues = optimizer.applyIncrementSizeToSourceValues();
    }

    public AccessCallback buildCallback(final SessionImplementor sessionImplementor) {
        return new AccessCallback(){

            public long getNextValue() {
                return ((Number)TableStructure.this.doWorkInNewTransaction(sessionImplementor)).longValue();
            }
        };
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{"create table " + this.tableName + " ( " + this.valueColumnName + " " + dialect.getTypeName(-5) + " )", "insert into " + this.tableName + " values ( " + this.initialValue + " )"};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        StringBuffer stringBuffer = new StringBuffer().append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            stringBuffer.append("if exists ");
        }
        stringBuffer.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            stringBuffer.append(" if exists");
        }
        return new String[]{stringBuffer.toString()};
    }

    protected Serializable doWorkInCurrentTransaction(Connection connection, String string) throws SQLException {
        long l;
        int n;
        do {
            AutoCloseable autoCloseable;
            string = this.select;
            SQL_LOG.debug((Object)string);
            PreparedStatement preparedStatement = connection.prepareStatement(this.select);
            try {
                autoCloseable = preparedStatement.executeQuery();
                if (!autoCloseable.next()) {
                    String string2 = "could not read a hi value - you need to populate the table: " + this.tableName;
                    log.error((Object)string2);
                    throw new IdentifierGenerationException(string2);
                }
                l = autoCloseable.getLong(1);
                autoCloseable.close();
            }
            catch (SQLException sQLException) {
                log.error((Object)"could not read a hi value", (Throwable)sQLException);
                throw sQLException;
            }
            finally {
                preparedStatement.close();
            }
            string = this.update;
            SQL_LOG.debug((Object)string);
            autoCloseable = connection.prepareStatement(this.update);
            try {
                int n2 = this.applyIncrementSizeToSourceValues ? this.incrementSize : 1;
                autoCloseable.setLong(1, l + (long)n2);
                autoCloseable.setLong(2, l);
                n = autoCloseable.executeUpdate();
            }
            catch (SQLException sQLException) {
                log.error((Object)("could not update hi value in: " + this.tableName), (Throwable)sQLException);
                throw sQLException;
            }
            finally {
                autoCloseable.close();
            }
        } while (n == 0);
        ++this.accessCounter;
        return new Long(l);
    }
}

