/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.StringHelper;

public class TableGenerator
extends TransactionHelper
implements PersistentIdentifierGenerator,
Configurable {
    private static final Log log = LogFactory.getLog((Class)TableGenerator.class);
    public static final String TABLE_PARAM = "table_name";
    public static final String DEF_TABLE = "hibernate_sequences";
    public static final String VALUE_COLUMN_PARAM = "value_column_name";
    public static final String DEF_VALUE_COLUMN = "next_val";
    public static final String SEGMENT_COLUMN_PARAM = "segment_column_name";
    public static final String DEF_SEGMENT_COLUMN = "sequence_name";
    public static final String SEGMENT_VALUE_PARAM = "segment_value";
    public static final String DEF_SEGMENT_VALUE = "default";
    public static final String SEGMENT_LENGTH_PARAM = "segment_value_length";
    public static final int DEF_SEGMENT_LENGTH = 255;
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    public static final String OPT_PARAM = "optimizer";
    private String tableName;
    private String valueColumnName;
    private String segmentColumnName;
    private String segmentValue;
    private int segmentValueLength;
    private int initialValue;
    private int incrementSize;
    private Type identifierType;
    private String query;
    private String insert;
    private String update;
    private Optimizer optimizer;
    private long accessCount = 0L;

    public String getTableName() {
        return this.tableName;
    }

    public String getSegmentColumnName() {
        return this.segmentColumnName;
    }

    public String getSegmentValue() {
        return this.segmentValue;
    }

    public int getSegmentValueLength() {
        return this.segmentValueLength;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public long getTableAccessCount() {
        return this.accessCount;
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        Object object;
        String string;
        this.tableName = PropertiesHelper.getString(TABLE_PARAM, properties, DEF_TABLE);
        if (this.tableName.indexOf(46) < 0) {
            string = properties.getProperty("schema");
            object = properties.getProperty("catalog");
            this.tableName = Table.qualify((String)object, string, this.tableName);
        }
        this.segmentColumnName = PropertiesHelper.getString(SEGMENT_COLUMN_PARAM, properties, DEF_SEGMENT_COLUMN);
        this.segmentValue = properties.getProperty(SEGMENT_VALUE_PARAM);
        if (StringHelper.isEmpty(this.segmentValue)) {
            log.debug((Object)("explicit segment value for id generator [" + this.tableName + '.' + this.segmentColumnName + "] suggested; using default [" + DEF_SEGMENT_VALUE + "]"));
            this.segmentValue = DEF_SEGMENT_VALUE;
        }
        this.segmentValueLength = PropertiesHelper.getInt(SEGMENT_LENGTH_PARAM, properties, 255);
        this.valueColumnName = PropertiesHelper.getString(VALUE_COLUMN_PARAM, properties, DEF_VALUE_COLUMN);
        this.initialValue = PropertiesHelper.getInt(INITIAL_PARAM, properties, 1);
        this.incrementSize = PropertiesHelper.getInt(INCREMENT_PARAM, properties, 1);
        this.identifierType = type;
        string = "select " + this.valueColumnName + " from " + this.tableName + " tbl" + " where tbl." + this.segmentColumnName + "=?";
        object = new HashMap();
        ((HashMap)object).put("tbl", LockMode.UPGRADE);
        this.query = dialect.applyLocksToSql(string, (Map)object, CollectionHelper.EMPTY_MAP);
        this.update = "update " + this.tableName + " set " + this.valueColumnName + "=? " + " where " + this.valueColumnName + "=? and " + this.segmentColumnName + "=?";
        this.insert = "insert into " + this.tableName + " (" + this.segmentColumnName + ", " + this.valueColumnName + ") " + " values (?,?)";
        String string2 = this.incrementSize <= 1 ? "none" : "pooled";
        String string3 = PropertiesHelper.getString(OPT_PARAM, properties, string2);
        this.optimizer = OptimizerFactory.buildOptimizer(string3, this.identifierType.getReturnedClass(), this.incrementSize);
    }

    public synchronized Serializable generate(final SessionImplementor sessionImplementor, Object object) {
        return this.optimizer.generate(new AccessCallback(){

            public long getNextValue() {
                return ((Number)TableGenerator.this.doWorkInNewTransaction(sessionImplementor)).longValue();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable doWorkInCurrentTransaction(Connection connection, String string) throws SQLException {
        int n;
        int n2;
        do {
            AutoCloseable autoCloseable;
            string = this.query;
            SQL.debug((Object)string);
            PreparedStatement preparedStatement = connection.prepareStatement(this.query);
            try {
                preparedStatement.setString(1, this.segmentValue);
                autoCloseable = preparedStatement.executeQuery();
                if (!autoCloseable.next()) {
                    Statement statement = null;
                    try {
                        n = this.initialValue;
                        string = this.insert;
                        SQL.debug((Object)string);
                        statement = connection.prepareStatement(this.insert);
                        statement.setString(1, this.segmentValue);
                        statement.setLong(2, n);
                        statement.execute();
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                } else {
                    n = autoCloseable.getInt(1);
                }
                autoCloseable.close();
            }
            catch (SQLException sQLException) {
                log.error((Object)"could not read or init a hi value", (Throwable)sQLException);
                throw sQLException;
            }
            finally {
                preparedStatement.close();
            }
            string = this.update;
            SQL.debug((Object)string);
            autoCloseable = connection.prepareStatement(this.update);
            try {
                long l = this.optimizer.applyIncrementSizeToSourceValues() ? (long)(n + this.incrementSize) : (long)(n + 1);
                autoCloseable.setLong(1, l);
                autoCloseable.setLong(2, n);
                autoCloseable.setString(3, this.segmentValue);
                n2 = autoCloseable.executeUpdate();
            }
            catch (SQLException sQLException) {
                log.error((Object)("could not update hi value in: " + this.tableName), (Throwable)sQLException);
                throw sQLException;
            }
            finally {
                autoCloseable.close();
            }
        } while (n2 == 0);
        ++this.accessCount;
        return new Integer(n);
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + ' ' + this.tableName + " ( " + this.segmentColumnName + ' ' + dialect.getTypeName(12, this.segmentValueLength, 0, 0) + ",  " + this.valueColumnName + ' ' + dialect.getTypeName(-5) + " ) "};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        StringBuffer stringBuffer = new StringBuffer().append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            stringBuffer.append("if exists ");
        }
        stringBuffer.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            stringBuffer.append(" if exists");
        }
        return new String[]{stringBuffer.toString()};
    }

    public Object generatorKey() {
        return this.tableName;
    }
}

