/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.id.enhanced.SequenceStructure;
import org.hibernate.id.enhanced.TableStructure;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;

public class SequenceStyleGenerator
implements PersistentIdentifierGenerator,
Configurable {
    private static final Log log = LogFactory.getLog((Class)SequenceStyleGenerator.class);
    public static final String SEQUENCE_PARAM = "sequence_name";
    public static final String DEF_SEQUENCE_NAME = "hibernate_sequence";
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    public static final String OPT_PARAM = "optimizer";
    public static final String FORCE_TBL_PARAM = "force_table_use";
    public static final String VALUE_COLUMN_PARAM = "value_column";
    public static final String DEF_VALUE_COLUMN = "next_val";
    private DatabaseStructure databaseStructure;
    private Optimizer optimizer;
    private Type identifierType;

    public DatabaseStructure getDatabaseStructure() {
        return this.databaseStructure;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        this.identifierType = type;
        boolean bl = PropertiesHelper.getBoolean(FORCE_TBL_PARAM, properties, false);
        String string = PropertiesHelper.getString(SEQUENCE_PARAM, properties, DEF_SEQUENCE_NAME);
        if (string.indexOf(46) < 0) {
            String string2 = properties.getProperty("schema");
            String string3 = properties.getProperty("catalog");
            string = Table.qualify(string3, string2, string);
        }
        int n = PropertiesHelper.getInt(INITIAL_PARAM, properties, 1);
        int n2 = PropertiesHelper.getInt(INCREMENT_PARAM, properties, 1);
        String string4 = PropertiesHelper.getString(VALUE_COLUMN_PARAM, properties, DEF_VALUE_COLUMN);
        String string5 = n2 <= 1 ? "none" : "pooled";
        String string6 = PropertiesHelper.getString(OPT_PARAM, properties, string5);
        if ("none".equals(string6) && n2 > 1) {
            log.warn((Object)("config specified explicit optimizer of [none], but [increment_size=" + n2 + "; honoring optimizer setting"));
            n2 = 1;
        }
        if (dialect.supportsSequences() && !bl) {
            if ("pooled".equals(string6) && !dialect.supportsPooledSequences()) {
                string6 = "hilo";
            }
            this.databaseStructure = new SequenceStructure(dialect, string, n, n2);
        } else {
            this.databaseStructure = new TableStructure(dialect, string, string4, n, n2);
        }
        this.optimizer = OptimizerFactory.buildOptimizer(string6, this.identifierType.getReturnedClass(), n2);
        this.databaseStructure.prepare(this.optimizer);
    }

    public Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        return this.optimizer.generate(this.databaseStructure.buildCallback(sessionImplementor));
    }

    public Object generatorKey() {
        return this.databaseStructure.getName();
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlCreateStrings(dialect);
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlDropStrings(dialect);
    }
}

