/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;

public class SequenceStructure
implements DatabaseStructure {
    private static final Log log = LogFactory.getLog((Class)SequenceStructure.class);
    private final String sequenceName;
    private final int initialValue;
    private final int incrementSize;
    private final String sql;
    private boolean applyIncrementSizeToSourceValues;
    private int accessCounter;

    public SequenceStructure(Dialect dialect, String string, int n, int n2) {
        this.sequenceName = string;
        this.initialValue = n;
        this.incrementSize = n2;
        this.sql = dialect.getSequenceNextValString(string);
    }

    public String getName() {
        return this.sequenceName;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public int getTimesAccessed() {
        return this.accessCounter;
    }

    public AccessCallback buildCallback(final SessionImplementor sessionImplementor) {
        return new AccessCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive exception aggregation
             */
            public long getNextValue() {
                SequenceStructure.this.accessCounter++;
                try {
                    PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(SequenceStructure.this.sql);
                    try {
                        long l;
                        ResultSet resultSet = preparedStatement.executeQuery();
                        try {
                            resultSet.next();
                            long l2 = resultSet.getLong(1);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Sequence identifier generated: " + l2));
                            }
                            l = l2;
                        }
                        catch (Throwable throwable) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return l;
                    }
                    finally {
                        sessionImplementor.getBatcher().closeStatement(preparedStatement);
                    }
                }
                catch (SQLException sQLException) {
                    throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not get next sequence value", SequenceStructure.this.sql);
                }
            }
        };
    }

    public void prepare(Optimizer optimizer) {
        this.applyIncrementSizeToSourceValues = optimizer.applyIncrementSizeToSourceValues();
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        int n = this.applyIncrementSizeToSourceValues ? this.incrementSize : 1;
        return dialect.getCreateSequenceStrings(this.sequenceName, this.initialValue, n);
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceStrings(this.sequenceName);
    }
}

