/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.util.ReflectHelper;

public class OptimizerFactory {
    private static final Log log = LogFactory.getLog((Class)OptimizerFactory.class);
    public static final String NONE = "none";
    public static final String HILO = "hilo";
    public static final String POOL = "pooled";
    private static Class[] CTOR_SIG = new Class[]{Class.class, Integer.TYPE};

    public static Optimizer buildOptimizer(String string, Class clazz, int n) {
        String string2 = NONE.equals(string) ? NoopOptimizer.class.getName() : (HILO.equals(string) ? HiLoOptimizer.class.getName() : (POOL.equals(string) ? PooledOptimizer.class.getName() : string));
        try {
            Class clazz2 = ReflectHelper.classForName(string2);
            Constructor constructor = clazz2.getConstructor(CTOR_SIG);
            return (Optimizer)constructor.newInstance(clazz, new Integer(n));
        }
        catch (Throwable throwable) {
            return new NoopOptimizer(clazz, n);
        }
    }

    public static class HiLoOptimizer
    extends OptimizerSupport {
        private long lastSourceValue = -1L;
        private long value;
        private long hiValue;

        public HiLoOptimizer(Class clazz, int n) {
            super(clazz, n);
            if (n < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("creating hilo optimizer with [incrementSize=" + n + "; returnClass=" + clazz.getName() + "]"));
            }
        }

        public Serializable generate(AccessCallback accessCallback) {
            if (this.lastSourceValue < 0L) {
                this.lastSourceValue = accessCallback.getNextValue();
                while (this.lastSourceValue <= 0L) {
                    this.lastSourceValue = accessCallback.getNextValue();
                }
                this.hiValue = this.lastSourceValue * (long)this.incrementSize + 1L;
                this.value = this.hiValue - (long)this.incrementSize;
            } else if (this.value >= this.hiValue) {
                this.lastSourceValue = accessCallback.getNextValue();
                this.hiValue = this.lastSourceValue * (long)this.incrementSize + 1L;
            }
            return this.make(this.value++);
        }

        public long getLastSourceValue() {
            return this.lastSourceValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }

        public long getLastValue() {
            return this.value - 1L;
        }

        public long getHiValue() {
            return this.hiValue;
        }
    }

    public static class NoopOptimizer
    extends OptimizerSupport {
        private long lastSourceValue = -1L;

        public NoopOptimizer(Class clazz, int n) {
            super(clazz, n);
        }

        public Serializable generate(AccessCallback accessCallback) {
            if (this.lastSourceValue == -1L) {
                while (this.lastSourceValue <= 0L) {
                    this.lastSourceValue = accessCallback.getNextValue();
                }
            } else {
                this.lastSourceValue = accessCallback.getNextValue();
            }
            return this.make(this.lastSourceValue);
        }

        public long getLastSourceValue() {
            return this.lastSourceValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }
    }

    public static abstract class OptimizerSupport
    implements Optimizer {
        protected final Class returnClass;
        protected final int incrementSize;

        protected OptimizerSupport(Class clazz, int n) {
            if (clazz == null) {
                throw new HibernateException("return class is required");
            }
            this.returnClass = clazz;
            this.incrementSize = n;
        }

        protected Serializable make(long l) {
            return IdentifierGeneratorFactory.createNumber(l, this.returnClass);
        }

        public Class getReturnClass() {
            return this.returnClass;
        }

        public int getIncrementSize() {
            return this.incrementSize;
        }
    }

    public static class PooledOptimizer
    extends OptimizerSupport {
        private long value;
        private long hiValue = -1L;

        public PooledOptimizer(Class clazz, int n) {
            super(clazz, n);
            if (n < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("creating pooled optimizer with [incrementSize=" + n + "; returnClass=" + clazz.getName() + "]"));
            }
        }

        public Serializable generate(AccessCallback accessCallback) {
            if (this.hiValue < 0L) {
                this.value = accessCallback.getNextValue();
                if (this.value < 1L) {
                    log.info((Object)("pooled optimizer source reported [" + this.value + "] as the initial value; use of 1 or greater highly recommended"));
                }
                this.hiValue = accessCallback.getNextValue();
            } else if (this.value >= this.hiValue) {
                this.hiValue = accessCallback.getNextValue();
                this.value = this.hiValue - (long)this.incrementSize;
            }
            return this.make(this.value++);
        }

        public long getLastSourceValue() {
            return this.hiValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return true;
        }

        public long getLastValue() {
            return this.value - 1L;
        }
    }
}

