/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.Hibernate;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.AbstractUUIDGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;

public class UUIDHexGenerator
extends AbstractUUIDGenerator
implements Configurable {
    private String sep = "";

    protected String format(int n) {
        String string = Integer.toHexString(n);
        StringBuffer stringBuffer = new StringBuffer("00000000");
        stringBuffer.replace(8 - string.length(), 8, string);
        return stringBuffer.toString();
    }

    protected String format(short s) {
        String string = Integer.toHexString(s);
        StringBuffer stringBuffer = new StringBuffer("0000");
        stringBuffer.replace(4 - string.length(), 4, string);
        return stringBuffer.toString();
    }

    public Serializable generate(SessionImplementor sessionImplementor, Object object) {
        return new StringBuffer(36).append(this.format(this.getIP())).append(this.sep).append(this.format(this.getJVM())).append(this.sep).append(this.format(this.getHiTime())).append(this.sep).append(this.format(this.getLoTime())).append(this.sep).append(this.format(this.getCount())).toString();
    }

    public void configure(Type type, Properties properties, Dialect dialect) {
        this.sep = PropertiesHelper.getString("separator", properties, "");
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("separator", "/");
        UUIDHexGenerator uUIDHexGenerator = new UUIDHexGenerator();
        ((Configurable)uUIDHexGenerator).configure(Hibernate.STRING, properties, null);
        UUIDHexGenerator uUIDHexGenerator2 = new UUIDHexGenerator();
        ((Configurable)uUIDHexGenerator2).configure(Hibernate.STRING, properties, null);
        for (int i = 0; i < 10; ++i) {
            String string = (String)((Object)uUIDHexGenerator.generate(null, null));
            System.out.println(string);
            String string2 = (String)((Object)uUIDHexGenerator2.generate(null, null));
            System.out.println(string2);
        }
    }
}

