/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.TableGenerator;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;

public class TableHiLoGenerator
extends TableGenerator {
    public static final String MAX_LO = "max_lo";
    private long hi;
    private int lo;
    private int maxLo;
    private Class returnClass;
    private static final Log log = LogFactory.getLog((Class)TableHiLoGenerator.class);

    public void configure(Type type, Properties properties, Dialect dialect) {
        super.configure(type, properties, dialect);
        this.maxLo = PropertiesHelper.getInt(MAX_LO, properties, Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }

    public synchronized Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        if (this.maxLo < 1) {
            long l = ((Number)super.generate(sessionImplementor, object)).longValue();
            if (l == 0L) {
                l = ((Number)super.generate(sessionImplementor, object)).longValue();
            }
            return IdentifierGeneratorFactory.createNumber(l, this.returnClass);
        }
        if (this.lo > this.maxLo) {
            long l = ((Number)super.generate(sessionImplementor, object)).longValue();
            this.lo = l == 0L ? 1 : 0;
            this.hi = l * (long)(this.maxLo + 1);
            log.debug((Object)("new hi value: " + l));
        }
        return IdentifierGeneratorFactory.createNumber(this.hi + (long)this.lo++, this.returnClass);
    }
}

