/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;

public class TableGenerator
extends TransactionHelper
implements PersistentIdentifierGenerator,
Configurable {
    public static final String COLUMN = "column";
    public static final String DEFAULT_COLUMN_NAME = "next_hi";
    public static final String TABLE = "table";
    public static final String DEFAULT_TABLE_NAME = "hibernate_unique_key";
    private static final Log log = LogFactory.getLog((Class)TableGenerator.class);
    private String tableName;
    private String columnName;
    private String query;
    private String update;

    public void configure(Type type, Properties properties, Dialect dialect) {
        this.tableName = PropertiesHelper.getString(TABLE, properties, DEFAULT_TABLE_NAME);
        this.columnName = PropertiesHelper.getString(COLUMN, properties, DEFAULT_COLUMN_NAME);
        String string = properties.getProperty("schema");
        String string2 = properties.getProperty("catalog");
        if (this.tableName.indexOf(46) < 0) {
            this.tableName = Table.qualify(string2, string, this.tableName);
        }
        this.query = "select " + this.columnName + " from " + dialect.appendLockHint(LockMode.UPGRADE, this.tableName) + dialect.getForUpdateString();
        this.update = "update " + this.tableName + " set " + this.columnName + " = ? where " + this.columnName + " = ?";
    }

    public synchronized Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        int n = (Integer)this.doWorkInNewTransaction(sessionImplementor);
        return new Integer(n);
    }

    public String[] sqlCreateStrings(Dialect dialect) {
        return new String[]{dialect.getCreateTableString() + " " + this.tableName + " ( " + this.columnName + " " + dialect.getTypeName(4) + " )", "insert into " + this.tableName + " values ( 0 )"};
    }

    public String[] sqlDropStrings(Dialect dialect) {
        StringBuffer stringBuffer = new StringBuffer("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            stringBuffer.append("if exists ");
        }
        stringBuffer.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            stringBuffer.append(" if exists");
        }
        return new String[]{stringBuffer.toString()};
    }

    public Object generatorKey() {
        return this.tableName;
    }

    public Serializable doWorkInCurrentTransaction(Connection connection, String string) throws SQLException {
        int n;
        int n2;
        do {
            AutoCloseable autoCloseable;
            string = this.query;
            SQL.debug((Object)this.query);
            PreparedStatement preparedStatement = connection.prepareStatement(this.query);
            try {
                autoCloseable = preparedStatement.executeQuery();
                if (!autoCloseable.next()) {
                    String string2 = "could not read a hi value - you need to populate the table: " + this.tableName;
                    log.error((Object)string2);
                    throw new IdentifierGenerationException(string2);
                }
                n = autoCloseable.getInt(1);
                autoCloseable.close();
            }
            catch (SQLException sQLException) {
                log.error((Object)"could not read a hi value", (Throwable)sQLException);
                throw sQLException;
            }
            finally {
                preparedStatement.close();
            }
            string = this.update;
            SQL.debug((Object)this.update);
            autoCloseable = connection.prepareStatement(this.update);
            try {
                autoCloseable.setInt(1, n + 1);
                autoCloseable.setInt(2, n);
                n2 = autoCloseable.executeUpdate();
            }
            catch (SQLException sQLException) {
                log.error((Object)("could not update hi value in: " + this.tableName), (Throwable)sQLException);
                throw sQLException;
            }
            finally {
                autoCloseable.close();
            }
        } while (n2 == 0);
        return new Integer(n);
    }
}

