/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;

public class SequenceGenerator
implements PersistentIdentifierGenerator,
Configurable {
    public static final String SEQUENCE = "sequence";
    public static final String PARAMETERS = "parameters";
    private String sequenceName;
    private String parameters;
    private Type identifierType;
    private String sql;
    private static final Log log = LogFactory.getLog((Class)SequenceGenerator.class);

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        this.sequenceName = PropertiesHelper.getString(SEQUENCE, properties, "hibernate_sequence");
        this.parameters = properties.getProperty(PARAMETERS);
        String string = properties.getProperty("schema");
        String string2 = properties.getProperty("catalog");
        if (this.sequenceName.indexOf(46) < 0) {
            this.sequenceName = Table.qualify(string2, string, this.sequenceName);
        }
        this.identifierType = type;
        this.sql = dialect.getSequenceNextValString(this.sequenceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(this.sql);
            try {
                Serializable serializable;
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    resultSet.next();
                    Serializable serializable2 = IdentifierGeneratorFactory.get(resultSet, this.identifierType);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Sequence identifier generated: " + serializable2));
                    }
                    serializable = serializable2;
                }
                catch (Throwable throwable) {
                    resultSet.close();
                    throw throwable;
                }
                resultSet.close();
                return serializable;
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not get next sequence value", this.sql);
        }
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        String[] stringArray = dialect.getCreateSequenceStrings(this.sequenceName);
        if (this.parameters != null) {
            int n = stringArray.length - 1;
            stringArray[n] = stringArray[n] + ' ' + this.parameters;
        }
        return stringArray;
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceStrings(this.sequenceName);
    }

    public Object generatorKey() {
        return this.sequenceName;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }
}

