/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;

public class MultipleHiLoPerTableGenerator
extends TransactionHelper
implements PersistentIdentifierGenerator,
Configurable {
    private static final Log log = LogFactory.getLog((Class)MultipleHiLoPerTableGenerator.class);
    public static final String ID_TABLE = "table";
    public static final String PK_COLUMN_NAME = "primary_key_column";
    public static final String PK_VALUE_NAME = "primary_key_value";
    public static final String VALUE_COLUMN_NAME = "value_column";
    public static final String PK_LENGTH_NAME = "primary_key_length";
    private static final int DEFAULT_PK_LENGTH = 255;
    public static final String DEFAULT_TABLE = "hibernate_sequences";
    private static final String DEFAULT_PK_COLUMN = "sequence_name";
    private static final String DEFAULT_VALUE_COLUMN = "sequence_next_hi_value";
    private String tableName;
    private String pkColumnName;
    private String valueColumnName;
    private String query;
    private String insert;
    private String update;
    public static final String MAX_LO = "max_lo";
    private long hi;
    private int lo;
    private int maxLo;
    private Class returnClass;
    private int keySize;

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + ' ' + this.tableName + " ( " + this.pkColumnName + ' ' + dialect.getTypeName(12, this.keySize, 0, 0) + ",  " + this.valueColumnName + ' ' + dialect.getTypeName(4) + " ) "};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        StringBuffer stringBuffer = new StringBuffer("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            stringBuffer.append("if exists ");
        }
        stringBuffer.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            stringBuffer.append(" if exists");
        }
        return new String[]{stringBuffer.toString()};
    }

    public Object generatorKey() {
        return this.tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable doWorkInCurrentTransaction(Connection connection, String string) throws SQLException {
        int n;
        int n2;
        do {
            AutoCloseable autoCloseable;
            PreparedStatement preparedStatement;
            block13: {
                Object var10_11;
                SQL.debug((Object)this.query);
                preparedStatement = connection.prepareStatement(this.query);
                Statement statement = null;
                try {
                    try {
                        autoCloseable = preparedStatement.executeQuery();
                        boolean bl = autoCloseable.next();
                        if (!bl) {
                            n = 0;
                            statement = connection.prepareStatement(this.insert);
                            statement.setInt(1, n);
                            statement.execute();
                        } else {
                            n = autoCloseable.getInt(1);
                        }
                        autoCloseable.close();
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)"could not read or init a hi value", (Throwable)sQLException);
                        throw sQLException;
                    }
                    var10_11 = null;
                    if (statement == null) break block13;
                }
                catch (Throwable throwable) {
                    var10_11 = null;
                    if (statement != null) {
                        statement.close();
                    }
                    preparedStatement.close();
                    throw throwable;
                }
                statement.close();
            }
            preparedStatement.close();
            autoCloseable = connection.prepareStatement(this.update);
            try {
                autoCloseable.setInt(1, n + 1);
                autoCloseable.setInt(2, n);
                n2 = autoCloseable.executeUpdate();
            }
            catch (SQLException sQLException) {
                log.error((Object)("could not update hi value in: " + this.tableName), (Throwable)sQLException);
                throw sQLException;
            }
            finally {
                autoCloseable.close();
            }
        } while (n2 == 0);
        return new Integer(n);
    }

    public synchronized Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        if (this.maxLo < 1) {
            int n = (Integer)this.doWorkInNewTransaction(sessionImplementor);
            if (n == 0) {
                n = (Integer)this.doWorkInNewTransaction(sessionImplementor);
            }
            return IdentifierGeneratorFactory.createNumber(n, this.returnClass);
        }
        if (this.lo > this.maxLo) {
            int n = (Integer)this.doWorkInNewTransaction(sessionImplementor);
            this.lo = n == 0 ? 1 : 0;
            this.hi = n * (this.maxLo + 1);
            log.debug((Object)("new hi value: " + n));
        }
        return IdentifierGeneratorFactory.createNumber(this.hi + (long)this.lo++, this.returnClass);
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        this.tableName = PropertiesHelper.getString(ID_TABLE, properties, DEFAULT_TABLE);
        this.pkColumnName = PropertiesHelper.getString(PK_COLUMN_NAME, properties, DEFAULT_PK_COLUMN);
        this.valueColumnName = PropertiesHelper.getString(VALUE_COLUMN_NAME, properties, DEFAULT_VALUE_COLUMN);
        String string = properties.getProperty("schema");
        String string2 = properties.getProperty("catalog");
        this.keySize = PropertiesHelper.getInt(PK_LENGTH_NAME, properties, 255);
        String string3 = PropertiesHelper.getString(PK_VALUE_NAME, properties, properties.getProperty("target_table"));
        if (this.tableName.indexOf(46) < 0) {
            this.tableName = Table.qualify(string2, string, this.tableName);
        }
        this.query = "select " + this.valueColumnName + " from " + dialect.appendLockHint(LockMode.UPGRADE, this.tableName) + " where " + this.pkColumnName + " = '" + string3 + "'" + dialect.getForUpdateString();
        this.update = "update " + this.tableName + " set " + this.valueColumnName + " = ? where " + this.valueColumnName + " = ? and " + this.pkColumnName + " = '" + string3 + "'";
        this.insert = "insert into " + this.tableName + "(" + this.pkColumnName + ", " + this.valueColumnName + ") " + "values('" + string3 + "', ?)";
        this.maxLo = PropertiesHelper.getInt(MAX_LO, properties, Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }
}

