/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class IncrementGenerator
implements IdentifierGenerator,
Configurable {
    private static final Log log = LogFactory.getLog((Class)IncrementGenerator.class);
    private long next;
    private String sql;
    private Class returnClass;

    public synchronized Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        if (this.sql != null) {
            this.getNext(sessionImplementor);
        }
        return IdentifierGeneratorFactory.createNumber(this.next++, this.returnClass);
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        String string = properties.getProperty("tables");
        if (string == null) {
            string = properties.getProperty("identity_tables");
        }
        String[] stringArray = StringHelper.split(", ", string);
        String string2 = properties.getProperty("column");
        if (string2 == null) {
            string2 = properties.getProperty("target_column");
        }
        String string3 = properties.getProperty("schema");
        String string4 = properties.getProperty("catalog");
        this.returnClass = type.getReturnedClass();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray.length > 1) {
                stringBuffer.append("select ").append(string2).append(" from ");
            }
            stringBuffer.append(Table.qualify(string4, string3, stringArray[i]));
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(" union ");
        }
        if (stringArray.length > 1) {
            stringBuffer.insert(0, "( ").append(" ) ids_");
            string2 = "ids_." + string2;
        }
        this.sql = "select max(" + string2 + ") from " + stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNext(SessionImplementor sessionImplementor) {
        log.debug((Object)("fetching initial value: " + this.sql));
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(this.sql);
            try {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    if (resultSet.next()) {
                        this.next = resultSet.getLong(1) + 1L;
                        if (resultSet.wasNull()) {
                            this.next = 1L;
                        }
                    } else {
                        this.next = 1L;
                    }
                    this.sql = null;
                    log.debug((Object)("first free id: " + this.next));
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not fetch initial value for increment generator", this.sql);
        }
    }
}

