/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.id.Assigned;
import org.hibernate.id.Configurable;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.id.GUIDGenerator;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.IncrementGenerator;
import org.hibernate.id.SelectGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.id.SequenceHiLoGenerator;
import org.hibernate.id.SequenceIdentityGenerator;
import org.hibernate.id.TableHiLoGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;

public final class IdentifierGeneratorFactory {
    private static final Log log = LogFactory.getLog((Class)IdentifierGeneratorFactory.class);
    private static final HashMap GENERATORS = new HashMap();
    public static final Serializable SHORT_CIRCUIT_INDICATOR = new Serializable(){

        public String toString() {
            return "SHORT_CIRCUIT_INDICATOR";
        }
    };
    public static final Serializable POST_INSERT_INDICATOR = new Serializable(){

        public String toString() {
            return "POST_INSERT_INDICATOR";
        }
    };

    public static Serializable getGeneratedIdentity(ResultSet resultSet, Type type) throws SQLException, HibernateException, IdentifierGenerationException {
        if (!resultSet.next()) {
            throw new HibernateException("The database returned no natively generated identity value");
        }
        Serializable serializable = IdentifierGeneratorFactory.get(resultSet, type);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Natively generated identity: " + serializable));
        }
        return serializable;
    }

    public static Serializable get(ResultSet resultSet, Type type) throws SQLException, IdentifierGenerationException {
        Class clazz = type.getReturnedClass();
        if (clazz == Long.class) {
            return new Long(resultSet.getLong(1));
        }
        if (clazz == Integer.class) {
            return new Integer(resultSet.getInt(1));
        }
        if (clazz == Short.class) {
            return new Short(resultSet.getShort(1));
        }
        if (clazz == String.class) {
            return resultSet.getString(1);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short or string");
    }

    public static IdentifierGenerator create(String string, Type type, Properties properties, Dialect dialect) throws MappingException {
        try {
            Class clazz = IdentifierGeneratorFactory.getIdentifierGeneratorClass(string, dialect);
            IdentifierGenerator identifierGenerator = (IdentifierGenerator)clazz.newInstance();
            if (identifierGenerator instanceof Configurable) {
                ((Configurable)((Object)identifierGenerator)).configure(type, properties, dialect);
            }
            return identifierGenerator;
        }
        catch (Exception exception) {
            throw new MappingException("could not instantiate id generator", exception);
        }
    }

    public static Class getIdentifierGeneratorClass(String string, Dialect dialect) {
        Class clazz = (Class)GENERATORS.get(string);
        if ("native".equals(string)) {
            clazz = dialect.getNativeIdentifierGeneratorClass();
        }
        try {
            if (clazz == null) {
                clazz = ReflectHelper.classForName(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MappingException("could not interpret id generator strategy: " + string);
        }
        return clazz;
    }

    public static Number createNumber(long l, Class clazz) throws IdentifierGenerationException {
        if (clazz == Long.class) {
            return new Long(l);
        }
        if (clazz == Integer.class) {
            return new Integer((int)l);
        }
        if (clazz == Short.class) {
            return new Short((short)l);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short");
    }

    private IdentifierGeneratorFactory() {
    }

    static {
        GENERATORS.put("uuid", UUIDHexGenerator.class);
        GENERATORS.put("hilo", TableHiLoGenerator.class);
        GENERATORS.put("assigned", Assigned.class);
        GENERATORS.put("identity", IdentityGenerator.class);
        GENERATORS.put("select", SelectGenerator.class);
        GENERATORS.put("sequence", SequenceGenerator.class);
        GENERATORS.put("seqhilo", SequenceHiLoGenerator.class);
        GENERATORS.put("increment", IncrementGenerator.class);
        GENERATORS.put("foreign", ForeignGenerator.class);
        GENERATORS.put("guid", GUIDGenerator.class);
        GENERATORS.put("uuid.hex", UUIDHexGenerator.class);
        GENERATORS.put("sequence-identity", SequenceIdentityGenerator.class);
    }
}

