/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.IdentifierGenerator;

public class GUIDGenerator
implements IdentifierGenerator {
    private static final Log log = LogFactory.getLog((Class)GUIDGenerator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        String string;
        String string2 = sessionImplementor.getFactory().getDialect().getSelectGUIDString();
        PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(string2);
        try {
            String string3;
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                resultSet.next();
                string3 = resultSet.getString(1);
            }
            finally {
                resultSet.close();
            }
            log.debug((Object)("GUID identifier generated: " + string3));
            string = string3;
        }
        catch (Throwable throwable) {
            try {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not retrieve GUID", string2);
            }
        }
        sessionImplementor.getBatcher().closeStatement(preparedStatement);
        return string;
    }
}

