/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.TransientObjectException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class ForeignGenerator
implements IdentifierGenerator,
Configurable {
    private String propertyName;
    private String entityName;

    public Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        Serializable serializable;
        Session session = (Session)((Object)sessionImplementor);
        Object object2 = sessionImplementor.getFactory().getClassMetadata(this.entityName).getPropertyValue(object, this.propertyName, session.getEntityMode());
        if (object2 == null) {
            throw new IdentifierGenerationException("attempted to assign id from null one-to-one property: " + this.propertyName);
        }
        EntityType entityType = (EntityType)sessionImplementor.getFactory().getClassMetadata(this.entityName).getPropertyType(this.propertyName);
        try {
            serializable = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityType.getAssociatedEntityName(), object2, sessionImplementor);
        }
        catch (TransientObjectException transientObjectException) {
            serializable = session.save(entityType.getAssociatedEntityName(), object2);
        }
        if (session.contains(object)) {
            return IdentifierGeneratorFactory.SHORT_CIRCUIT_INDICATOR;
        }
        return serializable;
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        this.propertyName = properties.getProperty("property");
        this.entityName = properties.getProperty("entity_name");
        if (this.propertyName == null) {
            throw new MappingException("param named \"property\" is required for foreign id generation strategy");
        }
    }
}

