/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.ASTFactory;
import antlr.collections.AST;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.hql.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.tree.RestrictableStatement;
import org.hibernate.hql.ast.tree.SqlFragment;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.util.StringHelper;

public class SyntheticAndFactory
implements HqlSqlTokenTypes {
    private static final Log log = LogFactory.getLog((Class)SyntheticAndFactory.class);
    private ASTFactory astFactory;
    private AST thetaJoins;
    private AST filters;

    public SyntheticAndFactory(ASTFactory aSTFactory) {
        this.astFactory = aSTFactory;
    }

    public void addWhereFragment(JoinFragment joinFragment, String string, QueryNode queryNode, FromElement fromElement) {
        if (string == null) {
            return;
        }
        if (StringHelper.isEmpty(string = string.trim())) {
            return;
        }
        if (!fromElement.useWhereFragment() && !joinFragment.hasThetaJoins()) {
            return;
        }
        if (string.startsWith("and")) {
            string = string.substring(4);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using WHERE fragment [" + string + "]"));
        }
        SqlFragment sqlFragment = (SqlFragment)ASTUtil.create(this.astFactory, 136, string);
        sqlFragment.setJoinFragment(joinFragment);
        sqlFragment.setFromElement(fromElement);
        if (sqlFragment.getFromElement().isFilter() || sqlFragment.hasFilterCondition()) {
            if (this.filters == null) {
                AST aST = queryNode.getWhereClause();
                this.filters = this.astFactory.create(140, "{filter conditions}");
                ASTUtil.insertChild(aST, this.filters);
            }
            this.filters.addChild((AST)sqlFragment);
        } else {
            if (this.thetaJoins == null) {
                AST aST = queryNode.getWhereClause();
                this.thetaJoins = this.astFactory.create(139, "{theta joins}");
                if (this.filters == null) {
                    ASTUtil.insertChild(aST, this.thetaJoins);
                } else {
                    ASTUtil.insertSibling(this.thetaJoins, this.filters);
                }
            }
            this.thetaJoins.addChild((AST)sqlFragment);
        }
    }

    public void addDiscriminatorWhereFragment(RestrictableStatement restrictableStatement, Queryable queryable, Map map, String string) {
        String string2 = queryable.filterFragment(string, map).trim();
        if ("".equals(string2)) {
            return;
        }
        if (string2.startsWith("and")) {
            string2 = string2.substring(4);
        }
        string2 = StringHelper.replace(string2, queryable.generateFilterConditionAlias(string) + ".", "");
        AST aST = this.astFactory.create(136, string2);
        if (restrictableStatement.getWhereClause().getNumberOfChildren() == 0) {
            restrictableStatement.getWhereClause().setFirstChild(aST);
        } else {
            AST aST2 = this.astFactory.create(6, "{and}");
            AST aST3 = restrictableStatement.getWhereClause().getFirstChild();
            aST2.setFirstChild(aST);
            aST2.addChild(aST3);
            restrictableStatement.getWhereClause().setFirstChild(aST2);
        }
    }
}

