/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.SemanticException;
import antlr.collections.AST;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.JoinSequence;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.NameGenerator;
import org.hibernate.hql.ast.DetailedSemanticException;
import org.hibernate.hql.ast.QuerySyntaxException;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.persister.collection.CollectionPropertyMapping;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class SessionFactoryHelper {
    private SessionFactoryImplementor sfi;
    private Map collectionPropertyMappingByRole;

    public SessionFactoryHelper(SessionFactoryImplementor sessionFactoryImplementor) {
        this.sfi = sessionFactoryImplementor;
        this.collectionPropertyMappingByRole = new HashMap();
    }

    public SessionFactoryImplementor getFactory() {
        return this.sfi;
    }

    public boolean hasPhysicalDiscriminatorColumn(Queryable queryable) {
        String string;
        return queryable.getDiscriminatorType() != null && (string = queryable.getDiscriminatorColumnName()) != null && !"clazz_".equals(string);
    }

    public String getImportedClassName(String string) {
        return this.sfi.getImportedClassName(string);
    }

    public Queryable findQueryableUsingImports(String string) {
        return SessionFactoryHelper.findQueryableUsingImports(this.sfi, string);
    }

    public static Queryable findQueryableUsingImports(SessionFactoryImplementor sessionFactoryImplementor, String string) {
        String string2 = sessionFactoryImplementor.getImportedClassName(string);
        if (string2 == null) {
            return null;
        }
        try {
            return (Queryable)sessionFactoryImplementor.getEntityPersister(string2);
        }
        catch (MappingException mappingException) {
            return null;
        }
    }

    private EntityPersister findEntityPersisterByName(String string) throws MappingException {
        try {
            return this.sfi.getEntityPersister(string);
        }
        catch (MappingException mappingException) {
            String string2 = this.sfi.getImportedClassName(string);
            if (string2 == null) {
                return null;
            }
            return this.sfi.getEntityPersister(string2);
        }
    }

    public EntityPersister requireClassPersister(String string) throws SemanticException {
        EntityPersister entityPersister;
        try {
            entityPersister = this.findEntityPersisterByName(string);
            if (entityPersister == null) {
                throw new QuerySyntaxException(string + " is not mapped");
            }
        }
        catch (MappingException mappingException) {
            throw new DetailedSemanticException(mappingException.getMessage(), mappingException);
        }
        return entityPersister;
    }

    public QueryableCollection getCollectionPersister(String string) {
        try {
            return (QueryableCollection)this.sfi.getCollectionPersister(string);
        }
        catch (ClassCastException classCastException) {
            throw new QueryException("collection is not queryable: " + string);
        }
        catch (Exception exception) {
            throw new QueryException("collection not found: " + string);
        }
    }

    public QueryableCollection requireQueryableCollection(String string) throws QueryException {
        try {
            QueryableCollection queryableCollection = (QueryableCollection)this.sfi.getCollectionPersister(string);
            if (queryableCollection != null) {
                this.collectionPropertyMappingByRole.put(string, new CollectionPropertyMapping(queryableCollection));
            }
            return queryableCollection;
        }
        catch (ClassCastException classCastException) {
            throw new QueryException("collection role is not queryable: " + string);
        }
        catch (Exception exception) {
            throw new QueryException("collection role not found: " + string);
        }
    }

    private PropertyMapping getCollectionPropertyMapping(String string) {
        return (PropertyMapping)this.collectionPropertyMappingByRole.get(string);
    }

    public String[] getCollectionElementColumns(String string, String string2) {
        return this.getCollectionPropertyMapping(string).toColumns(string2, "elements");
    }

    public JoinSequence createJoinSequence() {
        return new JoinSequence(this.sfi);
    }

    public JoinSequence createJoinSequence(boolean bl, AssociationType associationType, String string, int n, String[] stringArray) {
        JoinSequence joinSequence = this.createJoinSequence();
        joinSequence.setUseThetaStyle(bl);
        joinSequence.addJoin(associationType, string, n, stringArray);
        return joinSequence;
    }

    public JoinSequence createCollectionJoinSequence(QueryableCollection queryableCollection, String string) {
        JoinSequence joinSequence = this.createJoinSequence();
        joinSequence.setRoot(queryableCollection, string);
        joinSequence.setUseThetaStyle(true);
        return joinSequence;
    }

    public String getIdentifierOrUniqueKeyPropertyName(EntityType entityType) {
        try {
            return entityType.getIdentifierOrUniqueKeyPropertyName(this.sfi);
        }
        catch (MappingException mappingException) {
            throw new QueryException(mappingException);
        }
    }

    public int getColumnSpan(Type type) {
        return type.getColumnSpan(this.sfi);
    }

    public String getAssociatedEntityName(CollectionType collectionType) {
        return collectionType.getAssociatedEntityName(this.sfi);
    }

    private Type getElementType(CollectionType collectionType) {
        return collectionType.getElementType(this.sfi);
    }

    public AssociationType getElementAssociationType(CollectionType collectionType) {
        return (AssociationType)this.getElementType(collectionType);
    }

    public SQLFunction findSQLFunction(String string) {
        return this.sfi.getSqlFunctionRegistry().findSQLFunction(string.toLowerCase());
    }

    private SQLFunction requireSQLFunction(String string) {
        SQLFunction sQLFunction = this.findSQLFunction(string);
        if (sQLFunction == null) {
            throw new QueryException("Unable to find SQL function: " + string);
        }
        return sQLFunction;
    }

    public Type findFunctionReturnType(String string, AST aST) {
        SQLFunction sQLFunction = this.requireSQLFunction(string);
        Type type = null;
        if (aST != null) {
            if ("cast".equals(string)) {
                type = TypeFactory.heuristicType(aST.getNextSibling().getText());
            } else if (aST instanceof SqlNode) {
                type = ((SqlNode)aST).getDataType();
            }
        }
        return sQLFunction.getReturnType(type, this.sfi);
    }

    public String[][] generateColumnNames(Type[] typeArray) {
        return NameGenerator.generateColumnNames(typeArray, this.sfi);
    }

    public boolean isStrictJPAQLComplianceEnabled() {
        return this.sfi.getSettings().isStrictJPAQLCompliance();
    }
}

