/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.ASTFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.antlr.SqlTokenTypes;
import org.hibernate.hql.ast.QueryTranslatorImpl;
import org.hibernate.hql.ast.tree.DotNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.util.SyntheticAndFactory;
import org.hibernate.sql.JoinFragment;
import org.hibernate.util.StringHelper;

public class JoinProcessor
implements SqlTokenTypes {
    private static final Log log = LogFactory.getLog((Class)JoinProcessor.class);
    private QueryTranslatorImpl queryTranslatorImpl;
    private SyntheticAndFactory andFactory;

    public JoinProcessor(ASTFactory aSTFactory, QueryTranslatorImpl queryTranslatorImpl) {
        this.andFactory = new SyntheticAndFactory(aSTFactory);
        this.queryTranslatorImpl = queryTranslatorImpl;
    }

    public static int toHibernateJoinType(int n) {
        switch (n) {
            case 132: {
                return 1;
            }
            case 28: {
                return 0;
            }
            case 133: {
                return 2;
            }
        }
        throw new AssertionFailure("undefined join type " + n);
    }

    public void processJoins(QueryNode queryNode, boolean bl) {
        Iterator iterator;
        ArrayList arrayList;
        final FromClause fromClause = queryNode.getFromClause();
        if (DotNode.useThetaStyleImplicitJoins) {
            arrayList = new ArrayList();
            iterator = fromClause.getFromElements().listIterator(fromClause.getFromElements().size());
            while (iterator.hasPrevious()) {
                arrayList.add(iterator.previous());
            }
        } else {
            arrayList = fromClause.getFromElements();
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            final FromElement fromElement = (FromElement)iterator.next();
            JoinSequence joinSequence = fromElement.getJoinSequence();
            joinSequence.setSelector(new JoinSequence.Selector(){

                public boolean includeSubclasses(String string) {
                    boolean bl = fromClause.containsTableAlias(string);
                    if (fromElement.isDereferencedBySubclassProperty()) {
                        log.trace((Object)("forcing inclusion of extra joins [alias=" + string + ", containsTableAlias=" + bl + "]"));
                        return true;
                    }
                    boolean bl2 = JoinProcessor.this.queryTranslatorImpl.isShallowQuery();
                    boolean bl3 = fromElement.isIncludeSubclasses();
                    boolean bl4 = fromClause.isSubQuery();
                    return bl3 && bl && !bl4 && !bl2;
                }
            });
            this.addJoinNodes(queryNode, joinSequence, fromElement, bl);
        }
    }

    private void addJoinNodes(QueryNode queryNode, JoinSequence joinSequence, FromElement fromElement, boolean bl) {
        JoinFragment joinFragment = joinSequence.toJoinFragment(bl ? Collections.EMPTY_MAP : this.queryTranslatorImpl.getEnabledFilters(), fromElement.useFromFragment() || fromElement.isDereferencedBySuperclassOrSubclassProperty(), fromElement.getWithClauseFragment(), fromElement.getWithClauseJoinAlias());
        String string = joinFragment.toFromFragmentString();
        String string2 = joinFragment.toWhereFragmentString();
        if (fromElement.getType() == 130 && (joinSequence.isThetaStyle() || StringHelper.isNotEmpty(string2))) {
            fromElement.setType(128);
            fromElement.getJoinSequence().setUseThetaStyle(true);
        }
        if (fromElement.useFromFragment()) {
            String string3 = this.processFromFragment(string, joinSequence);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using FROM fragment [" + string3 + "]"));
            }
            fromElement.setText(string3.trim());
        }
        this.andFactory.addWhereFragment(joinFragment, string2, queryNode, fromElement);
    }

    private String processFromFragment(String string, JoinSequence joinSequence) {
        String string2 = string.trim();
        if (string2.startsWith(", ")) {
            string2 = string2.substring(2);
        }
        return string2;
    }
}

