/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.collections.AST;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.hql.ast.tree.DisplayableNode;
import org.hibernate.util.StringHelper;

public class ASTPrinter {
    private Map tokenTypeNamesByTokenType;
    private Class tokenTypeConstants;
    private boolean showClassNames = true;

    public ASTPrinter(Class clazz) {
        this.tokenTypeConstants = clazz;
    }

    public boolean isShowClassNames() {
        return this.showClassNames;
    }

    public void setShowClassNames(boolean bl) {
        this.showClassNames = bl;
    }

    private void showAst(AST aST, PrintStream printStream) {
        this.showAst(aST, new PrintWriter(printStream));
    }

    public void showAst(AST aST, PrintWriter printWriter) {
        ArrayList arrayList = new ArrayList();
        this.showAst(arrayList, printWriter, aST);
        printWriter.flush();
    }

    public String showAsString(AST aST, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.println(string);
        this.showAst(aST, printStream);
        printStream.flush();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static String getConstantName(Class clazz, int n) {
        String string = null;
        if (clazz != null) {
            Field field;
            Field[] fieldArray = clazz.getFields();
            for (int i = 0; i < fieldArray.length && (string = ASTPrinter.getTokenTypeName(field = fieldArray[i], n, true)) == null; ++i) {
            }
        }
        if (string == null) {
            string = Integer.toString(n);
        }
        return string;
    }

    private static String getTokenTypeName(Field field, int n, boolean bl) {
        if (Modifier.isStatic(field.getModifiers())) {
            try {
                Integer n2;
                Object object = field.get(null);
                if (!bl) {
                    return field.getName();
                }
                if (object instanceof Integer && (n2 = (Integer)object) == n) {
                    return field.getName();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getTokenTypeName(int n) {
        if (this.tokenTypeConstants == null) {
            return Integer.toString(n);
        }
        if (this.tokenTypeNamesByTokenType == null) {
            Field[] fieldArray = this.tokenTypeConstants.getFields();
            this.tokenTypeNamesByTokenType = new HashMap();
            String string = null;
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                string = ASTPrinter.getTokenTypeName(field, n, false);
                if (string == null) continue;
                try {
                    this.tokenTypeNamesByTokenType.put(field.get(null), field.getName());
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return (String)this.tokenTypeNamesByTokenType.get(new Integer(n));
    }

    private void showAst(ArrayList arrayList, PrintWriter printWriter, AST aST) {
        AST aST2;
        if (aST == null) {
            printWriter.println("AST is null!");
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            aST2 = (AST)arrayList.get(i);
            if (aST2.getNextSibling() == null) {
                printWriter.print("   ");
                continue;
            }
            printWriter.print(" | ");
        }
        if (aST.getNextSibling() == null) {
            printWriter.print(" \\-");
        } else {
            printWriter.print(" +-");
        }
        this.showNode(printWriter, aST);
        ArrayList<AST> arrayList2 = new ArrayList<AST>(arrayList);
        arrayList2.add(aST);
        for (aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            this.showAst(arrayList2, printWriter, aST2);
        }
        arrayList2.clear();
    }

    private void showNode(PrintWriter printWriter, AST aST) {
        String string = this.nodeToString(aST, this.isShowClassNames());
        printWriter.println(string);
    }

    public String nodeToString(AST aST, boolean bl) {
        Object object;
        if (aST == null) {
            return "{null}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(this.getTokenTypeName(aST.getType())).append("] ");
        if (bl) {
            stringBuffer.append(StringHelper.unqualify(aST.getClass().getName())).append(": ");
        }
        stringBuffer.append("'");
        String string = aST.getText();
        ASTPrinter.appendEscapedMultibyteChars(string, stringBuffer);
        stringBuffer.append("'");
        if (aST instanceof DisplayableNode) {
            object = (DisplayableNode)aST;
            stringBuffer.append(" ").append(object.getDisplayText());
        }
        object = stringBuffer.toString();
        return object;
    }

    public static void appendEscapedMultibyteChars(String string, StringBuffer stringBuffer) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c > '\u0100') {
                stringBuffer.append("\\u");
                stringBuffer.append(Integer.toHexString(c));
                continue;
            }
            stringBuffer.append(c);
        }
    }

    public static String escapeMultibyteChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ASTPrinter.appendEscapedMultibyteChars(string, stringBuffer);
        return stringBuffer.toString();
    }
}

