/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.hql.antlr.SqlTokenTypes;
import org.hibernate.hql.ast.tree.ConstructorNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.SelectExpression;
import org.hibernate.hql.ast.tree.SelectExpressionImpl;
import org.hibernate.hql.ast.tree.SelectExpressionList;
import org.hibernate.hql.ast.util.ASTAppender;
import org.hibernate.hql.ast.util.ASTIterator;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.hibernate.type.Type;

public class SelectClause
extends SelectExpressionList {
    private boolean prepared = false;
    private boolean scalarSelect;
    private List fromElementsForLoad = new ArrayList();
    private Type[] queryReturnTypes;
    private String[][] columnNames;
    private ConstructorNode constructorNode;
    private List collectionFromElements;
    private String[] aliases;
    public static boolean VERSION2_SQL = false;

    public boolean isScalarSelect() {
        return this.scalarSelect;
    }

    public boolean isDistinct() {
        return this.getFirstChild() != null && this.getFirstChild().getType() == 16;
    }

    public List getFromElementsForLoad() {
        return this.fromElementsForLoad;
    }

    public Type[] getQueryReturnTypes() {
        return this.queryReturnTypes;
    }

    public String[] getQueryReturnAliases() {
        return this.aliases;
    }

    public String[][] getColumnNames() {
        return this.columnNames;
    }

    public Constructor getConstructor() {
        return this.constructorNode == null ? null : this.constructorNode.getConstructor();
    }

    public boolean isMap() {
        return this.constructorNode == null ? false : this.constructorNode.isMap();
    }

    public boolean isList() {
        return this.constructorNode == null ? false : this.constructorNode.isList();
    }

    public void initializeExplicitSelectClause(FromClause fromClause) throws SemanticException {
        Object object;
        if (this.prepared) {
            throw new IllegalStateException("SelectClause was already prepared!");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        SelectExpression[] selectExpressionArray = this.collectSelectExpressions();
        for (int i = 0; i < selectExpressionArray.length; ++i) {
            Object object2;
            object = selectExpressionArray[i];
            if (object.isConstructor()) {
                this.constructorNode = (ConstructorNode)object;
                object2 = this.constructorNode.getConstructorArgumentTypeList();
                arrayList.addAll((Collection<Object>)object2);
                this.scalarSelect = true;
                continue;
            }
            object2 = object.getDataType();
            if (object2 == null) {
                throw new IllegalStateException("No data type for node: " + object.getClass().getName() + " " + new ASTPrinter(SqlTokenTypes.class).showAsString((AST)object, ""));
            }
            if (object.isScalar()) {
                this.scalarSelect = true;
            }
            if (this.isReturnableEntity((SelectExpression)object)) {
                this.fromElementsForLoad.add(object.getFromElement());
            }
            arrayList.add(object2);
        }
        this.initAliases(selectExpressionArray);
        if (!this.getWalker().isShallowQuery()) {
            List list = fromClause.getProjectionList();
            object = new ASTAppender(this.getASTFactory(), (AST)this);
            int n = list.size();
            Iterator iterator = list.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                FromElement fromElement = (FromElement)iterator.next();
                if (fromElement.isFetch()) {
                    boolean bl;
                    FromElement fromElement2 = null;
                    if (fromElement.getRealOrigin() == null) {
                        if (fromElement.getOrigin() == null) {
                            throw new QueryException("Unable to determine origin of join fetch [" + fromElement.getDisplayText() + "]");
                        }
                        fromElement2 = fromElement.getOrigin();
                    } else {
                        fromElement2 = fromElement.getRealOrigin();
                    }
                    if (!this.fromElementsForLoad.contains(fromElement2)) {
                        throw new QueryException("query specified join fetching, but the owner of the fetched association was not present in the select list [" + fromElement.getDisplayText() + "]");
                    }
                    Type type = fromElement.getSelectType();
                    this.addCollectionFromElement(fromElement);
                    if (type != null && !(bl = fromElement.isCollectionOfValuesOrComponents())) {
                        fromElement.setIncludeSubclasses(true);
                        this.fromElementsForLoad.add(fromElement);
                        String string = fromElement.renderIdentifierSelect(n, n2);
                        SelectExpressionImpl selectExpressionImpl = (SelectExpressionImpl)((ASTAppender)object).append(138, string, false);
                        if (selectExpressionImpl != null) {
                            selectExpressionImpl.setFromElement(fromElement);
                        }
                    }
                }
                ++n2;
            }
            this.renderNonScalarSelects(this.collectSelectExpressions(), fromClause);
        }
        if (this.scalarSelect || this.getWalker().isShallowQuery()) {
            this.renderScalarSelects(selectExpressionArray, fromClause);
        }
        this.finishInitialization(arrayList);
    }

    private void finishInitialization(ArrayList arrayList) {
        this.queryReturnTypes = arrayList.toArray(new Type[arrayList.size()]);
        this.initializeColumnNames();
        this.prepared = true;
    }

    private void initializeColumnNames() {
        this.columnNames = this.getSessionFactoryHelper().generateColumnNames(this.queryReturnTypes);
    }

    public void initializeDerivedSelectClause(FromClause fromClause) throws SemanticException {
        if (this.prepared) {
            throw new IllegalStateException("SelectClause was already prepared!");
        }
        List list = fromClause.getProjectionList();
        ASTAppender aSTAppender = new ASTAppender(this.getASTFactory(), (AST)this);
        int n = list.size();
        ArrayList<Type> arrayList = new ArrayList<Type>(n);
        ArrayList<Type> arrayList2 = new ArrayList<Type>(n);
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            boolean bl;
            FromElement fromElement = (FromElement)iterator.next();
            Type type = fromElement.getSelectType();
            this.addCollectionFromElement(fromElement);
            if (type != null && !(bl = fromElement.isCollectionOfValuesOrComponents())) {
                if (!fromElement.isFetch()) {
                    arrayList2.add(type);
                }
                this.fromElementsForLoad.add(fromElement);
                arrayList.add(type);
                String string = fromElement.renderIdentifierSelect(n, n2);
                SelectExpressionImpl selectExpressionImpl = (SelectExpressionImpl)aSTAppender.append(138, string, false);
                if (selectExpressionImpl != null) {
                    selectExpressionImpl.setFromElement(fromElement);
                }
            }
            ++n2;
        }
        SelectExpression[] selectExpressionArray = this.collectSelectExpressions();
        if (this.getWalker().isShallowQuery()) {
            this.renderScalarSelects(selectExpressionArray, fromClause);
        } else {
            this.renderNonScalarSelects(selectExpressionArray, fromClause);
        }
        this.finishInitialization(arrayList2);
    }

    private void addCollectionFromElement(FromElement fromElement) {
        if (fromElement.isFetch() && (fromElement.isCollectionJoin() || fromElement.getQueryableCollection() != null)) {
            String string;
            if (this.collectionFromElements == null) {
                this.collectionFromElements = new ArrayList();
                string = VERSION2_SQL ? "__" : "0__";
            } else {
                string = Integer.toString(this.collectionFromElements.size()) + "__";
            }
            this.collectionFromElements.add(fromElement);
            fromElement.setCollectionSuffix(string);
        }
    }

    protected AST getFirstSelectExpression() {
        AST aST;
        for (aST = this.getFirstChild(); aST != null && (aST.getType() == 16 || aST.getType() == 4); aST = aST.getNextSibling()) {
        }
        return aST;
    }

    private boolean isReturnableEntity(SelectExpression selectExpression) throws SemanticException {
        boolean bl;
        FromElement fromElement = selectExpression.getFromElement();
        boolean bl2 = bl = fromElement != null && (fromElement.isFetch() || fromElement.isCollectionOfValuesOrComponents());
        if (bl) {
            return false;
        }
        return selectExpression.isReturnableEntity();
    }

    private void renderScalarSelects(SelectExpression[] selectExpressionArray, FromClause fromClause) throws SemanticException {
        if (!fromClause.isSubQuery()) {
            for (int i = 0; i < selectExpressionArray.length; ++i) {
                SelectExpression selectExpression = selectExpressionArray[i];
                selectExpression.setScalarColumnText(i);
            }
        }
    }

    private void initAliases(SelectExpression[] selectExpressionArray) {
        if (this.constructorNode == null) {
            this.aliases = new String[selectExpressionArray.length];
            for (int i = 0; i < selectExpressionArray.length; ++i) {
                String string = selectExpressionArray[i].getAlias();
                this.aliases[i] = string == null ? Integer.toString(i) : string;
            }
        } else {
            this.aliases = this.constructorNode.getAliases();
        }
    }

    private void renderNonScalarSelects(SelectExpression[] selectExpressionArray, FromClause fromClause) throws SemanticException {
        FromElement fromElement;
        int n;
        int n2;
        ASTAppender aSTAppender = new ASTAppender(this.getASTFactory(), (AST)this);
        int n3 = selectExpressionArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (selectExpressionArray[n2].isScalar()) continue;
            ++n4;
        }
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            SelectExpression selectExpression;
            if (selectExpressionArray[n].isScalar() || (fromElement = (selectExpression = selectExpressionArray[n]).getFromElement()) == null) continue;
            this.renderNonScalarIdentifiers(fromElement, n4, n2, selectExpression, aSTAppender);
            ++n2;
        }
        if (!fromClause.isSubQuery()) {
            n = 0;
            for (int i = 0; i < n3; ++i) {
                if (selectExpressionArray[i].isScalar() || (fromElement = selectExpressionArray[i].getFromElement()) == null) continue;
                this.renderNonScalarProperties(aSTAppender, fromElement, n4, n);
                ++n;
            }
        }
    }

    private void renderNonScalarIdentifiers(FromElement fromElement, int n, int n2, SelectExpression selectExpression, ASTAppender aSTAppender) {
        String string = fromElement.renderIdentifierSelect(n, n2);
        if (!fromElement.getFromClause().isSubQuery()) {
            if (!this.scalarSelect && !this.getWalker().isShallowQuery()) {
                selectExpression.setText(string);
            } else {
                aSTAppender.append(136, string, false);
            }
        }
    }

    private void renderNonScalarProperties(ASTAppender aSTAppender, FromElement fromElement, int n, int n2) {
        String string = fromElement.renderPropertySelect(n, n2);
        aSTAppender.append(136, string, false);
        if (fromElement.getQueryableCollection() != null && fromElement.isFetch()) {
            string = fromElement.renderCollectionSelectFragment(n, n2);
            aSTAppender.append(136, string, false);
        }
        ASTIterator aSTIterator = new ASTIterator((AST)fromElement);
        while (aSTIterator.hasNext()) {
            FromElement fromElement2 = (FromElement)aSTIterator.next();
            if (!fromElement2.isCollectionOfValuesOrComponents() || !fromElement2.isFetch()) continue;
            string = fromElement2.renderValueCollectionSelectFragment(n, n + n2);
            aSTAppender.append(136, string, false);
        }
    }

    public List getCollectionFromElements() {
        return this.collectionFromElements;
    }
}

