/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.ast.tree.DisplayableNode;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.HqlSqlWalkerNode;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;

public class ParameterNode
extends HqlSqlWalkerNode
implements DisplayableNode,
ExpectedTypeAwareNode {
    private ParameterSpecification parameterSpecification;

    public ParameterSpecification getHqlParameterSpecification() {
        return this.parameterSpecification;
    }

    public void setHqlParameterSpecification(ParameterSpecification parameterSpecification) {
        this.parameterSpecification = parameterSpecification;
    }

    public String getDisplayText() {
        return "{" + (this.parameterSpecification == null ? "???" : this.parameterSpecification.renderDisplayInfo()) + "}";
    }

    public void setExpectedType(Type type) {
        this.getHqlParameterSpecification().setExpectedType(type);
        this.setDataType(type);
    }

    public Type getExpectedType() {
        return this.getHqlParameterSpecification() == null ? null : this.getHqlParameterSpecification().getExpectedType();
    }

    public String getRenderText(SessionFactoryImplementor sessionFactoryImplementor) {
        int n = 0;
        if (this.getExpectedType() != null && (n = this.getExpectedType().getColumnSpan(sessionFactoryImplementor)) > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(?");
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", ?");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        return "?";
    }
}

