/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.util.StringHelper;

public class Node
extends CommonAST {
    private String filename;
    private int line;
    private int column;
    private int textLength;

    public Node() {
    }

    public Node(Token token) {
        super(token);
    }

    public String getRenderText(SessionFactoryImplementor sessionFactoryImplementor) {
        return this.getText();
    }

    public void initialize(Token token) {
        super.initialize(token);
        this.filename = token.getFilename();
        this.line = token.getLine();
        this.column = token.getColumn();
        String string = token.getText();
        this.textLength = StringHelper.isEmpty(string) ? 0 : string.length();
    }

    public void initialize(AST aST) {
        super.initialize(aST);
        if (aST instanceof Node) {
            Node node = (Node)aST;
            this.filename = node.filename;
            this.line = node.line;
            this.column = node.column;
            this.textLength = node.textLength;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getTextLength() {
        return this.textLength;
    }
}

