/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.hql.CollectionProperties;
import org.hibernate.hql.ast.tree.AbstractSelectExpression;
import org.hibernate.hql.ast.tree.DotNode;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.FromReferenceNode;
import org.hibernate.hql.ast.tree.SelectExpression;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.hql.ast.util.ColumnHelper;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.type.Type;

public class MethodNode
extends AbstractSelectExpression
implements SelectExpression {
    private static final Log log = LogFactory.getLog((Class)MethodNode.class);
    private String methodName;
    private FromElement fromElement;
    private String[] selectColumns;
    private SQLFunction function;
    private boolean inSelect;

    public void resolve(boolean bl) throws SemanticException {
        AST aST = this.getFirstChild();
        this.initializeMethodNode(aST, bl);
        AST aST2 = aST.getNextSibling();
        if (ASTUtil.hasExactlyOneChild(aST2) && this.isCollectionPropertyMethod()) {
            this.collectionProperty(aST2.getFirstChild(), aST);
        } else {
            this.dialectFunction(aST2);
        }
    }

    public SQLFunction getSQLFunction() {
        return this.function;
    }

    private void dialectFunction(AST aST) {
        this.function = this.getSessionFactoryHelper().findSQLFunction(this.methodName);
        if (this.function != null) {
            AST aST2 = aST != null ? aST.getFirstChild() : null;
            Type type = this.getSessionFactoryHelper().findFunctionReturnType(this.methodName, aST2);
            this.setDataType(type);
        }
    }

    public boolean isCollectionPropertyMethod() {
        return CollectionProperties.isAnyCollectionProperty(this.methodName);
    }

    public void initializeMethodNode(AST aST, boolean bl) {
        aST.setType(141);
        String string = aST.getText();
        this.methodName = string.toLowerCase();
        this.inSelect = bl;
    }

    private String getMethodName() {
        return this.methodName;
    }

    private void collectionProperty(AST aST, AST aST2) throws SemanticException {
        if (aST == null) {
            throw new SemanticException("Collection function " + aST2.getText() + " has no path!");
        }
        SqlNode sqlNode = (SqlNode)aST;
        Type type = sqlNode.getDataType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("collectionProperty() :  name=" + aST2 + " type=" + type));
        }
        this.resolveCollectionProperty((AST)sqlNode);
    }

    public boolean isScalar() throws SemanticException {
        return true;
    }

    public void resolveCollectionProperty(AST aST) throws SemanticException {
        String string = CollectionProperties.getNormalizedPropertyName(this.getMethodName());
        if (aST instanceof FromReferenceNode) {
            FromReferenceNode fromReferenceNode = (FromReferenceNode)aST;
            if ("elements".equals(string)) {
                this.handleElements(fromReferenceNode, string);
            } else {
                this.fromElement = fromReferenceNode.getFromElement();
                this.setDataType(this.fromElement.getPropertyType(string, string));
                this.selectColumns = this.fromElement.toColumns(this.fromElement.getTableAlias(), string, this.inSelect);
            }
            if (fromReferenceNode instanceof DotNode) {
                this.prepareAnyImplicitJoins((DotNode)fromReferenceNode);
            }
            if (!this.inSelect) {
                this.fromElement.setText("");
                this.fromElement.setUseWhereFragment(false);
            }
        } else {
            throw new SemanticException("Unexpected expression " + aST + " found for collection function " + string);
        }
        this.prepareSelectColumns(this.selectColumns);
        this.setText(this.selectColumns[0]);
        this.setType(136);
    }

    private void prepareAnyImplicitJoins(DotNode dotNode) throws SemanticException {
        if (dotNode.getLhs() instanceof DotNode) {
            DotNode dotNode2 = (DotNode)dotNode.getLhs();
            FromElement fromElement = dotNode2.getFromElement();
            if (fromElement != null && "".equals(fromElement.getText())) {
                String string = fromElement.getQueryable().getTableName() + " " + fromElement.getTableAlias();
                fromElement.setText(string);
            }
            this.prepareAnyImplicitJoins(dotNode2);
        }
    }

    private void handleElements(FromReferenceNode fromReferenceNode, String string) {
        FromElement fromElement = fromReferenceNode.getFromElement();
        QueryableCollection queryableCollection = fromElement.getQueryableCollection();
        String string2 = fromReferenceNode.getPath() + "[]." + string;
        log.debug((Object)("Creating elements for " + string2));
        this.fromElement = fromElement;
        if (!fromElement.isCollectionOfValuesOrComponents()) {
            this.getWalker().addQuerySpaces(queryableCollection.getElementPersister().getQuerySpaces());
        }
        this.setDataType(queryableCollection.getElementType());
        this.selectColumns = fromElement.toColumns(this.fromElement.getTableAlias(), string, this.inSelect);
    }

    public void setScalarColumnText(int n) throws SemanticException {
        if (this.selectColumns == null) {
            ColumnHelper.generateSingleScalarColumn(this, n);
        } else {
            ColumnHelper.generateScalarColumns(this, this.selectColumns, n);
        }
    }

    protected void prepareSelectColumns(String[] stringArray) {
    }

    public FromElement getFromElement() {
        return this.fromElement;
    }

    public String getDisplayText() {
        return "{method=" + this.getMethodName() + ",selectColumns=" + (this.selectColumns == null ? null : Arrays.asList(this.selectColumns)) + ",fromElement=" + this.fromElement.getTableAlias() + "}";
    }
}

