/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.FromElementFactory;
import org.hibernate.hql.ast.tree.FromReferenceNode;
import org.hibernate.hql.ast.util.SessionFactoryHelper;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class IndexNode
extends FromReferenceNode {
    private static final Log log = LogFactory.getLog((Class)IndexNode.class);

    public void setScalarColumnText(int n) throws SemanticException {
        throw new UnsupportedOperationException("An IndexNode cannot generate column text!");
    }

    public void prepareForDot(String string) throws SemanticException {
        FromElement fromElement = this.getFromElement();
        if (fromElement == null) {
            throw new IllegalStateException("No FROM element for index operator!");
        }
        QueryableCollection queryableCollection = fromElement.getQueryableCollection();
        if (queryableCollection != null && !queryableCollection.isOneToMany()) {
            FromReferenceNode fromReferenceNode = (FromReferenceNode)this.getFirstChild();
            String string2 = fromReferenceNode.getPath() + "[]." + string;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating join for many-to-many elements for " + string2));
            }
            FromElementFactory fromElementFactory = new FromElementFactory(fromElement.getFromClause(), fromElement, string2);
            FromElement fromElement2 = fromElementFactory.createElementJoin(queryableCollection);
            this.setFromElement(fromElement2);
        }
    }

    public void resolveIndex(AST aST) throws SemanticException {
        throw new UnsupportedOperationException();
    }

    public void resolve(boolean bl, boolean bl2, String string, AST aST) throws SemanticException {
        Object object;
        String string2;
        if (this.isResolved()) {
            return;
        }
        FromReferenceNode fromReferenceNode = (FromReferenceNode)this.getFirstChild();
        SessionFactoryHelper sessionFactoryHelper = this.getSessionFactoryHelper();
        fromReferenceNode.resolveIndex((AST)this);
        Type type = fromReferenceNode.getDataType();
        if (!type.isCollectionType()) {
            throw new SemanticException("The [] operator cannot be applied to type " + type.toString());
        }
        String string3 = ((CollectionType)type).getRole();
        QueryableCollection queryableCollection = sessionFactoryHelper.requireQueryableCollection(string3);
        if (!queryableCollection.hasIndex()) {
            throw new QueryException("unindexed fromElement before []: " + fromReferenceNode.getPath());
        }
        FromElement fromElement = fromReferenceNode.getFromElement();
        String string4 = fromElement.getTableAlias();
        FromClause fromClause = fromElement.getFromClause();
        FromElement fromElement2 = fromClause.findCollectionJoin(string2 = fromReferenceNode.getPath());
        if (fromElement2 == null) {
            object = new FromElementFactory(fromClause, fromElement, string2);
            fromElement2 = ((FromElementFactory)object).createCollectionElementsJoin(queryableCollection, string4);
            if (log.isDebugEnabled()) {
                log.debug((Object)("No FROM element found for the elements of collection join path " + string2 + ", created " + fromElement2));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("FROM element found for collection join path " + string2));
        }
        object = fromReferenceNode.getNextSibling();
        if (object == null) {
            throw new QueryException("No index value!");
        }
        this.setFromElement(fromElement);
        String string5 = string4;
        if (fromElement2.getCollectionTableAlias() != null) {
            string5 = fromElement2.getCollectionTableAlias();
        }
        JoinSequence joinSequence = fromElement.getJoinSequence();
        String[] stringArray = queryableCollection.getIndexColumnNames();
        if (stringArray.length != 1) {
            throw new QueryException("composite-index appears in []: " + fromReferenceNode.getPath());
        }
        SqlGenerator sqlGenerator = new SqlGenerator(this.getSessionFactoryHelper().getFactory());
        try {
            sqlGenerator.simpleExpr((AST)object);
        }
        catch (RecognitionException recognitionException) {
            throw new QueryException(recognitionException.getMessage(), recognitionException);
        }
        String string6 = sqlGenerator.getSQL();
        joinSequence.addCondition(string5 + '.' + stringArray[0] + " = " + string6);
        String[] stringArray2 = queryableCollection.getElementColumnNames(string4);
        this.setText(stringArray2[0]);
        this.setResolved();
    }
}

