/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.CollectionProperties;
import org.hibernate.hql.CollectionSubqueryFactory;
import org.hibernate.hql.NameGenerator;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.persister.collection.CollectionPropertyMapping;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;

class FromElementType {
    private static final Log log = LogFactory.getLog((Class)FromElementType.class);
    private FromElement fromElement;
    private EntityType entityType;
    private EntityPersister persister;
    private QueryableCollection queryableCollection;
    private CollectionPropertyMapping collectionPropertyMapping;
    private JoinSequence joinSequence;
    private String collectionSuffix;

    public FromElementType(FromElement fromElement, EntityPersister entityPersister, EntityType entityType) {
        this.fromElement = fromElement;
        this.persister = entityPersister;
        this.entityType = entityType;
        if (entityPersister != null) {
            fromElement.setText(((Queryable)entityPersister).getTableName() + " " + this.getTableAlias());
        }
    }

    private String getTableAlias() {
        return this.fromElement.getTableAlias();
    }

    private String getCollectionTableAlias() {
        return this.fromElement.getCollectionTableAlias();
    }

    public String getCollectionSuffix() {
        return this.collectionSuffix;
    }

    public void setCollectionSuffix(String string) {
        this.collectionSuffix = string;
    }

    public EntityPersister getEntityPersister() {
        return this.persister;
    }

    public Type getDataType() {
        if (this.persister == null) {
            if (this.queryableCollection == null) {
                return null;
            }
            return this.queryableCollection.getType();
        }
        return this.entityType;
    }

    public Type getSelectType() {
        if (this.entityType == null) {
            return null;
        }
        boolean bl = this.fromElement.getFromClause().getWalker().isShallowQuery();
        return TypeFactory.manyToOne(this.entityType.getAssociatedEntityName(), bl);
    }

    public Queryable getQueryable() {
        return this.persister instanceof Queryable ? (Queryable)this.persister : null;
    }

    String renderScalarIdentifierSelect(int n) {
        this.checkInitialized();
        String[] stringArray = this.getPropertyMapping("id").toColumns(this.getTableAlias(), "id");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string).append(" as ").append(NameGenerator.scalarName(n, i));
        }
        return stringBuffer.toString();
    }

    String renderIdentifierSelect(int n, int n2) {
        this.checkInitialized();
        if (this.fromElement.getFromClause().isSubQuery()) {
            String[] stringArray = this.persister != null ? ((Queryable)this.persister).getIdentifierColumnNames() : new String[]{};
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(this.fromElement.getTableAlias()).append('.').append(stringArray[i]);
                if (i == stringArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            return stringBuffer.toString();
        }
        if (this.persister == null) {
            throw new QueryException("not an entity");
        }
        String string = ((Queryable)this.persister).identifierSelectFragment(this.getTableAlias(), this.getSuffix(n, n2));
        return FromElementType.trimLeadingCommaAndSpaces(string);
    }

    private String getSuffix(int n, int n2) {
        return FromElementType.generateSuffix(n, n2);
    }

    private static String generateSuffix(int n, int n2) {
        String string = n == 1 ? "" : Integer.toString(n2) + '_';
        return string;
    }

    private void checkInitialized() {
        this.fromElement.checkInitialized();
    }

    String renderPropertySelect(int n, int n2, boolean bl) {
        this.checkInitialized();
        if (this.persister == null) {
            return "";
        }
        String string = ((Queryable)this.persister).propertySelectFragment(this.getTableAlias(), this.getSuffix(n, n2), bl);
        return FromElementType.trimLeadingCommaAndSpaces(string);
    }

    String renderCollectionSelectFragment(int n, int n2) {
        if (this.queryableCollection == null) {
            return "";
        }
        if (this.collectionSuffix == null) {
            this.collectionSuffix = FromElementType.generateSuffix(n, n2);
        }
        String string = this.queryableCollection.selectFragment(this.getCollectionTableAlias(), this.collectionSuffix);
        return FromElementType.trimLeadingCommaAndSpaces(string);
    }

    public String renderValueCollectionSelectFragment(int n, int n2) {
        if (this.queryableCollection == null) {
            return "";
        }
        if (this.collectionSuffix == null) {
            this.collectionSuffix = FromElementType.generateSuffix(n, n2);
        }
        String string = this.queryableCollection.selectFragment(this.getTableAlias(), this.collectionSuffix);
        return FromElementType.trimLeadingCommaAndSpaces(string);
    }

    private static String trimLeadingCommaAndSpaces(String string) {
        if (string.length() > 0 && string.charAt(0) == ',') {
            string = string.substring(1);
        }
        string = string.trim();
        return string.trim();
    }

    public void setJoinSequence(JoinSequence joinSequence) {
        this.joinSequence = joinSequence;
    }

    public JoinSequence getJoinSequence() {
        if (this.joinSequence != null) {
            return this.joinSequence;
        }
        if (this.persister instanceof Joinable) {
            Joinable joinable = (Joinable)((Object)this.persister);
            return this.fromElement.getSessionFactoryHelper().createJoinSequence().setRoot(joinable, this.getTableAlias());
        }
        return null;
    }

    public void setQueryableCollection(QueryableCollection queryableCollection) {
        if (this.queryableCollection != null) {
            throw new IllegalStateException("QueryableCollection is already defined for " + this + "!");
        }
        this.queryableCollection = queryableCollection;
        if (!queryableCollection.isOneToMany()) {
            this.fromElement.setText(queryableCollection.getTableName() + " " + this.getTableAlias());
        }
    }

    public QueryableCollection getQueryableCollection() {
        return this.queryableCollection;
    }

    public Type getPropertyType(String string, String string2) {
        this.checkInitialized();
        Type type = null;
        if (this.persister != null && string.equals(string2) && string.equals(this.persister.getIdentifierPropertyName())) {
            type = this.persister.getIdentifierType();
        } else {
            PropertyMapping propertyMapping = this.getPropertyMapping(string);
            type = propertyMapping.toType(string2);
        }
        if (type == null) {
            throw new MappingException("Property " + string + " does not exist in " + (this.queryableCollection == null ? "class" : "collection") + " " + (this.queryableCollection == null ? this.fromElement.getClassName() : this.queryableCollection.getRole()));
        }
        return type;
    }

    String[] toColumns(String string, String string2, boolean bl) {
        return this.toColumns(string, string2, bl, false);
    }

    String[] toColumns(String string, String string2, boolean bl, boolean bl2) {
        this.checkInitialized();
        PropertyMapping propertyMapping = this.getPropertyMapping(string2);
        if (!bl && this.queryableCollection != null && CollectionProperties.isCollectionProperty(string2)) {
            Map map = this.fromElement.getWalker().getEnabledFilters();
            String string3 = CollectionSubqueryFactory.createCollectionSubquery(this.joinSequence, map, propertyMapping.toColumns(string, string2));
            if (log.isDebugEnabled()) {
                log.debug((Object)("toColumns(" + string + "," + string2 + ") : subquery = " + string3));
            }
            return new String[]{"(" + string3 + ")"};
        }
        if (bl2) {
            return propertyMapping.toColumns(string, string2);
        }
        if (this.fromElement.getWalker().getStatementType() == 45) {
            return propertyMapping.toColumns(string, string2);
        }
        if (this.fromElement.getWalker().getCurrentClauseType() == 45) {
            return propertyMapping.toColumns(string, string2);
        }
        if (this.fromElement.getWalker().isSubQuery()) {
            if (this.isCorrelation()) {
                if (this.isMultiTable()) {
                    return propertyMapping.toColumns(string, string2);
                }
                return propertyMapping.toColumns(this.extractTableName(), string2);
            }
            return propertyMapping.toColumns(string, string2);
        }
        Object[] objectArray = propertyMapping.toColumns(string2);
        log.trace((Object)("Using non-qualified column reference [" + string2 + " -> (" + ArrayHelper.toString(objectArray) + ")]"));
        return objectArray;
    }

    private boolean isCorrelation() {
        FromClause fromClause = this.fromElement.getWalker().getFinalFromClause();
        return this.fromElement.getFromClause() != this.fromElement.getWalker().getCurrentFromClause() && this.fromElement.getFromClause() == fromClause;
    }

    private boolean isMultiTable() {
        return this.fromElement.getQueryable() != null && this.fromElement.getQueryable().isMultiTable();
    }

    private String extractTableName() {
        return this.fromElement.getQueryable().getTableName();
    }

    PropertyMapping getPropertyMapping(String string) {
        this.checkInitialized();
        if (this.queryableCollection == null) {
            return (PropertyMapping)((Object)this.persister);
        }
        if (CollectionProperties.isCollectionProperty(string)) {
            if (this.collectionPropertyMapping == null) {
                this.collectionPropertyMapping = new CollectionPropertyMapping(this.queryableCollection);
            }
            return this.collectionPropertyMapping;
        }
        if (this.queryableCollection.getElementType().isAnyType()) {
            return this.queryableCollection;
        }
        if (this.queryableCollection.getElementType().isComponentType() && string.equals("id")) {
            return (PropertyMapping)((Object)this.queryableCollection.getOwnerEntityPersister());
        }
        return this.queryableCollection;
    }

    public boolean isCollectionOfValuesOrComponents() {
        if (this.persister == null) {
            if (this.queryableCollection == null) {
                return false;
            }
            return !this.queryableCollection.getElementType().isEntityType();
        }
        return false;
    }

    public boolean isEntity() {
        return this.persister != null;
    }
}

