/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.collections.AST;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.CollectionProperties;
import org.hibernate.hql.ast.tree.DisplayableNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElementType;
import org.hibernate.hql.ast.tree.HqlSqlWalkerNode;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class FromElement
extends HqlSqlWalkerNode
implements DisplayableNode {
    private static final Log log = LogFactory.getLog((Class)FromElement.class);
    private String className;
    private String classAlias;
    private String tableAlias;
    private String collectionTableAlias;
    private FromClause fromClause;
    private boolean includeSubclasses = true;
    private boolean collectionJoin = false;
    private FromElement origin;
    private String[] columns;
    private String role;
    private boolean fetch;
    private boolean isAllPropertyFetch;
    private boolean filter = false;
    private int sequence = -1;
    private boolean useFromFragment = false;
    private boolean initialized = false;
    private FromElementType elementType;
    private boolean useWhereFragment = true;
    private List destinations = new LinkedList();
    private boolean manyToMany = false;
    private String withClauseFragment = null;
    private String withClauseJoinAlias;
    private boolean dereferencedBySuperclassProperty;
    private boolean dereferencedBySubclassProperty;

    public String getCollectionSuffix() {
        return this.elementType.getCollectionSuffix();
    }

    public void setCollectionSuffix(String string) {
        this.elementType.setCollectionSuffix(string);
    }

    public void initializeCollection(FromClause fromClause, String string, String string2) {
        this.doInitialize(fromClause, string2, null, string, null, null);
        this.initialized = true;
    }

    public void initializeEntity(FromClause fromClause, String string, EntityPersister entityPersister, EntityType entityType, String string2, String string3) {
        this.doInitialize(fromClause, string3, string, string2, entityPersister, entityType);
        this.sequence = fromClause.nextFromElementCounter();
        this.initialized = true;
    }

    private void doInitialize(FromClause fromClause, String string, String string2, String string3, EntityPersister entityPersister, EntityType entityType) {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized!!");
        }
        this.fromClause = fromClause;
        this.tableAlias = string;
        this.className = string2;
        this.classAlias = string3;
        this.elementType = new FromElementType(this, entityPersister, entityType);
        fromClause.registerFromElement(this);
        if (log.isDebugEnabled()) {
            log.debug((Object)(fromClause + " :  " + string2 + " (" + (string3 == null ? "no alias" : string3) + ") -> " + string));
        }
    }

    public EntityPersister getEntityPersister() {
        return this.elementType.getEntityPersister();
    }

    public Type getDataType() {
        return this.elementType.getDataType();
    }

    public Type getSelectType() {
        return this.elementType.getSelectType();
    }

    public Queryable getQueryable() {
        return this.elementType.getQueryable();
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassAlias() {
        return this.classAlias;
    }

    private String getTableName() {
        Queryable queryable = this.getQueryable();
        return queryable != null ? queryable.getTableName() : "{none}";
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    String renderScalarIdentifierSelect(int n) {
        return this.elementType.renderScalarIdentifierSelect(n);
    }

    void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("FromElement has not been initialized!");
        }
    }

    String renderIdentifierSelect(int n, int n2) {
        return this.elementType.renderIdentifierSelect(n, n2);
    }

    String renderPropertySelect(int n, int n2) {
        return this.elementType.renderPropertySelect(n, n2, this.isAllPropertyFetch);
    }

    String renderCollectionSelectFragment(int n, int n2) {
        return this.elementType.renderCollectionSelectFragment(n, n2);
    }

    String renderValueCollectionSelectFragment(int n, int n2) {
        return this.elementType.renderValueCollectionSelectFragment(n, n2);
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public boolean isImplied() {
        return false;
    }

    public String getDisplayText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FromElement{");
        this.appendDisplayText(stringBuffer);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    protected void appendDisplayText(StringBuffer stringBuffer) {
        stringBuffer.append(this.isImplied() ? (this.isImpliedInFromClause() ? "implied in FROM clause" : "implied") : "explicit");
        stringBuffer.append(",").append(this.isCollectionJoin() ? "collection join" : "not a collection join");
        stringBuffer.append(",").append(this.fetch ? "fetch join" : "not a fetch join");
        stringBuffer.append(",").append(this.isAllPropertyFetch ? "fetch all properties" : "fetch non-lazy properties");
        stringBuffer.append(",classAlias=").append(this.getClassAlias());
        stringBuffer.append(",role=").append(this.role);
        stringBuffer.append(",tableName=").append(this.getTableName());
        stringBuffer.append(",tableAlias=").append(this.getTableAlias());
        FromElement fromElement = this.getRealOrigin();
        stringBuffer.append(",origin=").append(fromElement == null ? "null" : fromElement.getText());
        stringBuffer.append(",colums={");
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                stringBuffer.append(this.columns[i]);
                if (i >= this.columns.length) continue;
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append(",className=").append(this.className);
        stringBuffer.append("}");
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public void setJoinSequence(JoinSequence joinSequence) {
        this.elementType.setJoinSequence(joinSequence);
    }

    public JoinSequence getJoinSequence() {
        return this.elementType.getJoinSequence();
    }

    public void setIncludeSubclasses(boolean bl) {
        if (this.isDereferencedBySuperclassOrSubclassProperty() && !bl && log.isTraceEnabled()) {
            log.trace((Object)"attempt to disable subclass-inclusions", (Throwable)new Exception("stack-trace source"));
        }
        this.includeSubclasses = bl;
    }

    public boolean isIncludeSubclasses() {
        return this.includeSubclasses;
    }

    public boolean isDereferencedBySuperclassOrSubclassProperty() {
        return this.dereferencedBySubclassProperty || this.dereferencedBySuperclassProperty;
    }

    public String getIdentityColumn() {
        this.checkInitialized();
        String string = this.getTableAlias();
        if (string == null) {
            throw new IllegalStateException("No table alias for node " + this);
        }
        String string2 = this.getEntityPersister() != null && this.getEntityPersister().getEntityMetamodel() != null && this.getEntityPersister().getEntityMetamodel().hasNonIdentifierPropertyNamedId() ? this.getEntityPersister().getIdentifierPropertyName() : "id";
        String[] stringArray = this.getWalker().getStatementType() == 45 ? this.getPropertyMapping(string2).toColumns(string, string2) : this.getPropertyMapping(string2).toColumns(string2);
        String string3 = StringHelper.join(", ", stringArray);
        return stringArray.length == 1 ? string3 : "(" + string3 + ")";
    }

    public void setCollectionJoin(boolean bl) {
        this.collectionJoin = bl;
    }

    public boolean isCollectionJoin() {
        return this.collectionJoin;
    }

    public void setRole(String string) {
        this.role = string;
    }

    public void setQueryableCollection(QueryableCollection queryableCollection) {
        this.elementType.setQueryableCollection(queryableCollection);
    }

    public QueryableCollection getQueryableCollection() {
        return this.elementType.getQueryableCollection();
    }

    public void setColumns(String[] stringArray) {
        this.columns = stringArray;
    }

    public void setOrigin(FromElement fromElement, boolean bl) {
        this.origin = fromElement;
        this.manyToMany = bl;
        fromElement.addDestination(this);
        if (fromElement.getFromClause() == this.getFromClause()) {
            if (bl) {
                ASTUtil.appendSibling((AST)fromElement, (AST)this);
            } else if (!this.getWalker().isInFrom() && !this.getWalker().isInSelect()) {
                this.getFromClause().addChild((AST)this);
            } else {
                fromElement.addChild((AST)this);
            }
        } else if (!this.getWalker().isInFrom()) {
            this.getFromClause().addChild((AST)this);
        }
    }

    public boolean isManyToMany() {
        return this.manyToMany;
    }

    private void addDestination(FromElement fromElement) {
        this.destinations.add(fromElement);
    }

    public List getDestinations() {
        return this.destinations;
    }

    public FromElement getOrigin() {
        return this.origin;
    }

    public FromElement getRealOrigin() {
        if (this.origin == null) {
            return null;
        }
        if (this.origin.getText() == null || "".equals(this.origin.getText())) {
            return this.origin.getRealOrigin();
        }
        return this.origin;
    }

    public Type getPropertyType(String string, String string2) {
        return this.elementType.getPropertyType(string, string2);
    }

    public String[] toColumns(String string, String string2, boolean bl) {
        return this.elementType.toColumns(string, string2, bl);
    }

    public String[] toColumns(String string, String string2, boolean bl, boolean bl2) {
        return this.elementType.toColumns(string, string2, bl, bl2);
    }

    public PropertyMapping getPropertyMapping(String string) {
        return this.elementType.getPropertyMapping(string);
    }

    public void setFetch(boolean bl) {
        this.fetch = bl;
        if (bl && this.getWalker().isShallowQuery()) {
            throw new QueryException("fetch may not be used with scroll() or iterate()");
        }
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setFilter(boolean bl) {
        this.filter = bl;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public boolean useFromFragment() {
        this.checkInitialized();
        return !this.isImplied() || this.useFromFragment;
    }

    public void setUseFromFragment(boolean bl) {
        this.useFromFragment = bl;
    }

    public boolean useWhereFragment() {
        return this.useWhereFragment;
    }

    public void setUseWhereFragment(boolean bl) {
        this.useWhereFragment = bl;
    }

    public void setCollectionTableAlias(String string) {
        this.collectionTableAlias = string;
    }

    public String getCollectionTableAlias() {
        return this.collectionTableAlias;
    }

    public boolean isCollectionOfValuesOrComponents() {
        return this.elementType.isCollectionOfValuesOrComponents();
    }

    public boolean isEntity() {
        return this.elementType.isEntity();
    }

    public void setImpliedInFromClause(boolean bl) {
        throw new UnsupportedOperationException("Explicit FROM elements can't be implied in the FROM clause!");
    }

    public boolean isImpliedInFromClause() {
        return false;
    }

    public void setInProjectionList(boolean bl) {
    }

    public boolean inProjectionList() {
        return !this.isImplied() && this.isFromOrJoinFragment();
    }

    public boolean isFromOrJoinFragment() {
        return this.getType() == 128 || this.getType() == 130;
    }

    public boolean isAllPropertyFetch() {
        return this.isAllPropertyFetch;
    }

    public void setAllPropertyFetch(boolean bl) {
        this.isAllPropertyFetch = bl;
    }

    public String getWithClauseFragment() {
        return this.withClauseFragment;
    }

    public String getWithClauseJoinAlias() {
        return this.withClauseJoinAlias;
    }

    public void setWithClauseFragment(String string, String string2) {
        this.withClauseJoinAlias = string;
        this.withClauseFragment = string2;
    }

    public boolean hasCacheablePersister() {
        if (this.getQueryableCollection() != null) {
            return this.getQueryableCollection().hasCache();
        }
        return this.getQueryable().hasCache();
    }

    public void handlePropertyBeingDereferenced(Type type, String string) {
        if (this.getQueryableCollection() != null && CollectionProperties.isCollectionProperty(string)) {
            return;
        }
        if (type.isComponentType()) {
            return;
        }
        Queryable queryable = this.getQueryable();
        if (queryable != null) {
            try {
                Queryable.Declarer declarer = queryable.getSubclassPropertyDeclarer(string);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("handling property dereference [" + queryable.getEntityName() + " (" + this.getClassAlias() + ") -> " + string + " (" + declarer + ")]"));
                }
                if (declarer == Queryable.Declarer.SUBCLASS) {
                    this.dereferencedBySubclassProperty = true;
                    this.includeSubclasses = true;
                } else if (declarer == Queryable.Declarer.SUPERCLASS) {
                    this.dereferencedBySuperclassProperty = true;
                }
            }
            catch (QueryException queryException) {
                // empty catch block
            }
        }
    }

    public boolean isDereferencedBySuperclassProperty() {
        return this.dereferencedBySuperclassProperty;
    }

    public boolean isDereferencedBySubclassProperty() {
        return this.dereferencedBySubclassProperty;
    }
}

