/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.CollectionProperties;
import org.hibernate.hql.ast.tree.DisplayableNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.FromElementFactory;
import org.hibernate.hql.ast.tree.FromReferenceNode;
import org.hibernate.hql.ast.tree.IndexNode;
import org.hibernate.hql.ast.tree.SelectExpression;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.hql.ast.util.ColumnHelper;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class DotNode
extends FromReferenceNode
implements DisplayableNode,
SelectExpression {
    public static boolean useThetaStyleImplicitJoins = false;
    public static boolean REGRESSION_STYLE_JOIN_SUPPRESSION = false;
    public static final IllegalCollectionDereferenceExceptionBuilder DEF_ILLEGAL_COLL_DEREF_EXCP_BUILDER;
    public static IllegalCollectionDereferenceExceptionBuilder ILLEGAL_COLL_DEREF_EXCP_BUILDER;
    private static final Log log;
    private static final int DEREF_UNKNOWN = 0;
    private static final int DEREF_ENTITY = 1;
    private static final int DEREF_COMPONENT = 2;
    private static final int DEREF_COLLECTION = 3;
    private static final int DEREF_PRIMITIVE = 4;
    private static final int DEREF_IDENTIFIER = 5;
    private static final int DEREF_JAVA_CONSTANT = 6;
    private String propertyName;
    private String path;
    private String propertyPath;
    private String[] columns;
    private int joinType = 0;
    private boolean fetch = false;
    private int dereferenceType = 0;
    private FromElement impliedJoin;

    public void setJoinType(int n) {
        this.joinType = n;
    }

    private String[] getColumns() throws QueryException {
        if (this.columns == null) {
            String string = this.getLhs().getFromElement().getTableAlias();
            this.columns = this.getFromElement().toColumns(string, this.propertyPath, false);
        }
        return this.columns;
    }

    public String getDisplayText() {
        StringBuffer stringBuffer = new StringBuffer();
        FromElement fromElement = this.getFromElement();
        stringBuffer.append("{propertyName=").append(this.propertyName);
        stringBuffer.append(",dereferenceType=").append(ASTPrinter.getConstantName(this.getClass(), this.dereferenceType));
        stringBuffer.append(",propertyPath=").append(this.propertyPath);
        stringBuffer.append(",path=").append(this.getPath());
        if (fromElement != null) {
            stringBuffer.append(",tableAlias=").append(fromElement.getTableAlias());
            stringBuffer.append(",className=").append(fromElement.getClassName());
            stringBuffer.append(",classAlias=").append(fromElement.getClassAlias());
        } else {
            stringBuffer.append(",no from element");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public void resolveFirstChild() throws SemanticException {
        String string;
        FromReferenceNode fromReferenceNode = (FromReferenceNode)this.getFirstChild();
        SqlNode sqlNode = (SqlNode)fromReferenceNode.getNextSibling();
        this.propertyName = string = sqlNode.getText();
        if (this.propertyPath == null) {
            this.propertyPath = string;
        }
        fromReferenceNode.resolve(true, true, null, (AST)this);
        this.setFromElement(fromReferenceNode.getFromElement());
        this.checkSubclassOrSuperclassPropertyReference(fromReferenceNode, string);
    }

    public void resolveInFunctionCall(boolean bl, boolean bl2) throws SemanticException {
        if (this.isResolved()) {
            return;
        }
        Type type = this.prepareLhs();
        if (type != null && type.isCollectionType()) {
            this.resolveIndex(null);
        } else {
            this.resolveFirstChild();
            super.resolve(bl, bl2);
        }
    }

    public void resolveIndex(AST aST) throws SemanticException {
        if (this.isResolved()) {
            return;
        }
        Type type = this.prepareLhs();
        this.dereferenceCollection((CollectionType)type, true, true, null, aST);
    }

    public void resolve(boolean bl, boolean bl2, String string, AST aST) throws SemanticException {
        if (this.isResolved()) {
            return;
        }
        Type type = this.prepareLhs();
        if (type == null) {
            if (aST == null) {
                this.getWalker().getLiteralProcessor().lookupConstant(this);
            }
            return;
        }
        if (type.isComponentType()) {
            this.checkLhsIsNotCollection();
            this.dereferenceComponent(aST);
            this.initText();
        } else if (type.isEntityType()) {
            this.checkLhsIsNotCollection();
            this.dereferenceEntity((EntityType)type, bl2, string, bl, aST);
            this.initText();
        } else if (type.isCollectionType()) {
            this.checkLhsIsNotCollection();
            this.dereferenceCollection((CollectionType)type, bl2, false, string, aST);
        } else {
            if (!CollectionProperties.isAnyCollectionProperty(this.propertyName)) {
                this.checkLhsIsNotCollection();
            }
            this.dereferenceType = 4;
            this.initText();
        }
        this.setResolved();
    }

    private void initText() {
        String[] stringArray = this.getColumns();
        String string = StringHelper.join(", ", stringArray);
        if (stringArray.length > 1 && this.getWalker().isComparativeExpressionClause()) {
            string = "(" + string + ")";
        }
        this.setText(string);
    }

    private Type prepareLhs() throws SemanticException {
        FromReferenceNode fromReferenceNode = this.getLhs();
        fromReferenceNode.prepareForDot(this.propertyName);
        return this.getDataType();
    }

    private void dereferenceCollection(CollectionType collectionType, boolean bl, boolean bl2, String string, AST aST) throws SemanticException {
        EntityPersister entityPersister;
        Object object;
        boolean bl3;
        this.dereferenceType = 3;
        String string2 = collectionType.getRole();
        boolean bl4 = bl3 = this.getNextSibling() != null && CollectionProperties.isAnyCollectionProperty(this.getNextSibling().getText());
        if (bl3) {
            bl2 = true;
        }
        QueryableCollection queryableCollection = this.getSessionFactoryHelper().requireQueryableCollection(string2);
        String string3 = this.getPath();
        FromClause fromClause = this.getWalker().getCurrentFromClause();
        if (this.getWalker().getStatementType() != 45 && bl2 && string == null) {
            object = this.getLhs().getFromElement().getQueryable().getTableName();
            this.columns = this.getFromElement().toColumns((String)object, this.propertyPath, false, true);
        }
        object = new FromElementFactory(fromClause, this.getLhs().getFromElement(), string3, string, this.getColumns(), bl);
        FromElement fromElement = ((FromElementFactory)object).createCollection(queryableCollection, string2, this.joinType, this.fetch, bl2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dereferenceCollection() : Created new FROM element for " + string3 + " : " + fromElement));
        }
        this.setImpliedJoin(fromElement);
        this.setFromElement(fromElement);
        if (bl3) {
            fromElement.setText("");
            fromElement.setUseWhereFragment(false);
        }
        if (!bl && (entityPersister = fromElement.getEntityPersister()) != null) {
            this.getWalker().addQuerySpaces(entityPersister.getQuerySpaces());
        }
        this.getWalker().addQuerySpaces(queryableCollection.getCollectionSpaces());
    }

    private void dereferenceEntity(EntityType entityType, boolean bl, String string, boolean bl2, AST aST) throws SemanticException {
        boolean bl3;
        this.checkForCorrelatedSubquery("dereferenceEntity");
        DotNode dotNode = null;
        String string2 = this.propertyName;
        if (this.isDotNode(aST)) {
            dotNode = (DotNode)aST;
            string2 = dotNode.propertyName;
            bl3 = bl2 && !this.isReferenceToPrimaryKey(dotNode.propertyName, entityType);
        } else if (!this.getWalker().isSelectStatement()) {
            bl3 = false;
        } else if (REGRESSION_STYLE_JOIN_SUPPRESSION) {
            bl3 = bl2 && (!this.getWalker().isInSelect() || !this.getWalker().isShallowQuery());
        } else {
            boolean bl4 = bl3 = bl2 || this.getWalker().isInSelect() || this.getWalker().isInFrom();
        }
        if (bl3) {
            this.dereferenceEntityJoin(string, entityType, bl, aST);
        } else {
            this.dereferenceEntityIdentifier(string2, dotNode);
        }
    }

    private boolean isDotNode(AST aST) {
        return aST != null && aST.getType() == 15;
    }

    private void dereferenceEntityJoin(String string, EntityType entityType, boolean bl, AST aST) throws SemanticException {
        FromClause fromClause;
        FromElement fromElement;
        this.dereferenceType = 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)("dereferenceEntityJoin() : generating join for " + this.propertyName + " in " + this.getFromElement().getClassName() + " " + (string == null ? "{no alias}" : "(" + string + ")") + " parent = " + ASTUtil.getDebugString(aST)));
        }
        String string2 = entityType.getAssociatedEntityName();
        String string3 = this.getAliasGenerator().createName(string2);
        String[] stringArray = this.getColumns();
        String string4 = this.getPath();
        if (bl && this.getWalker().isInFrom()) {
            this.joinType = this.getWalker().getImpliedJoinType();
        }
        if ((fromElement = (fromClause = this.getWalker().getCurrentFromClause()).findJoinByPath(string4)) == null) {
            JoinSequence joinSequence = this.getSessionFactoryHelper().createJoinSequence(bl, entityType, string3, this.joinType, stringArray);
            FromElementFactory fromElementFactory = new FromElementFactory(fromClause, this.getLhs().getFromElement(), string4, string, stringArray, bl);
            fromElement = fromElementFactory.createEntityJoin(string2, string3, joinSequence, this.fetch, this.getWalker().isInFrom(), entityType);
        } else {
            fromClause.addDuplicateAlias(string, fromElement);
        }
        this.setImpliedJoin(fromElement);
        this.getWalker().addQuerySpaces(fromElement.getEntityPersister().getQuerySpaces());
        this.setFromElement(fromElement);
    }

    private void setImpliedJoin(FromElement fromElement) {
        DotNode dotNode;
        this.impliedJoin = fromElement;
        if (this.getFirstChild().getType() == 15 && (dotNode = (DotNode)this.getFirstChild()).getImpliedJoin() != null) {
            this.impliedJoin = dotNode.getImpliedJoin();
        }
    }

    public FromElement getImpliedJoin() {
        return this.impliedJoin;
    }

    private boolean isReferenceToPrimaryKey(String string, EntityType entityType) {
        EntityPersister entityPersister = this.getSessionFactoryHelper().getFactory().getEntityPersister(entityType.getAssociatedEntityName());
        if (entityPersister.getEntityMetamodel().hasNonIdentifierPropertyNamedId()) {
            return string.equals(entityPersister.getIdentifierPropertyName()) && entityType.isReferenceToPrimaryKey();
        }
        if ("id".equals(string)) {
            return entityType.isReferenceToPrimaryKey();
        }
        String string2 = this.getSessionFactoryHelper().getIdentifierOrUniqueKeyPropertyName(entityType);
        return string2 != null && string2.equals(string) && entityType.isReferenceToPrimaryKey();
    }

    private void checkForCorrelatedSubquery(String string) {
        if (this.isCorrelatedSubselect() && log.isDebugEnabled()) {
            log.debug((Object)(string + "() : correlated subquery"));
        }
    }

    private boolean isCorrelatedSubselect() {
        return this.getWalker().isSubQuery() && this.getFromElement().getFromClause() != this.getWalker().getCurrentFromClause();
    }

    private void checkLhsIsNotCollection() throws SemanticException {
        if (this.getLhs().getDataType() != null && this.getLhs().getDataType().isCollectionType()) {
            throw ILLEGAL_COLL_DEREF_EXCP_BUILDER.buildIllegalCollectionDereferenceException(this.propertyName, this.getLhs());
        }
    }

    private void dereferenceComponent(AST aST) {
        this.dereferenceType = 2;
        this.setPropertyNameAndPath(aST);
    }

    private void dereferenceEntityIdentifier(String string, DotNode dotNode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("dereferenceShortcut() : property " + string + " in " + this.getFromElement().getClassName() + " does not require a join."));
        }
        this.initText();
        this.setPropertyNameAndPath((AST)dotNode);
        if (dotNode != null) {
            dotNode.dereferenceType = 5;
            dotNode.setText(this.getText());
            dotNode.columns = this.getColumns();
        }
    }

    private void setPropertyNameAndPath(AST aST) {
        if (this.isDotNode(aST)) {
            DotNode dotNode = (DotNode)aST;
            AST aST2 = dotNode.getFirstChild();
            AST aST3 = aST2.getNextSibling();
            this.propertyName = aST3.getText();
            dotNode.propertyPath = this.propertyPath = this.propertyPath + "." + this.propertyName;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unresolved property path is now '" + dotNode.propertyPath + "'"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("terminal propertyPath = [" + this.propertyPath + "]"));
        }
    }

    public Type getDataType() {
        if (super.getDataType() == null) {
            FromElement fromElement = this.getLhs().getFromElement();
            if (fromElement == null) {
                return null;
            }
            Type type = fromElement.getPropertyType(this.propertyName, this.propertyPath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getDataType() : " + this.propertyPath + " -> " + type));
            }
            super.setDataType(type);
        }
        return super.getDataType();
    }

    public void setPropertyPath(String string) {
        this.propertyPath = string;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public FromReferenceNode getLhs() {
        FromReferenceNode fromReferenceNode = (FromReferenceNode)this.getFirstChild();
        if (fromReferenceNode == null) {
            throw new IllegalStateException("DOT node with no left-hand-side!");
        }
        return fromReferenceNode;
    }

    public String getPath() {
        if (this.path == null) {
            FromReferenceNode fromReferenceNode = this.getLhs();
            if (fromReferenceNode == null) {
                this.path = this.getText();
            } else {
                SqlNode sqlNode = (SqlNode)fromReferenceNode.getNextSibling();
                this.path = fromReferenceNode.getPath() + "." + sqlNode.getOriginalText();
            }
        }
        return this.path;
    }

    public void setFetch(boolean bl) {
        this.fetch = bl;
    }

    public void setScalarColumnText(int n) throws SemanticException {
        String[] stringArray = this.getColumns();
        ColumnHelper.generateScalarColumns(this, stringArray, n);
    }

    public void resolveSelectExpression() throws SemanticException {
        Object object;
        if (this.getWalker().isShallowQuery() || this.getWalker().getCurrentFromClause().isSubQuery()) {
            this.resolve(false, true);
        } else {
            this.resolve(true, false);
            object = this.getDataType();
            if (object.isEntityType()) {
                FromElement fromElement = this.getFromElement();
                fromElement.setIncludeSubclasses(true);
                if (useThetaStyleImplicitJoins) {
                    fromElement.getJoinSequence().setUseThetaStyle(true);
                    FromElement fromElement2 = fromElement.getOrigin();
                    if (fromElement2 != null) {
                        ASTUtil.makeSiblingOfParent((AST)fromElement2, (AST)fromElement);
                    }
                }
            }
        }
        for (object = this.getLhs(); object != null; object = (FromReferenceNode)object.getFirstChild()) {
            this.checkSubclassOrSuperclassPropertyReference((FromReferenceNode)object, object.getNextSibling().getText());
        }
    }

    public void setResolvedConstant(String string) {
        this.path = string;
        this.dereferenceType = 6;
        this.setResolved();
    }

    private boolean checkSubclassOrSuperclassPropertyReference(FromReferenceNode fromReferenceNode, String string) {
        FromElement fromElement;
        if (fromReferenceNode != null && !(fromReferenceNode instanceof IndexNode) && (fromElement = fromReferenceNode.getFromElement()) != null) {
            fromElement.handlePropertyBeingDereferenced(fromReferenceNode.getDataType(), string);
        }
        return false;
    }

    static {
        ILLEGAL_COLL_DEREF_EXCP_BUILDER = DEF_ILLEGAL_COLL_DEREF_EXCP_BUILDER = new IllegalCollectionDereferenceExceptionBuilder(){

            public QueryException buildIllegalCollectionDereferenceException(String string, FromReferenceNode fromReferenceNode) {
                String string2 = ASTUtil.getPathText((AST)fromReferenceNode);
                return new QueryException("illegal attempt to dereference collection [" + string2 + "] with element property reference [" + string + "]");
            }
        };
        log = LogFactory.getLog((Class)DotNode.class);
    }

    public static interface IllegalCollectionDereferenceExceptionBuilder {
        public QueryException buildIllegalCollectionDereferenceException(String var1, FromReferenceNode var2);
    }
}

