/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.hql.ast.DetailedSemanticException;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.PathNode;
import org.hibernate.hql.ast.tree.SelectExpression;
import org.hibernate.hql.ast.tree.SelectExpressionList;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class ConstructorNode
extends SelectExpressionList
implements SelectExpression {
    private Constructor constructor;
    private Type[] constructorArgumentTypes;
    private boolean isMap;
    private boolean isList;

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isList() {
        return this.isList;
    }

    public String[] getAliases() {
        SelectExpression[] selectExpressionArray = this.collectSelectExpressions();
        String[] stringArray = new String[selectExpressionArray.length];
        for (int i = 0; i < selectExpressionArray.length; ++i) {
            String string = selectExpressionArray[i].getAlias();
            stringArray[i] = string == null ? Integer.toString(i) : string;
        }
        return stringArray;
    }

    public void setScalarColumnText(int n) throws SemanticException {
        SelectExpression[] selectExpressionArray = this.collectSelectExpressions();
        for (int i = 0; i < selectExpressionArray.length; ++i) {
            SelectExpression selectExpression = selectExpressionArray[i];
            selectExpression.setScalarColumnText(i);
        }
    }

    protected AST getFirstSelectExpression() {
        return this.getFirstChild().getNextSibling();
    }

    public Type getDataType() {
        throw new UnsupportedOperationException("getDataType() is not supported by ConstructorNode!");
    }

    public void prepare() throws SemanticException {
        this.constructorArgumentTypes = this.resolveConstructorArgumentTypes();
        String string = ((PathNode)this.getFirstChild()).getPath();
        if ("map".equals(string.toLowerCase())) {
            this.isMap = true;
        } else if ("list".equals(string.toLowerCase())) {
            this.isList = true;
        } else {
            this.constructor = this.resolveConstructor(string);
        }
    }

    private Type[] resolveConstructorArgumentTypes() throws SemanticException {
        SelectExpression[] selectExpressionArray = this.collectSelectExpressions();
        if (selectExpressionArray == null) {
            return new Type[0];
        }
        Type[] typeArray = new Type[selectExpressionArray.length];
        for (int i = 0; i < selectExpressionArray.length; ++i) {
            typeArray[i] = selectExpressionArray[i].getDataType();
        }
        return typeArray;
    }

    private Constructor resolveConstructor(String string) throws SemanticException {
        String string2;
        String string3 = this.getSessionFactoryHelper().getImportedClassName(string);
        String string4 = string2 = StringHelper.isEmpty(string3) ? string : string3;
        if (string2 == null) {
            throw new SemanticException("Unable to locate class [" + string + "]");
        }
        try {
            Class clazz = ReflectHelper.classForName(string2);
            return ReflectHelper.getConstructor(clazz, this.constructorArgumentTypes);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DetailedSemanticException("Unable to locate class [" + string2 + "]", classNotFoundException);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            throw new DetailedSemanticException("Unable to locate appropriate constructor on class [" + string2 + "]", propertyNotFoundException);
        }
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public List getConstructorArgumentTypeList() {
        return Arrays.asList(this.constructorArgumentTypes);
    }

    public FromElement getFromElement() {
        return null;
    }

    public boolean isConstructor() {
        return true;
    }

    public boolean isReturnableEntity() throws SemanticException {
        return false;
    }

    public boolean isScalar() {
        return true;
    }

    public void setAlias(String string) {
        throw new UnsupportedOperationException("constructor may not be aliased");
    }

    public String getAlias() {
        throw new UnsupportedOperationException("constructor may not be aliased");
    }
}

